<?php

namespace DBSchenker\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for contactPersonType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contact person details
 * @subpackage Structs
 */
class ContactPersonType extends AbstractStructBase
{
    /**
     * The email
     * Meta information extracted from the WSDL
     * - documentation: Defines email address | Defines email of contact person | Defines email | The contact person's email address.
     * - base: xs:string
     * - maxLength: 100
     * - minOccurs: 0
     * @var string
     */
    public $email;
    /**
     * Constructor method for contactPersonType
     * @uses ContactPersonType::setEmail()
     * @param string $email
     */
    public function __construct($email = null)
    {
        $this
            ->setEmail($email);
    }
    /**
     * Get email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \DBSchenker\StructType\ContactPersonType
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($email) && mb_strlen($email) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($email)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
}
