<?php

namespace DBSchenker\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for bookingType StructType
 * Meta information extracted from the WSDL
 * - documentation: Booking type
 * @subpackage Structs
 */
class BookingType extends AbstractStructBase
{
    /**
     * The address
     * Meta information extracted from the WSDL
     * - documentation: Holds list of addresses
     * - maxOccurs: 6
     * - minOccurs: 2
     * - nillable: false
     * @var \DBSchenker\StructType\AddressType[]
     */
    public $address;
    /**
     * The incoterm
     * Meta information extracted from the WSDL
     * - documentation: Defines incoterm code
     * - minOccurs: 1
     * @var string
     */
    public $incoterm;
    /**
     * The incotermLocation
     * Meta information extracted from the WSDL
     * - documentation: Defines incoterm location
     * - base: xs:string
     * - maxLength: 250
     * - minOccurs: 1
     * @var string
     */
    public $incotermLocation;
    /**
     * The productCode
     * Meta information extracted from the WSDL
     * - documentation: Defines product code
     * - base: xs:string
     * - maxLength: 10
     * - minOccurs: 1
     * @var string
     */
    public $productCode;
    /**
     * The measurementType
     * Meta information extracted from the WSDL
     * - documentation: Defines measurement type: METRIC or IMPERIAL
     * - minOccurs: 1
     * @var string
     */
    public $measurementType;
    /**
     * The grossWeight
     * Meta information extracted from the WSDL
     * - documentation: Defines total gross weight | Holds shipment positions total gross weight | Specifies shipment position gross weight | Specifies gross weight of package line
     * - base: xs:decimal
     * - fractionDigits: 2
     * - minExclusive: 0
     * - minOccurs: 1
     * - pattern: [^\.]*(\.[0-9]{1,2})?
     * - totalDigits: 7
     * @var float
     */
    public $grossWeight;
    /**
     * The pickupDates
     * Meta information extracted from the WSDL
     * - documentation: Defines pickup dates of the Booking
     * - minOccurs: 1
     * @var \DBSchenker\StructType\PickupDate
     */
    public $pickupDates;
    /**
     * The barcodeRequest
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \DBSchenker\StructType\BarcodeRequest
     */
    public $barcodeRequest;
    /**
     * The barcodeRequestEmail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \DBSchenker\StructType\BarcodeRequestEmailType
     */
    public $barcodeRequestEmail;
    /**
     * The productOption
     * Meta information extracted from the WSDL
     * - documentation: Defines product option
     * - minOccurs: 0
     * @var string
     */
    public $productOption;
    /**
     * The cargoDescription
     * Meta information extracted from the WSDL
     * - documentation: Defines cargo description
     * - base: xs:string
     * - maxLength: 1000
     * - minOccurs: 0
     * @var string
     */
    public $cargoDescription;
    /**
     * The cargoInsurance
     * Meta information extracted from the WSDL
     * - documentation: Defines insurance value with currency
     * - minOccurs: 0
     * @var \DBSchenker\StructType\Currency
     */
    public $cargoInsurance;
    /**
     * The cashOnDelivery
     * Meta information extracted from the WSDL
     * - documentation: Defines cash on delivery amount and currency
     * - minOccurs: 0
     * @var \DBSchenker\StructType\Currency
     */
    public $cashOnDelivery;
    /**
     * The customsClearance
     * Meta information extracted from the WSDL
     * - documentation: Defines if customs clearance is required
     * @var bool
     */
    public $customsClearance;
    /**
     * The customsClearanceEu
     * Meta information extracted from the WSDL
     * - documentation: Defines if customs clearance EU is required
     * - minOccurs: 0
     * @var bool
     */
    public $customsClearanceEu;
    /**
     * The exportCustomsDeclarant
     * Meta information extracted from the WSDL
     * - documentation: Defines exportCustomsDeclarant
     * - minOccurs: 0
     * @var \DBSchenker\StructType\CustomsDeclarant
     */
    public $exportCustomsDeclarant;
    /**
     * The importCustomsDeclarant
     * Meta information extracted from the WSDL
     * - documentation: Defines importCustomsDeclarant
     * - minOccurs: 0
     * @var \DBSchenker\StructType\CustomsDeclarant
     */
    public $importCustomsDeclarant;
    /**
     * The file
     * Meta information extracted from the WSDL
     * - documentation: Holds list of files
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \DBSchenker\StructType\FileType[]
     */
    public $file;
    /**
     * The indoorDelivery
     * Meta information extracted from the WSDL
     * - documentation: Defines if indoor delivery is required
     * @var bool
     */
    public $indoorDelivery;
    /**
     * The reference
     * Meta information extracted from the WSDL
     * - documentation: Holds references
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \DBSchenker\StructType\Reference[]
     */
    public $reference;
    /**
     * The handlingInstructions
     * Meta information extracted from the WSDL
     * - documentation: Defines handling instructions
     * - base: xs:string
     * - maxLength: 2000
     * - minOccurs: 0
     * @var string
     */
    public $handlingInstructions;
    /**
     * The neutralShipping
     * Meta information extracted from the WSDL
     * - documentation: Defines a business scenario where the Schenker customer sends a booking request in the name of his ordering party
     * @var bool
     */
    public $neutralShipping;
    /**
     * The specialCargo
     * Meta information extracted from the WSDL
     * - documentation: Specifies if special cargo is required
     * @var bool
     */
    public $specialCargo;
    /**
     * The specialCargoDescription
     * Meta information extracted from the WSDL
     * - documentation: Defines special cargo description
     * - base: xs:string
     * - maxLength: 1000
     * - minOccurs: 0
     * @var string
     */
    public $specialCargoDescription;
    /**
     * The valueOfGoods
     * Meta information extracted from the WSDL
     * - documentation: Defines amount of value of goods and the currency
     * - minOccurs: 0
     * @var \DBSchenker\StructType\Currency
     */
    public $valueOfGoods;
    /**
     * The wayBillNumber
     * Meta information extracted from the WSDL
     * - documentation: Holds Waybill number
     * - base: xs:string
     * - maxLength: 100
     * - minOccurs: 0
     * @var string
     */
    public $wayBillNumber;
    /**
     * The barcodeReference
     * Meta information extracted from the WSDL
     * - documentation: Holds list of barcode references
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \DBSchenker\StructType\BarcodeReferenceType[]
     */
    public $barcodeReference;
    /**
     * The ecoNeutral
     * Meta information extracted from the WSDL
     * - documentation: Defines if shipment is eco neutral
     * - minOccurs: 0
     * @var bool
     */
    public $ecoNeutral;
    /**
     * The submitBooking
     * Meta information extracted from the WSDL
     * - documentation: Defines booking status: IN_PROCESS(false) or SUBMITTED(true)
     * @var bool
     */
    public $submitBooking;
    /**
     * The updateBooking
     * Meta information extracted from the WSDL
     * - documentation: Takes a booking id. Defines the booking to be updated.
     * - base: xs:string
     * - pattern: [\d]{6}-[\d]{6}
     * @var string
     */
    public $updateBooking;
    /**
     * The readyForConsolidation
     * Meta information extracted from the WSDL
     * - documentation: Prepares the booking for later consolidation. Can only be used with submitBooking = false!
     * @var bool
     */
    public $readyForConsolidation;
    /**
     * The immediateResponse
     * Meta information extracted from the WSDL
     * - documentation: Use if not interested in the response.
     * @var bool
     */
    public $immediateResponse;
    /**
     * The returnBarcodeReferences
     * Meta information extracted from the WSDL
     * - default: false
     * @var bool
     */
    public $returnBarcodeReferences;
    /**
     * Constructor method for bookingType
     * @uses BookingType::setAddress()
     * @uses BookingType::setIncoterm()
     * @uses BookingType::setIncotermLocation()
     * @uses BookingType::setProductCode()
     * @uses BookingType::setMeasurementType()
     * @uses BookingType::setGrossWeight()
     * @uses BookingType::setPickupDates()
     * @uses BookingType::setBarcodeRequest()
     * @uses BookingType::setBarcodeRequestEmail()
     * @uses BookingType::setProductOption()
     * @uses BookingType::setCargoDescription()
     * @uses BookingType::setCargoInsurance()
     * @uses BookingType::setCashOnDelivery()
     * @uses BookingType::setCustomsClearance()
     * @uses BookingType::setCustomsClearanceEu()
     * @uses BookingType::setExportCustomsDeclarant()
     * @uses BookingType::setImportCustomsDeclarant()
     * @uses BookingType::setFile()
     * @uses BookingType::setIndoorDelivery()
     * @uses BookingType::setReference()
     * @uses BookingType::setHandlingInstructions()
     * @uses BookingType::setNeutralShipping()
     * @uses BookingType::setSpecialCargo()
     * @uses BookingType::setSpecialCargoDescription()
     * @uses BookingType::setValueOfGoods()
     * @uses BookingType::setWayBillNumber()
     * @uses BookingType::setBarcodeReference()
     * @uses BookingType::setEcoNeutral()
     * @uses BookingType::setSubmitBooking()
     * @uses BookingType::setUpdateBooking()
     * @uses BookingType::setReadyForConsolidation()
     * @uses BookingType::setImmediateResponse()
     * @uses BookingType::setReturnBarcodeReferences()
     * @param \DBSchenker\StructType\AddressType[] $address
     * @param string $incoterm
     * @param string $incotermLocation
     * @param string $productCode
     * @param string $measurementType
     * @param float $grossWeight
     * @param \DBSchenker\StructType\PickupDate $pickupDates
     * @param \DBSchenker\StructType\BarcodeRequest $barcodeRequest
     * @param \DBSchenker\StructType\BarcodeRequestEmailType $barcodeRequestEmail
     * @param string $productOption
     * @param string $cargoDescription
     * @param \DBSchenker\StructType\Currency $cargoInsurance
     * @param \DBSchenker\StructType\Currency $cashOnDelivery
     * @param bool $customsClearance
     * @param bool $customsClearanceEu
     * @param \DBSchenker\StructType\CustomsDeclarant $exportCustomsDeclarant
     * @param \DBSchenker\StructType\CustomsDeclarant $importCustomsDeclarant
     * @param \DBSchenker\StructType\FileType[] $file
     * @param bool $indoorDelivery
     * @param \DBSchenker\StructType\Reference[] $reference
     * @param string $handlingInstructions
     * @param bool $neutralShipping
     * @param bool $specialCargo
     * @param string $specialCargoDescription
     * @param \DBSchenker\StructType\Currency $valueOfGoods
     * @param string $wayBillNumber
     * @param \DBSchenker\StructType\BarcodeReferenceType[] $barcodeReference
     * @param bool $ecoNeutral
     * @param bool $submitBooking
     * @param string $updateBooking
     * @param bool $readyForConsolidation
     * @param bool $immediateResponse
     * @param bool $returnBarcodeReferences
     */
    public function __construct(array $address = array(), $incoterm = null, $incotermLocation = null, $productCode = null, $measurementType = null, $grossWeight = null, \DBSchenker\StructType\PickupDate $pickupDates = null, \DBSchenker\StructType\BarcodeRequest $barcodeRequest = null, \DBSchenker\StructType\BarcodeRequestEmailType $barcodeRequestEmail = null, $productOption = null, $cargoDescription = null, \DBSchenker\StructType\Currency $cargoInsurance = null, \DBSchenker\StructType\Currency $cashOnDelivery = null, $customsClearance = null, $customsClearanceEu = null, \DBSchenker\StructType\CustomsDeclarant $exportCustomsDeclarant = null, \DBSchenker\StructType\CustomsDeclarant $importCustomsDeclarant = null, array $file = array(), $indoorDelivery = null, array $reference = array(), $handlingInstructions = null, $neutralShipping = null, $specialCargo = null, $specialCargoDescription = null, \DBSchenker\StructType\Currency $valueOfGoods = null, $wayBillNumber = null, array $barcodeReference = array(), $ecoNeutral = null, $submitBooking = null, $updateBooking = null, $readyForConsolidation = null, $immediateResponse = null, $returnBarcodeReferences = false)
    {
        $this
            ->setAddress($address)
            ->setIncoterm($incoterm)
            ->setIncotermLocation($incotermLocation)
            ->setProductCode($productCode)
            ->setMeasurementType($measurementType)
            ->setGrossWeight($grossWeight)
            ->setPickupDates($pickupDates)
            ->setBarcodeRequest($barcodeRequest)
            ->setBarcodeRequestEmail($barcodeRequestEmail)
            ->setProductOption($productOption)
            ->setCargoDescription($cargoDescription)
            ->setCargoInsurance($cargoInsurance)
            ->setCashOnDelivery($cashOnDelivery)
            ->setCustomsClearance($customsClearance)
            ->setCustomsClearanceEu($customsClearanceEu)
            ->setExportCustomsDeclarant($exportCustomsDeclarant)
            ->setImportCustomsDeclarant($importCustomsDeclarant)
            ->setFile($file)
            ->setIndoorDelivery($indoorDelivery)
            ->setReference($reference)
            ->setHandlingInstructions($handlingInstructions)
            ->setNeutralShipping($neutralShipping)
            ->setSpecialCargo($specialCargo)
            ->setSpecialCargoDescription($specialCargoDescription)
            ->setValueOfGoods($valueOfGoods)
            ->setWayBillNumber($wayBillNumber)
            ->setBarcodeReference($barcodeReference)
            ->setEcoNeutral($ecoNeutral)
            ->setSubmitBooking($submitBooking)
            ->setUpdateBooking($updateBooking)
            ->setReadyForConsolidation($readyForConsolidation)
            ->setImmediateResponse($immediateResponse)
            ->setReturnBarcodeReferences($returnBarcodeReferences);
    }
    /**
     * Get address value
     * @return \DBSchenker\StructType\AddressType[]
     */
    public function getAddress()
    {
        return $this->address;
    }
    /**
     * This method is responsible for validating the values passed to the setAddress method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAddress method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAddressForArrayConstraintsFromSetAddress(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $bookingTypeAddressItem) {
            // validation for constraint: itemType
            if (!$bookingTypeAddressItem instanceof \DBSchenker\StructType\AddressType) {
                $invalidValues[] = is_object($bookingTypeAddressItem) ? get_class($bookingTypeAddressItem) : sprintf('%s(%s)', gettype($bookingTypeAddressItem), var_export($bookingTypeAddressItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The address property can only contain items of type \DBSchenker\StructType\AddressType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set address value
     * @throws \InvalidArgumentException
     * @param \DBSchenker\StructType\AddressType[] $address
     * @return \DBSchenker\StructType\BookingType
     */
    public function setAddress(array $address = array())
    {
        // validation for constraint: array
        if ('' !== ($addressArrayErrorMessage = self::validateAddressForArrayConstraintsFromSetAddress($address))) {
            throw new \InvalidArgumentException($addressArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(6)
        if (is_array($address) && count($address) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 6', count($address)), __LINE__);
        }
        $this->address = $address;
        return $this;
    }
    /**
     * Add item to address value
     * @throws \InvalidArgumentException
     * @param \DBSchenker\StructType\AddressType $item
     * @return \DBSchenker\StructType\BookingType
     */
    public function addToAddress(\DBSchenker\StructType\AddressType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \DBSchenker\StructType\AddressType) {
            throw new \InvalidArgumentException(sprintf('The address property can only contain items of type \DBSchenker\StructType\AddressType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(6)
        if (is_array($this->address) && count($this->address) >= 6) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 6', count($this->address)), __LINE__);
        }
        $this->address[] = $item;
        return $this;
    }
    /**
     * Get incoterm value
     * @return string
     */
    public function getIncoterm()
    {
        return $this->incoterm;
    }
    /**
     * Set incoterm value
     * @uses \DBSchenker\EnumType\IncotermType::valueIsValid()
     * @uses \DBSchenker\EnumType\IncotermType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $incoterm
     * @return \DBSchenker\StructType\BookingType
     */
    public function setIncoterm($incoterm = null)
    {
        // validation for constraint: enumeration
        if (!\DBSchenker\EnumType\IncotermType::valueIsValid($incoterm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \DBSchenker\EnumType\IncotermType', is_array($incoterm) ? implode(', ', $incoterm) : var_export($incoterm, true), implode(', ', \DBSchenker\EnumType\IncotermType::getValidValues())), __LINE__);
        }
        $this->incoterm = $incoterm;
        return $this;
    }
    /**
     * Get incotermLocation value
     * @return string
     */
    public function getIncotermLocation()
    {
        return $this->incotermLocation;
    }
    /**
     * Set incotermLocation value
     * @param string $incotermLocation
     * @return \DBSchenker\StructType\BookingType
     */
    public function setIncotermLocation($incotermLocation = null)
    {
        // validation for constraint: string
        if (!is_null($incotermLocation) && !is_string($incotermLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($incotermLocation, true), gettype($incotermLocation)), __LINE__);
        }
        // validation for constraint: maxLength(250)
        if (!is_null($incotermLocation) && mb_strlen($incotermLocation) > 250) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 250', mb_strlen($incotermLocation)), __LINE__);
        }
        $this->incotermLocation = $incotermLocation;
        return $this;
    }
    /**
     * Get productCode value
     * @return string
     */
    public function getProductCode()
    {
        return $this->productCode;
    }
    /**
     * Set productCode value
     * @param string $productCode
     * @return \DBSchenker\StructType\BookingType
     */
    public function setProductCode($productCode = null)
    {
        // validation for constraint: string
        if (!is_null($productCode) && !is_string($productCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productCode, true), gettype($productCode)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($productCode) && mb_strlen($productCode) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($productCode)), __LINE__);
        }
        $this->productCode = $productCode;
        return $this;
    }
    /**
     * Get measurementType value
     * @return string
     */
    public function getMeasurementType()
    {
        return $this->measurementType;
    }
    /**
     * Set measurementType value
     * @uses \DBSchenker\EnumType\MeasurementType::valueIsValid()
     * @uses \DBSchenker\EnumType\MeasurementType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $measurementType
     * @return \DBSchenker\StructType\BookingType
     */
    public function setMeasurementType($measurementType = null)
    {
        // validation for constraint: enumeration
        if (!\DBSchenker\EnumType\MeasurementType::valueIsValid($measurementType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \DBSchenker\EnumType\MeasurementType', is_array($measurementType) ? implode(', ', $measurementType) : var_export($measurementType, true), implode(', ', \DBSchenker\EnumType\MeasurementType::getValidValues())), __LINE__);
        }
        $this->measurementType = $measurementType;
        return $this;
    }
    /**
     * Get grossWeight value
     * @return float
     */
    public function getGrossWeight()
    {
        return $this->grossWeight;
    }
    /**
     * Set grossWeight value
     * @param float $grossWeight
     * @return \DBSchenker\StructType\BookingType
     */
    public function setGrossWeight($grossWeight = null)
    {
        // validation for constraint: float
        if (!is_null($grossWeight) && !(is_float($grossWeight) || is_numeric($grossWeight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($grossWeight, true), gettype($grossWeight)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($grossWeight) && mb_strlen(mb_substr($grossWeight, false !== mb_strpos($grossWeight, '.') ? mb_strpos($grossWeight, '.') + 1 : mb_strlen($grossWeight))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($grossWeight, true), mb_strlen(mb_substr($grossWeight, mb_strpos($grossWeight, '.') + 1))), __LINE__);
        }
        // validation for constraint: minExclusive
        if (!is_null($grossWeight) && $grossWeight <= 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than 0', var_export($grossWeight, true)), __LINE__);
        }
        // validation for constraint: pattern([^\.]*(\.[0-9]{1,2})?)
        if (!is_null($grossWeight) && !preg_match('/[^\\.]*(\\.[0-9]{1,2})?/', $grossWeight)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [^\.]*(\.[0-9]{1,2})?', var_export($grossWeight, true)), __LINE__);
        }
        // validation for constraint: totalDigits(7)
        if (!is_null($grossWeight) && mb_strlen(preg_replace('/(\D)/', '', $grossWeight)) > 7) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 7 digits, "%d" given', var_export($grossWeight, true), mb_strlen(preg_replace('/(\D)/', '', $grossWeight))), __LINE__);
        }
        $this->grossWeight = $grossWeight;
        return $this;
    }
    /**
     * Get pickupDates value
     * @return \DBSchenker\StructType\PickupDate
     */
    public function getPickupDates()
    {
        return $this->pickupDates;
    }
    /**
     * Set pickupDates value
     * @param \DBSchenker\StructType\PickupDate $pickupDates
     * @return \DBSchenker\StructType\BookingType
     */
    public function setPickupDates(\DBSchenker\StructType\PickupDate $pickupDates = null)
    {
        $this->pickupDates = $pickupDates;
        return $this;
    }
    /**
     * Get barcodeRequest value
     * @return \DBSchenker\StructType\BarcodeRequest|null
     */
    public function getBarcodeRequest()
    {
        return $this->barcodeRequest;
    }
    /**
     * Set barcodeRequest value
     * @param \DBSchenker\StructType\BarcodeRequest $barcodeRequest
     * @return \DBSchenker\StructType\BookingType
     */
    public function setBarcodeRequest(\DBSchenker\StructType\BarcodeRequest $barcodeRequest = null)
    {
        $this->barcodeRequest = $barcodeRequest;
        return $this;
    }
    /**
     * Get barcodeRequestEmail value
     * @return \DBSchenker\StructType\BarcodeRequestEmailType|null
     */
    public function getBarcodeRequestEmail()
    {
        return $this->barcodeRequestEmail;
    }
    /**
     * Set barcodeRequestEmail value
     * @param \DBSchenker\StructType\BarcodeRequestEmailType $barcodeRequestEmail
     * @return \DBSchenker\StructType\BookingType
     */
    public function setBarcodeRequestEmail(\DBSchenker\StructType\BarcodeRequestEmailType $barcodeRequestEmail = null)
    {
        $this->barcodeRequestEmail = $barcodeRequestEmail;
        return $this;
    }
    /**
     * Get productOption value
     * @return string|null
     */
    public function getProductOption()
    {
        return $this->productOption;
    }
    /**
     * Set productOption value
     * @param string $productOption
     * @return \DBSchenker\StructType\BookingType
     */
    public function setProductOption($productOption = null)
    {
        // validation for constraint: string
        if (!is_null($productOption) && !is_string($productOption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productOption, true), gettype($productOption)), __LINE__);
        }
        $this->productOption = $productOption;
        return $this;
    }
    /**
     * Get cargoDescription value
     * @return string|null
     */
    public function getCargoDescription()
    {
        return $this->cargoDescription;
    }
    /**
     * Set cargoDescription value
     * @param string $cargoDescription
     * @return \DBSchenker\StructType\BookingType
     */
    public function setCargoDescription($cargoDescription = null)
    {
        // validation for constraint: string
        if (!is_null($cargoDescription) && !is_string($cargoDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cargoDescription, true), gettype($cargoDescription)), __LINE__);
        }
        // validation for constraint: maxLength(1000)
        if (!is_null($cargoDescription) && mb_strlen($cargoDescription) > 1000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1000', mb_strlen($cargoDescription)), __LINE__);
        }
        $this->cargoDescription = $cargoDescription;
        return $this;
    }
    /**
     * Get cargoInsurance value
     * @return \DBSchenker\StructType\Currency|null
     */
    public function getCargoInsurance()
    {
        return $this->cargoInsurance;
    }
    /**
     * Set cargoInsurance value
     * @param \DBSchenker\StructType\Currency $cargoInsurance
     * @return \DBSchenker\StructType\BookingType
     */
    public function setCargoInsurance(\DBSchenker\StructType\Currency $cargoInsurance = null)
    {
        $this->cargoInsurance = $cargoInsurance;
        return $this;
    }
    /**
     * Get cashOnDelivery value
     * @return \DBSchenker\StructType\Currency|null
     */
    public function getCashOnDelivery()
    {
        return $this->cashOnDelivery;
    }
    /**
     * Set cashOnDelivery value
     * @param \DBSchenker\StructType\Currency $cashOnDelivery
     * @return \DBSchenker\StructType\BookingType
     */
    public function setCashOnDelivery(\DBSchenker\StructType\Currency $cashOnDelivery = null)
    {
        $this->cashOnDelivery = $cashOnDelivery;
        return $this;
    }
    /**
     * Get customsClearance value
     * @return bool|null
     */
    public function getCustomsClearance()
    {
        return $this->customsClearance;
    }
    /**
     * Set customsClearance value
     * @param bool $customsClearance
     * @return \DBSchenker\StructType\BookingType
     */
    public function setCustomsClearance($customsClearance = null)
    {
        // validation for constraint: boolean
        if (!is_null($customsClearance) && !is_bool($customsClearance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($customsClearance, true), gettype($customsClearance)), __LINE__);
        }
        $this->customsClearance = $customsClearance;
        return $this;
    }
    /**
     * Get customsClearanceEu value
     * @return bool|null
     */
    public function getCustomsClearanceEu()
    {
        return $this->customsClearanceEu;
    }
    /**
     * Set customsClearanceEu value
     * @param bool $customsClearanceEu
     * @return \DBSchenker\StructType\BookingType
     */
    public function setCustomsClearanceEu($customsClearanceEu = null)
    {
        // validation for constraint: boolean
        if (!is_null($customsClearanceEu) && !is_bool($customsClearanceEu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($customsClearanceEu, true), gettype($customsClearanceEu)), __LINE__);
        }
        $this->customsClearanceEu = $customsClearanceEu;
        return $this;
    }
    /**
     * Get exportCustomsDeclarant value
     * @return \DBSchenker\StructType\CustomsDeclarant|null
     */
    public function getExportCustomsDeclarant()
    {
        return $this->exportCustomsDeclarant;
    }
    /**
     * Set exportCustomsDeclarant value
     * @param \DBSchenker\StructType\CustomsDeclarant $exportCustomsDeclarant
     * @return \DBSchenker\StructType\BookingType
     */
    public function setExportCustomsDeclarant(\DBSchenker\StructType\CustomsDeclarant $exportCustomsDeclarant = null)
    {
        $this->exportCustomsDeclarant = $exportCustomsDeclarant;
        return $this;
    }
    /**
     * Get importCustomsDeclarant value
     * @return \DBSchenker\StructType\CustomsDeclarant|null
     */
    public function getImportCustomsDeclarant()
    {
        return $this->importCustomsDeclarant;
    }
    /**
     * Set importCustomsDeclarant value
     * @param \DBSchenker\StructType\CustomsDeclarant $importCustomsDeclarant
     * @return \DBSchenker\StructType\BookingType
     */
    public function setImportCustomsDeclarant(\DBSchenker\StructType\CustomsDeclarant $importCustomsDeclarant = null)
    {
        $this->importCustomsDeclarant = $importCustomsDeclarant;
        return $this;
    }
    /**
     * Get file value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \DBSchenker\StructType\FileType[]|null
     */
    public function getFile()
    {
        return isset($this->file) ? $this->file : null;
    }
    /**
     * This method is responsible for validating the values passed to the setFile method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFile method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFileForArrayConstraintsFromSetFile(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $bookingTypeFileItem) {
            // validation for constraint: itemType
            if (!$bookingTypeFileItem instanceof \DBSchenker\StructType\FileType) {
                $invalidValues[] = is_object($bookingTypeFileItem) ? get_class($bookingTypeFileItem) : sprintf('%s(%s)', gettype($bookingTypeFileItem), var_export($bookingTypeFileItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The file property can only contain items of type \DBSchenker\StructType\FileType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set file value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \DBSchenker\StructType\FileType[] $file
     * @return \DBSchenker\StructType\BookingType
     */
    public function setFile(array $file = array())
    {
        // validation for constraint: array
        if ('' !== ($fileArrayErrorMessage = self::validateFileForArrayConstraintsFromSetFile($file))) {
            throw new \InvalidArgumentException($fileArrayErrorMessage, __LINE__);
        }
        if (is_null($file) || (is_array($file) && empty($file))) {
            unset($this->file);
        } else {
            $this->file = $file;
        }
        return $this;
    }
    /**
     * Add item to file value
     * @throws \InvalidArgumentException
     * @param \DBSchenker\StructType\FileType $item
     * @return \DBSchenker\StructType\BookingType
     */
    public function addToFile(\DBSchenker\StructType\FileType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \DBSchenker\StructType\FileType) {
            throw new \InvalidArgumentException(sprintf('The file property can only contain items of type \DBSchenker\StructType\FileType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->file[] = $item;
        return $this;
    }
    /**
     * Get indoorDelivery value
     * @return bool|null
     */
    public function getIndoorDelivery()
    {
        return $this->indoorDelivery;
    }
    /**
     * Set indoorDelivery value
     * @param bool $indoorDelivery
     * @return \DBSchenker\StructType\BookingType
     */
    public function setIndoorDelivery($indoorDelivery = null)
    {
        // validation for constraint: boolean
        if (!is_null($indoorDelivery) && !is_bool($indoorDelivery)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($indoorDelivery, true), gettype($indoorDelivery)), __LINE__);
        }
        $this->indoorDelivery = $indoorDelivery;
        return $this;
    }
    /**
     * Get reference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \DBSchenker\StructType\Reference[]|null
     */
    public function getReference()
    {
        return isset($this->reference) ? $this->reference : null;
    }
    /**
     * This method is responsible for validating the values passed to the setReference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReferenceForArrayConstraintsFromSetReference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $bookingTypeReferenceItem) {
            // validation for constraint: itemType
            if (!$bookingTypeReferenceItem instanceof \DBSchenker\StructType\Reference) {
                $invalidValues[] = is_object($bookingTypeReferenceItem) ? get_class($bookingTypeReferenceItem) : sprintf('%s(%s)', gettype($bookingTypeReferenceItem), var_export($bookingTypeReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The reference property can only contain items of type \DBSchenker\StructType\Reference, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set reference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \DBSchenker\StructType\Reference[] $reference
     * @return \DBSchenker\StructType\BookingType
     */
    public function setReference(array $reference = array())
    {
        // validation for constraint: array
        if ('' !== ($referenceArrayErrorMessage = self::validateReferenceForArrayConstraintsFromSetReference($reference))) {
            throw new \InvalidArgumentException($referenceArrayErrorMessage, __LINE__);
        }
        if (is_null($reference) || (is_array($reference) && empty($reference))) {
            unset($this->reference);
        } else {
            $this->reference = $reference;
        }
        return $this;
    }
    /**
     * Add item to reference value
     * @throws \InvalidArgumentException
     * @param \DBSchenker\StructType\Reference $item
     * @return \DBSchenker\StructType\BookingType
     */
    public function addToReference(\DBSchenker\StructType\Reference $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \DBSchenker\StructType\Reference) {
            throw new \InvalidArgumentException(sprintf('The reference property can only contain items of type \DBSchenker\StructType\Reference, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->reference[] = $item;
        return $this;
    }
    /**
     * Get handlingInstructions value
     * @return string|null
     */
    public function getHandlingInstructions()
    {
        return $this->handlingInstructions;
    }
    /**
     * Set handlingInstructions value
     * @param string $handlingInstructions
     * @return \DBSchenker\StructType\BookingType
     */
    public function setHandlingInstructions($handlingInstructions = null)
    {
        // validation for constraint: string
        if (!is_null($handlingInstructions) && !is_string($handlingInstructions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($handlingInstructions, true), gettype($handlingInstructions)), __LINE__);
        }
        // validation for constraint: maxLength(2000)
        if (!is_null($handlingInstructions) && mb_strlen($handlingInstructions) > 2000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2000', mb_strlen($handlingInstructions)), __LINE__);
        }
        $this->handlingInstructions = $handlingInstructions;
        return $this;
    }
    /**
     * Get neutralShipping value
     * @return bool|null
     */
    public function getNeutralShipping()
    {
        return $this->neutralShipping;
    }
    /**
     * Set neutralShipping value
     * @param bool $neutralShipping
     * @return \DBSchenker\StructType\BookingType
     */
    public function setNeutralShipping($neutralShipping = null)
    {
        // validation for constraint: boolean
        if (!is_null($neutralShipping) && !is_bool($neutralShipping)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($neutralShipping, true), gettype($neutralShipping)), __LINE__);
        }
        $this->neutralShipping = $neutralShipping;
        return $this;
    }
    /**
     * Get specialCargo value
     * @return bool|null
     */
    public function getSpecialCargo()
    {
        return $this->specialCargo;
    }
    /**
     * Set specialCargo value
     * @param bool $specialCargo
     * @return \DBSchenker\StructType\BookingType
     */
    public function setSpecialCargo($specialCargo = null)
    {
        // validation for constraint: boolean
        if (!is_null($specialCargo) && !is_bool($specialCargo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($specialCargo, true), gettype($specialCargo)), __LINE__);
        }
        $this->specialCargo = $specialCargo;
        return $this;
    }
    /**
     * Get specialCargoDescription value
     * @return string|null
     */
    public function getSpecialCargoDescription()
    {
        return $this->specialCargoDescription;
    }
    /**
     * Set specialCargoDescription value
     * @param string $specialCargoDescription
     * @return \DBSchenker\StructType\BookingType
     */
    public function setSpecialCargoDescription($specialCargoDescription = null)
    {
        // validation for constraint: string
        if (!is_null($specialCargoDescription) && !is_string($specialCargoDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($specialCargoDescription, true), gettype($specialCargoDescription)), __LINE__);
        }
        // validation for constraint: maxLength(1000)
        if (!is_null($specialCargoDescription) && mb_strlen($specialCargoDescription) > 1000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1000', mb_strlen($specialCargoDescription)), __LINE__);
        }
        $this->specialCargoDescription = $specialCargoDescription;
        return $this;
    }
    /**
     * Get valueOfGoods value
     * @return \DBSchenker\StructType\Currency|null
     */
    public function getValueOfGoods()
    {
        return $this->valueOfGoods;
    }
    /**
     * Set valueOfGoods value
     * @param \DBSchenker\StructType\Currency $valueOfGoods
     * @return \DBSchenker\StructType\BookingType
     */
    public function setValueOfGoods(\DBSchenker\StructType\Currency $valueOfGoods = null)
    {
        $this->valueOfGoods = $valueOfGoods;
        return $this;
    }
    /**
     * Get wayBillNumber value
     * @return string|null
     */
    public function getWayBillNumber()
    {
        return $this->wayBillNumber;
    }
    /**
     * Set wayBillNumber value
     * @param string $wayBillNumber
     * @return \DBSchenker\StructType\BookingType
     */
    public function setWayBillNumber($wayBillNumber = null)
    {
        // validation for constraint: string
        if (!is_null($wayBillNumber) && !is_string($wayBillNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($wayBillNumber, true), gettype($wayBillNumber)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($wayBillNumber) && mb_strlen($wayBillNumber) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($wayBillNumber)), __LINE__);
        }
        $this->wayBillNumber = $wayBillNumber;
        return $this;
    }
    /**
     * Get barcodeReference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \DBSchenker\StructType\BarcodeReferenceType[]|null
     */
    public function getBarcodeReference()
    {
        return isset($this->barcodeReference) ? $this->barcodeReference : null;
    }
    /**
     * This method is responsible for validating the values passed to the setBarcodeReference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBarcodeReference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBarcodeReferenceForArrayConstraintsFromSetBarcodeReference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $bookingTypeBarcodeReferenceItem) {
            // validation for constraint: itemType
            if (!$bookingTypeBarcodeReferenceItem instanceof \DBSchenker\StructType\BarcodeReferenceType) {
                $invalidValues[] = is_object($bookingTypeBarcodeReferenceItem) ? get_class($bookingTypeBarcodeReferenceItem) : sprintf('%s(%s)', gettype($bookingTypeBarcodeReferenceItem), var_export($bookingTypeBarcodeReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The barcodeReference property can only contain items of type \DBSchenker\StructType\BarcodeReferenceType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set barcodeReference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \DBSchenker\StructType\BarcodeReferenceType[] $barcodeReference
     * @return \DBSchenker\StructType\BookingType
     */
    public function setBarcodeReference(array $barcodeReference = array())
    {
        // validation for constraint: array
        if ('' !== ($barcodeReferenceArrayErrorMessage = self::validateBarcodeReferenceForArrayConstraintsFromSetBarcodeReference($barcodeReference))) {
            throw new \InvalidArgumentException($barcodeReferenceArrayErrorMessage, __LINE__);
        }
        if (is_null($barcodeReference) || (is_array($barcodeReference) && empty($barcodeReference))) {
            unset($this->barcodeReference);
        } else {
            $this->barcodeReference = $barcodeReference;
        }
        return $this;
    }
    /**
     * Add item to barcodeReference value
     * @throws \InvalidArgumentException
     * @param \DBSchenker\StructType\BarcodeReferenceType $item
     * @return \DBSchenker\StructType\BookingType
     */
    public function addToBarcodeReference(\DBSchenker\StructType\BarcodeReferenceType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \DBSchenker\StructType\BarcodeReferenceType) {
            throw new \InvalidArgumentException(sprintf('The barcodeReference property can only contain items of type \DBSchenker\StructType\BarcodeReferenceType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->barcodeReference[] = $item;
        return $this;
    }
    /**
     * Get ecoNeutral value
     * @return bool|null
     */
    public function getEcoNeutral()
    {
        return $this->ecoNeutral;
    }
    /**
     * Set ecoNeutral value
     * @param bool $ecoNeutral
     * @return \DBSchenker\StructType\BookingType
     */
    public function setEcoNeutral($ecoNeutral = null)
    {
        // validation for constraint: boolean
        if (!is_null($ecoNeutral) && !is_bool($ecoNeutral)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($ecoNeutral, true), gettype($ecoNeutral)), __LINE__);
        }
        $this->ecoNeutral = $ecoNeutral;
        return $this;
    }
    /**
     * Get submitBooking value
     * @return bool|null
     */
    public function getSubmitBooking()
    {
        return $this->submitBooking;
    }
    /**
     * Set submitBooking value
     * @param bool $submitBooking
     * @return \DBSchenker\StructType\BookingType
     */
    public function setSubmitBooking($submitBooking = null)
    {
        // validation for constraint: boolean
        if (!is_null($submitBooking) && !is_bool($submitBooking)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($submitBooking, true), gettype($submitBooking)), __LINE__);
        }
        $this->submitBooking = $submitBooking;
        return $this;
    }
    /**
     * Get updateBooking value
     * @return string|null
     */
    public function getUpdateBooking()
    {
        return $this->updateBooking;
    }
    /**
     * Set updateBooking value
     * @param string $updateBooking
     * @return \DBSchenker\StructType\BookingType
     */
    public function setUpdateBooking($updateBooking = null)
    {
        // validation for constraint: string
        if (!is_null($updateBooking) && !is_string($updateBooking)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($updateBooking, true), gettype($updateBooking)), __LINE__);
        }
        // validation for constraint: pattern([\d]{6}-[\d]{6})
        if (!is_null($updateBooking) && !preg_match('/[\\d]{6}-[\\d]{6}/', $updateBooking)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\d]{6}-[\d]{6}', var_export($updateBooking, true)), __LINE__);
        }
        $this->updateBooking = $updateBooking;
        return $this;
    }
    /**
     * Get readyForConsolidation value
     * @return bool|null
     */
    public function getReadyForConsolidation()
    {
        return $this->readyForConsolidation;
    }
    /**
     * Set readyForConsolidation value
     * @param bool $readyForConsolidation
     * @return \DBSchenker\StructType\BookingType
     */
    public function setReadyForConsolidation($readyForConsolidation = null)
    {
        // validation for constraint: boolean
        if (!is_null($readyForConsolidation) && !is_bool($readyForConsolidation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($readyForConsolidation, true), gettype($readyForConsolidation)), __LINE__);
        }
        $this->readyForConsolidation = $readyForConsolidation;
        return $this;
    }
    /**
     * Get immediateResponse value
     * @return bool|null
     */
    public function getImmediateResponse()
    {
        return $this->immediateResponse;
    }
    /**
     * Set immediateResponse value
     * @param bool $immediateResponse
     * @return \DBSchenker\StructType\BookingType
     */
    public function setImmediateResponse($immediateResponse = null)
    {
        // validation for constraint: boolean
        if (!is_null($immediateResponse) && !is_bool($immediateResponse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($immediateResponse, true), gettype($immediateResponse)), __LINE__);
        }
        $this->immediateResponse = $immediateResponse;
        return $this;
    }
    /**
     * Get returnBarcodeReferences value
     * @return bool|null
     */
    public function getReturnBarcodeReferences()
    {
        return $this->returnBarcodeReferences;
    }
    /**
     * Set returnBarcodeReferences value
     * @param bool $returnBarcodeReferences
     * @return \DBSchenker\StructType\BookingType
     */
    public function setReturnBarcodeReferences($returnBarcodeReferences = false)
    {
        // validation for constraint: boolean
        if (!is_null($returnBarcodeReferences) && !is_bool($returnBarcodeReferences)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($returnBarcodeReferences, true), gettype($returnBarcodeReferences)), __LINE__);
        }
        $this->returnBarcodeReferences = $returnBarcodeReferences;
        return $this;
    }
}
