<?php

namespace DBSchenker\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for bookingLandType StructType
 * Meta information extracted from the WSDL
 * - documentation: Defines Land Booking
 * @subpackage Structs
 */
class BookingLandType extends BookingType
{
    /**
     * The serviceType
     * Meta information extracted from the WSDL
     * - documentation: Defines service type: D2D
     * - minOccurs: 1
     * @var string
     */
    public $serviceType;
    /**
     * The shippingInformation
     * Meta information extracted from the WSDL
     * - documentation: Holds the land shipping information
     * - minOccurs: 1
     * @var \DBSchenker\StructType\ShippingInformationType
     */
    public $shippingInformation;
    /**
     * The measureUnit
     * Meta information extracted from the WSDL
     * - documentation: Holds measure unit: VOLUME, LOADING_METERS, PIECES, PALLET_SPACE
     * - minOccurs: 1
     * @var string
     */
    public $measureUnit;
    /**
     * The incotermDestinationType
     * Meta information extracted from the WSDL
     * - documentation: Defines incoterm destination type
     * - minOccurs: 0
     * @var string
     */
    public $incotermDestinationType;
    /**
     * The preAdviseToConsignee
     * Meta information extracted from the WSDL
     * - documentation: Holds the preAdviseToConsignee contact
     * - minOccurs: 0
     * @var \DBSchenker\StructType\PreAdvise
     */
    public $preAdviseToConsignee;
    /**
     * The deliveryDateConsignee
     * Meta information extracted from the WSDL
     * - documentation: Defines delivery date consignee
     * - minOccurs: 0
     * - nillable: true
     * @var \DBSchenker\StructType\DeliveryDateConsignee
     */
    public $deliveryDateConsignee;
    /**
     * The express
     * Meta information extracted from the WSDL
     * - documentation: Defines if shipment is express
     * @var bool
     */
    public $express;
    /**
     * The foodRelated
     * Meta information extracted from the WSDL
     * - documentation: Defines if shipment is food related
     * @var bool
     */
    public $foodRelated;
    /**
     * The heatedTransport
     * Meta information extracted from the WSDL
     * - documentation: Defines if shipment is required heated transport
     * @var bool
     */
    public $heatedTransport;
    /**
     * The homeDelivery
     * Meta information extracted from the WSDL
     * - documentation: Defines if shipment is required home delivery
     * @var bool
     */
    public $homeDelivery;
    /**
     * The measureUnitLoadingMeters
     * Meta information extracted from the WSDL
     * - documentation: Holds measure unit loading meters
     * - base: xs:decimal
     * - fractionDigits: 2
     * - minExclusive: 0
     * - minOccurs: 0
     * - pattern: [^\.]*(\.[0-9]{1,2})?
     * - totalDigits: 5
     * @var float
     */
    public $measureUnitLoadingMeters;
    /**
     * The measureUnitPalletSpace
     * Meta information extracted from the WSDL
     * - documentation: Holds measure unit pallet space
     * - base: xs:decimal
     * - fractionDigits: 2
     * - minExclusive: 0
     * - minOccurs: 0
     * - pattern: [^\.]*(\.[0-9]{1,2})?
     * - totalDigits: 9
     * @var float
     */
    public $measureUnitPalletSpace;
    /**
     * The measureUnitPieces
     * Meta information extracted from the WSDL
     * - documentation: Holds measure unit pieces
     * - minOccurs: 0
     * @var int
     */
    public $measureUnitPieces;
    /**
     * The measureUnitVolume
     * Meta information extracted from the WSDL
     * - documentation: Holds measure unit volume
     * - base: xs:decimal
     * - fractionDigits: 2
     * - minExclusive: 0
     * - minOccurs: 0
     * - pattern: [^\.]*(\.[0-9]{1,2})?
     * - totalDigits: 9
     * @var float
     */
    public $measureUnitVolume;
    /**
     * The ownPickup
     * Meta information extracted from the WSDL
     * - documentation: Defines is shipment requires own pickup
     * @var bool
     */
    public $ownPickup;
    /**
     * The pharmaceuticals
     * Meta information extracted from the WSDL
     * - documentation: Defines if shipment is pharmaceutical
     * @var bool
     */
    public $pharmaceuticals;
    /**
     * The driverPreAdvise
     * Meta information extracted from the WSDL
     * - documentation: Defines if shipment requires pre advise to driver
     * - minOccurs: 0
     * @var \DBSchenker\StructType\PreAdvise
     */
    public $driverPreAdvise;
    /**
     * The transportTemperature
     * Meta information extracted from the WSDL
     * - documentation: Defines if shipment requires transport temperature
     * - minOccurs: 0
     * @var \DBSchenker\StructType\Temperature
     */
    public $transportTemperature;
    /**
     * The returnPallet
     * Meta information extracted from the WSDL
     * - documentation: Defines if shipment requires returning pallets
     * - minOccurs: 0
     * @var \DBSchenker\StructType\ReturnPallet
     */
    public $returnPallet;
    /**
     * The loadingDevice
     * Meta information extracted from the WSDL
     * - documentation: Defines if shipment requires loading devices
     * - minOccurs: 0
     * @var \DBSchenker\StructType\LoadingDevice
     */
    public $loadingDevice;
    /**
     * The preAdviseToConsigneeEmail
     * Meta information extracted from the WSDL
     * - documentation: Defines if shipment requires pre advise to consignee via email
     * - base: xs:string
     * - maxLength: 80
     * - minOccurs: 0
     * @var string
     */
    public $preAdviseToConsigneeEmail;
    /**
     * The frostFree
     * Meta information extracted from the WSDL
     * - documentation: Defines if shipment is required to be frost free
     * - minOccurs: 0
     * @var bool
     */
    public $frostFree;
    /**
     * The preNotice
     * Meta information extracted from the WSDL
     * - documentation: Holds the preNotice contact
     * - minOccurs: 0
     * @var \DBSchenker\StructType\PreAdvise
     */
    public $preNotice;
    /**
     * The deliveryDateFixToBeAgreed
     * Meta information extracted from the WSDL
     * - documentation: Holds the deliveryDateFixToBeAgreed contact
     * - minOccurs: 0
     * @var \DBSchenker\StructType\PreAdvise
     */
    public $deliveryDateFixToBeAgreed;
    /**
     * The customData
     * Meta information extracted from the WSDL
     * - documentation: Custom data. Usage has to be aligned with Schenker.
     * - base: xs:string
     * - maxLength: 1000
     * - minOccurs: 0
     * @var string
     */
    public $customData;
    /**
     * The preadviseToPickup
     * Meta information extracted from the WSDL
     * - documentation: Defines preadvise to Pickup (Consignor)
     * - minOccurs: 0
     * @var \DBSchenker\StructType\PreAdvise
     */
    public $preadviseToPickup;
    /**
     * The equipment
     * Meta information extracted from the WSDL
     * - documentation: Defines the Equipment
     * - minOccurs: 0
     * @var \DBSchenker\StructType\LandEquipmentType
     */
    public $equipment;
    /**
     * The loadSecuringEquipment
     * Meta information extracted from the WSDL
     * - documentation: Defines the Load Securing Equipments
     * - maxOccurs: 4
     * - minOccurs: 0
     * @var \DBSchenker\StructType\LoadSecuringEquipmentType[]
     */
    public $loadSecuringEquipment;
    /**
     * The palletExchange
     * Meta information extracted from the WSDL
     * - documentation: Defines if shipment requires pallet exchange
     * - minOccurs: 0
     * @var bool
     */
    public $palletExchange;
    /**
     * The mixedLoadingRestriction
     * Meta information extracted from the WSDL
     * - documentation: Defines if shipment has mixed loading restrictions
     * - minOccurs: 0
     * @var bool
     */
    public $mixedLoadingRestriction;
    /**
     * The mixedLoadingRestrictionDescription
     * Meta information extracted from the WSDL
     * - documentation: Describes mixed loading restrictions
     * - minOccurs: 0
     * @var string
     */
    public $mixedLoadingRestrictionDescription;
    /**
     * The transShipmentRestriction
     * Meta information extracted from the WSDL
     * - documentation: Defines if shipment has trans-shipment restrictions
     * - minOccurs: 0
     * @var bool
     */
    public $transShipmentRestriction;
    /**
     * The liftingPlatform
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $liftingPlatform;
    /**
     * The ekaerNumber
     * Meta information extracted from the WSDL
     * - documentation: Can be applied for shipments with destination country HU. EKAER number only contains alphanumeric characters with a maximum of 15 characters and always needs to start with an E
     * - base: xs:string
     * - minOccurs: 0
     * - pattern: E[a-zA-Z0-9]{0,14}
     * @var string
     */
    public $ekaerNumber;
    /**
     * The printCmrEmail
     * Meta information extracted from the WSDL
     * - documentation: CMR will be sent on confirmation from your responsible Schenker office
     * - base: xs:string
     * - maxLength: 250
     * - minOccurs: 0
     * - pattern: [^@]+@[^\.]+\..+
     * @var string
     */
    public $printCmrEmail;
    /**
     * The sentApplicable
     * Meta information extracted from the WSDL
     * - documentation: Can be applied for shipments with departure or destination country PL.
     * - minOccurs: 0
     * @var \DBSchenker\StructType\SentApplicable
     */
    public $sentApplicable;
    /**
     * The longGoods
     * Meta information extracted from the WSDL
     * - documentation: Long goods specification. Can be used with the DB SCHENKERsystem product.
     * - minOccurs: 0
     * @var string
     */
    public $longGoods;
    /**
     * The nextDayCollection
     * Meta information extracted from the WSDL
     * - documentation: Use only in conjunction with the following products: DB SCHENKERfull load (71) / DB SCHENKERpart load (72). Please note that this service is not part of our standard frameset and may require a higher and individual pricing.
     * - minOccurs: 0
     * @var bool
     */
    public $nextDayCollection;
    /**
     * The proofOfDelivery
     * Meta information extracted from the WSDL
     * - documentation: Proof of Delivery (POD).
     * - minOccurs: 0
     * @var bool
     */
    public $proofOfDelivery;
    /**
     * The preNoticePickup
     * Meta information extracted from the WSDL
     * - documentation: Pre-Notice before pick-up
     * - minOccurs: 0
     * @var \DBSchenker\StructType\PreNoticeContactType
     */
    public $preNoticePickup;
    /**
     * The preNoticeDelivery
     * Meta information extracted from the WSDL
     * - documentation: Pre-Notice before delivery
     * - minOccurs: 0
     * @var \DBSchenker\StructType\PreNoticeContactType
     */
    public $preNoticeDelivery;
    /**
     * The fixDayPickup
     * Meta information extracted from the WSDL
     * - documentation: Use only in conjunction with the following products: DB SCHENKERfull load (71) / DB SCHENKERpart load (72). Please note that this service is not part of our standard frameset and may require a higher and individual pricing.
     * - minOccurs: 0
     * @var bool
     */
    public $fixDayPickup;
    /**
     * The timeWindowPickup
     * Meta information extracted from the WSDL
     * - documentation: Use only in conjunction with the following products: DB SCHENKERfull load (71) / DB SCHENKERpart load (72). Please note that this service is not part of our standard frameset and may require a higher and individual pricing.
     * - minOccurs: 0
     * @var string
     */
    public $timeWindowPickup;
    /**
     * The timeWindowDelivery
     * Meta information extracted from the WSDL
     * - documentation: Use only in conjunction with the following products: DB SCHENKERfull load (71) / DB SCHENKERpart load (72). Please note that this service is not part of our standard frameset and may require a higher and individual pricing.
     * - minOccurs: 0
     * @var string
     */
    public $timeWindowDelivery;
    /**
     * The specialLoadingSpecification
     * Meta information extracted from the WSDL
     * - documentation: Use only in conjunction with the following products: DB SCHENKERfull load (71) / DB SCHENKERpart load (72). Please note that this service is not part of our standard frameset and may require a higher and individual pricing.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $specialLoadingSpecification;
    /**
     * The partloadPickedUp
     * Meta information extracted from the WSDL
     * - documentation: Partload picked up
     * - minOccurs: 0
     * @var bool
     */
    public $partloadPickedUp;
    /**
     * The giroservice
     * Meta information extracted from the WSDL
     * - documentation: Giroservice
     * - minOccurs: 0
     * @var bool
     */
    public $giroservice;
    /**
     * The giroserviceNetFreightSurcharge
     * Meta information extracted from the WSDL
     * - documentation: Giroservice with net freight surcharge
     * - minOccurs: 0
     * @var bool
     */
    public $giroserviceNetFreightSurcharge;
    /**
     * The giroserviceRegularShippingSurcharge
     * Meta information extracted from the WSDL
     * - documentation: Giroservice with regular shipping surcharge
     * - minOccurs: 0
     * @var bool
     */
    public $giroserviceRegularShippingSurcharge;
    /**
     * The schenkerSpecial
     * Meta information extracted from the WSDL
     * - documentation: Schenker special
     * - minOccurs: 0
     * @var bool
     */
    public $schenkerSpecial;
    /**
     * The reshipping
     * Meta information extracted from the WSDL
     * - documentation: Reshipping
     * - minOccurs: 0
     * @var bool
     */
    public $reshipping;
    /**
     * The privateDeliveryInside
     * Meta information extracted from the WSDL
     * - documentation: Private delivery, delivered inside
     * - minOccurs: 0
     * @var bool
     */
    public $privateDeliveryInside;
    /**
     * The privateDeliveryAtWork
     * Meta information extracted from the WSDL
     * - documentation: Private delivery, at work
     * - minOccurs: 0
     * @var bool
     */
    public $privateDeliveryAtWork;
    /**
     * The privateDeliveryInsideReturnablePackaging
     * Meta information extracted from the WSDL
     * - documentation: Private delivery, delivered inside with returnable packaging
     * - minOccurs: 0
     * @var bool
     */
    public $privateDeliveryInsideReturnablePackaging;
    /**
     * The privateDeliveryInsideReturnOfOldDevice
     * Meta information extracted from the WSDL
     * - documentation: Private delivery, delivered inside with return of old device
     * - minOccurs: 0
     * @var bool
     */
    public $privateDeliveryInsideReturnOfOldDevice;
    /**
     * The privateDeliveryInsideReturnablePackagingOldDevice
     * Meta information extracted from the WSDL
     * - documentation: Private delivery, delivered inside with returnable packaging and return of old device
     * - minOccurs: 0
     * @var bool
     */
    public $privateDeliveryInsideReturnablePackagingOldDevice;
    /**
     * The returnShipment
     * Meta information extracted from the WSDL
     * - documentation: Return shipment
     * - minOccurs: 0
     * @var bool
     */
    public $returnShipment;
    /**
     * The dispersionAgreement
     * Meta information extracted from the WSDL
     * - documentation: Dispersion Agreement
     * - minOccurs: 0
     * @var bool
     */
    public $dispersionAgreement;
    /**
     * The customsClearanceImportShipmentSentToCustomsWarehouse
     * Meta information extracted from the WSDL
     * - documentation: Customs pass - customs clearance import shipment sent to customs warehouse
     * - minOccurs: 0
     * @var bool
     */
    public $customsClearanceImportShipmentSentToCustomsWarehouse;
    /**
     * The refrigerated
     * Meta information extracted from the WSDL
     * - documentation: Refrigerated
     * - minOccurs: 0
     * @var bool
     */
    public $refrigerated;
    /**
     * The volumeGoods
     * Meta information extracted from the WSDL
     * - documentation: Volume goods
     * - minOccurs: 0
     * @var bool
     */
    public $volumeGoods;
    /**
     * The deliveryPreNoticeSms
     * Meta information extracted from the WSDL
     * - documentation: Delivery Pre-Notice SMS
     * - minOccurs: 0
     * @var \DBSchenker\StructType\DeliveryPreNoticeSmsType
     */
    public $deliveryPreNoticeSms;
    /**
     * The deliveryPreNoticeEmail
     * Meta information extracted from the WSDL
     * - documentation: Delivery Pre-Notice Email
     * - minOccurs: 0
     * @var \DBSchenker\StructType\DeliveryPreNoticeEmailType
     */
    public $deliveryPreNoticeEmail;
    /**
     * The assistanceDriverDelivery
     * Meta information extracted from the WSDL
     * - documentation: Assistance driver (delivery)
     * - minOccurs: 0
     * @var bool
     */
    public $assistanceDriverDelivery;
    /**
     * The assistanceDriverPickup
     * Meta information extracted from the WSDL
     * - documentation: Assistance driver (pickup)
     * - minOccurs: 0
     * @var bool
     */
    public $assistanceDriverPickup;
    /**
     * The indoorPickup
     * Meta information extracted from the WSDL
     * - documentation: Indoor Pickup
     * - minOccurs: 0
     * @var bool
     */
    public $indoorPickup;
    /**
     * The unmannedLocationDelivery
     * Meta information extracted from the WSDL
     * - documentation: Unmanned location (delivery)
     * - minOccurs: 0
     * @var bool
     */
    public $unmannedLocationDelivery;
    /**
     * The unmannedLocationPickup
     * Meta information extracted from the WSDL
     * - documentation: Unmanned location (pickup)
     * - minOccurs: 0
     * @var bool
     */
    public $unmannedLocationPickup;
    /**
     * The craneServiceDelivery
     * Meta information extracted from the WSDL
     * - documentation: Crane service (delivery)
     * - minOccurs: 0
     * @var bool
     */
    public $craneServiceDelivery;
    /**
     * The craneServicePickup
     * Meta information extracted from the WSDL
     * - documentation: Crane service (pickup)
     * - minOccurs: 0
     * @var bool
     */
    public $craneServicePickup;
    /**
     * The recycling
     * Meta information extracted from the WSDL
     * - documentation: Recycling - Amount of products. Service available only on agreement
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $recycling;
    /**
     * The removalAndRecyclingOfPackagingMaterial
     * Meta information extracted from the WSDL
     * - documentation: Removal and recycling of packaging material
     * - minOccurs: 0
     * @var bool
     */
    public $removalAndRecyclingOfPackagingMaterial;
    /**
     * The sar
     * Meta information extracted from the WSDL
     * - documentation: Shipper's Scanned Delivery Note
     * - minOccurs: 0
     * @var bool
     */
    public $sar;
    /**
     * The pharma
     * Meta information extracted from the WSDL
     * - documentation: Service dedicated to the transport of drugs at ambient temperature
     * - minOccurs: 0
     * @var bool
     */
    public $pharma;
    /**
     * The pallet
     * Meta information extracted from the WSDL
     * - documentation: Pallet special courier
     * - minOccurs: 0
     * @var bool
     */
    public $pallet;
    /**
     * The weCare
     * Meta information extracted from the WSDL
     * - documentation: We Care
     * - minOccurs: 0
     * @var bool
     */
    public $weCare;
    /**
     * The expressFr
     * Meta information extracted from the WSDL
     * - documentation: Express (FR)
     * - minOccurs: 0
     * @var bool
     */
    public $expressFr;
    /**
     * Constructor method for bookingLandType
     * @uses BookingLandType::setServiceType()
     * @uses BookingLandType::setShippingInformation()
     * @uses BookingLandType::setMeasureUnit()
     * @uses BookingLandType::setIncotermDestinationType()
     * @uses BookingLandType::setPreAdviseToConsignee()
     * @uses BookingLandType::setDeliveryDateConsignee()
     * @uses BookingLandType::setExpress()
     * @uses BookingLandType::setFoodRelated()
     * @uses BookingLandType::setHeatedTransport()
     * @uses BookingLandType::setHomeDelivery()
     * @uses BookingLandType::setMeasureUnitLoadingMeters()
     * @uses BookingLandType::setMeasureUnitPalletSpace()
     * @uses BookingLandType::setMeasureUnitPieces()
     * @uses BookingLandType::setMeasureUnitVolume()
     * @uses BookingLandType::setOwnPickup()
     * @uses BookingLandType::setPharmaceuticals()
     * @uses BookingLandType::setDriverPreAdvise()
     * @uses BookingLandType::setTransportTemperature()
     * @uses BookingLandType::setReturnPallet()
     * @uses BookingLandType::setLoadingDevice()
     * @uses BookingLandType::setPreAdviseToConsigneeEmail()
     * @uses BookingLandType::setFrostFree()
     * @uses BookingLandType::setPreNotice()
     * @uses BookingLandType::setDeliveryDateFixToBeAgreed()
     * @uses BookingLandType::setCustomData()
     * @uses BookingLandType::setPreadviseToPickup()
     * @uses BookingLandType::setEquipment()
     * @uses BookingLandType::setLoadSecuringEquipment()
     * @uses BookingLandType::setPalletExchange()
     * @uses BookingLandType::setMixedLoadingRestriction()
     * @uses BookingLandType::setMixedLoadingRestrictionDescription()
     * @uses BookingLandType::setTransShipmentRestriction()
     * @uses BookingLandType::setLiftingPlatform()
     * @uses BookingLandType::setEkaerNumber()
     * @uses BookingLandType::setPrintCmrEmail()
     * @uses BookingLandType::setSentApplicable()
     * @uses BookingLandType::setLongGoods()
     * @uses BookingLandType::setNextDayCollection()
     * @uses BookingLandType::setProofOfDelivery()
     * @uses BookingLandType::setPreNoticePickup()
     * @uses BookingLandType::setPreNoticeDelivery()
     * @uses BookingLandType::setFixDayPickup()
     * @uses BookingLandType::setTimeWindowPickup()
     * @uses BookingLandType::setTimeWindowDelivery()
     * @uses BookingLandType::setSpecialLoadingSpecification()
     * @uses BookingLandType::setPartloadPickedUp()
     * @uses BookingLandType::setGiroservice()
     * @uses BookingLandType::setGiroserviceNetFreightSurcharge()
     * @uses BookingLandType::setGiroserviceRegularShippingSurcharge()
     * @uses BookingLandType::setSchenkerSpecial()
     * @uses BookingLandType::setReshipping()
     * @uses BookingLandType::setPrivateDeliveryInside()
     * @uses BookingLandType::setPrivateDeliveryAtWork()
     * @uses BookingLandType::setPrivateDeliveryInsideReturnablePackaging()
     * @uses BookingLandType::setPrivateDeliveryInsideReturnOfOldDevice()
     * @uses BookingLandType::setPrivateDeliveryInsideReturnablePackagingOldDevice()
     * @uses BookingLandType::setReturnShipment()
     * @uses BookingLandType::setDispersionAgreement()
     * @uses BookingLandType::setCustomsClearanceImportShipmentSentToCustomsWarehouse()
     * @uses BookingLandType::setRefrigerated()
     * @uses BookingLandType::setVolumeGoods()
     * @uses BookingLandType::setDeliveryPreNoticeSms()
     * @uses BookingLandType::setDeliveryPreNoticeEmail()
     * @uses BookingLandType::setAssistanceDriverDelivery()
     * @uses BookingLandType::setAssistanceDriverPickup()
     * @uses BookingLandType::setIndoorPickup()
     * @uses BookingLandType::setUnmannedLocationDelivery()
     * @uses BookingLandType::setUnmannedLocationPickup()
     * @uses BookingLandType::setCraneServiceDelivery()
     * @uses BookingLandType::setCraneServicePickup()
     * @uses BookingLandType::setRecycling()
     * @uses BookingLandType::setRemovalAndRecyclingOfPackagingMaterial()
     * @uses BookingLandType::setSar()
     * @uses BookingLandType::setPharma()
     * @uses BookingLandType::setPallet()
     * @uses BookingLandType::setWeCare()
     * @uses BookingLandType::setExpressFr()
     * @param string $serviceType
     * @param \DBSchenker\StructType\ShippingInformationType $shippingInformation
     * @param string $measureUnit
     * @param string $incotermDestinationType
     * @param \DBSchenker\StructType\PreAdvise $preAdviseToConsignee
     * @param \DBSchenker\StructType\DeliveryDateConsignee $deliveryDateConsignee
     * @param bool $express
     * @param bool $foodRelated
     * @param bool $heatedTransport
     * @param bool $homeDelivery
     * @param float $measureUnitLoadingMeters
     * @param float $measureUnitPalletSpace
     * @param int $measureUnitPieces
     * @param float $measureUnitVolume
     * @param bool $ownPickup
     * @param bool $pharmaceuticals
     * @param \DBSchenker\StructType\PreAdvise $driverPreAdvise
     * @param \DBSchenker\StructType\Temperature $transportTemperature
     * @param \DBSchenker\StructType\ReturnPallet $returnPallet
     * @param \DBSchenker\StructType\LoadingDevice $loadingDevice
     * @param string $preAdviseToConsigneeEmail
     * @param bool $frostFree
     * @param \DBSchenker\StructType\PreAdvise $preNotice
     * @param \DBSchenker\StructType\PreAdvise $deliveryDateFixToBeAgreed
     * @param string $customData
     * @param \DBSchenker\StructType\PreAdvise $preadviseToPickup
     * @param \DBSchenker\StructType\LandEquipmentType $equipment
     * @param \DBSchenker\StructType\LoadSecuringEquipmentType[] $loadSecuringEquipment
     * @param bool $palletExchange
     * @param bool $mixedLoadingRestriction
     * @param string $mixedLoadingRestrictionDescription
     * @param bool $transShipmentRestriction
     * @param string[] $liftingPlatform
     * @param string $ekaerNumber
     * @param string $printCmrEmail
     * @param \DBSchenker\StructType\SentApplicable $sentApplicable
     * @param string $longGoods
     * @param bool $nextDayCollection
     * @param bool $proofOfDelivery
     * @param \DBSchenker\StructType\PreNoticeContactType $preNoticePickup
     * @param \DBSchenker\StructType\PreNoticeContactType $preNoticeDelivery
     * @param bool $fixDayPickup
     * @param string $timeWindowPickup
     * @param string $timeWindowDelivery
     * @param string[] $specialLoadingSpecification
     * @param bool $partloadPickedUp
     * @param bool $giroservice
     * @param bool $giroserviceNetFreightSurcharge
     * @param bool $giroserviceRegularShippingSurcharge
     * @param bool $schenkerSpecial
     * @param bool $reshipping
     * @param bool $privateDeliveryInside
     * @param bool $privateDeliveryAtWork
     * @param bool $privateDeliveryInsideReturnablePackaging
     * @param bool $privateDeliveryInsideReturnOfOldDevice
     * @param bool $privateDeliveryInsideReturnablePackagingOldDevice
     * @param bool $returnShipment
     * @param bool $dispersionAgreement
     * @param bool $customsClearanceImportShipmentSentToCustomsWarehouse
     * @param bool $refrigerated
     * @param bool $volumeGoods
     * @param \DBSchenker\StructType\DeliveryPreNoticeSmsType $deliveryPreNoticeSms
     * @param \DBSchenker\StructType\DeliveryPreNoticeEmailType $deliveryPreNoticeEmail
     * @param bool $assistanceDriverDelivery
     * @param bool $assistanceDriverPickup
     * @param bool $indoorPickup
     * @param bool $unmannedLocationDelivery
     * @param bool $unmannedLocationPickup
     * @param bool $craneServiceDelivery
     * @param bool $craneServicePickup
     * @param int $recycling
     * @param bool $removalAndRecyclingOfPackagingMaterial
     * @param bool $sar
     * @param bool $pharma
     * @param bool $pallet
     * @param bool $weCare
     * @param bool $expressFr
     */
    public function __construct($serviceType = null, \DBSchenker\StructType\ShippingInformationType $shippingInformation = null, $measureUnit = null, $incotermDestinationType = null, \DBSchenker\StructType\PreAdvise $preAdviseToConsignee = null, \DBSchenker\StructType\DeliveryDateConsignee $deliveryDateConsignee = null, $express = null, $foodRelated = null, $heatedTransport = null, $homeDelivery = null, $measureUnitLoadingMeters = null, $measureUnitPalletSpace = null, $measureUnitPieces = null, $measureUnitVolume = null, $ownPickup = null, $pharmaceuticals = null, \DBSchenker\StructType\PreAdvise $driverPreAdvise = null, \DBSchenker\StructType\Temperature $transportTemperature = null, \DBSchenker\StructType\ReturnPallet $returnPallet = null, \DBSchenker\StructType\LoadingDevice $loadingDevice = null, $preAdviseToConsigneeEmail = null, $frostFree = null, \DBSchenker\StructType\PreAdvise $preNotice = null, \DBSchenker\StructType\PreAdvise $deliveryDateFixToBeAgreed = null, $customData = null, \DBSchenker\StructType\PreAdvise $preadviseToPickup = null, \DBSchenker\StructType\LandEquipmentType $equipment = null, array $loadSecuringEquipment = array(), $palletExchange = null, $mixedLoadingRestriction = null, $mixedLoadingRestrictionDescription = null, $transShipmentRestriction = null, array $liftingPlatform = array(), $ekaerNumber = null, $printCmrEmail = null, \DBSchenker\StructType\SentApplicable $sentApplicable = null, $longGoods = null, $nextDayCollection = null, $proofOfDelivery = null, \DBSchenker\StructType\PreNoticeContactType $preNoticePickup = null, \DBSchenker\StructType\PreNoticeContactType $preNoticeDelivery = null, $fixDayPickup = null, $timeWindowPickup = null, $timeWindowDelivery = null, array $specialLoadingSpecification = array(), $partloadPickedUp = null, $giroservice = null, $giroserviceNetFreightSurcharge = null, $giroserviceRegularShippingSurcharge = null, $schenkerSpecial = null, $reshipping = null, $privateDeliveryInside = null, $privateDeliveryAtWork = null, $privateDeliveryInsideReturnablePackaging = null, $privateDeliveryInsideReturnOfOldDevice = null, $privateDeliveryInsideReturnablePackagingOldDevice = null, $returnShipment = null, $dispersionAgreement = null, $customsClearanceImportShipmentSentToCustomsWarehouse = null, $refrigerated = null, $volumeGoods = null, \DBSchenker\StructType\DeliveryPreNoticeSmsType $deliveryPreNoticeSms = null, \DBSchenker\StructType\DeliveryPreNoticeEmailType $deliveryPreNoticeEmail = null, $assistanceDriverDelivery = null, $assistanceDriverPickup = null, $indoorPickup = null, $unmannedLocationDelivery = null, $unmannedLocationPickup = null, $craneServiceDelivery = null, $craneServicePickup = null, $recycling = null, $removalAndRecyclingOfPackagingMaterial = null, $sar = null, $pharma = null, $pallet = null, $weCare = null, $expressFr = null)
    {
        $this
            ->setServiceType($serviceType)
            ->setShippingInformation($shippingInformation)
            ->setMeasureUnit($measureUnit)
            ->setIncotermDestinationType($incotermDestinationType)
            ->setPreAdviseToConsignee($preAdviseToConsignee)
            ->setDeliveryDateConsignee($deliveryDateConsignee)
            ->setExpress($express)
            ->setFoodRelated($foodRelated)
            ->setHeatedTransport($heatedTransport)
            ->setHomeDelivery($homeDelivery)
            ->setMeasureUnitLoadingMeters($measureUnitLoadingMeters)
            ->setMeasureUnitPalletSpace($measureUnitPalletSpace)
            ->setMeasureUnitPieces($measureUnitPieces)
            ->setMeasureUnitVolume($measureUnitVolume)
            ->setOwnPickup($ownPickup)
            ->setPharmaceuticals($pharmaceuticals)
            ->setDriverPreAdvise($driverPreAdvise)
            ->setTransportTemperature($transportTemperature)
            ->setReturnPallet($returnPallet)
            ->setLoadingDevice($loadingDevice)
            ->setPreAdviseToConsigneeEmail($preAdviseToConsigneeEmail)
            ->setFrostFree($frostFree)
            ->setPreNotice($preNotice)
            ->setDeliveryDateFixToBeAgreed($deliveryDateFixToBeAgreed)
            ->setCustomData($customData)
            ->setPreadviseToPickup($preadviseToPickup)
            ->setEquipment($equipment)
            ->setLoadSecuringEquipment($loadSecuringEquipment)
            ->setPalletExchange($palletExchange)
            ->setMixedLoadingRestriction($mixedLoadingRestriction)
            ->setMixedLoadingRestrictionDescription($mixedLoadingRestrictionDescription)
            ->setTransShipmentRestriction($transShipmentRestriction)
            ->setLiftingPlatform($liftingPlatform)
            ->setEkaerNumber($ekaerNumber)
            ->setPrintCmrEmail($printCmrEmail)
            ->setSentApplicable($sentApplicable)
            ->setLongGoods($longGoods)
            ->setNextDayCollection($nextDayCollection)
            ->setProofOfDelivery($proofOfDelivery)
            ->setPreNoticePickup($preNoticePickup)
            ->setPreNoticeDelivery($preNoticeDelivery)
            ->setFixDayPickup($fixDayPickup)
            ->setTimeWindowPickup($timeWindowPickup)
            ->setTimeWindowDelivery($timeWindowDelivery)
            ->setSpecialLoadingSpecification($specialLoadingSpecification)
            ->setPartloadPickedUp($partloadPickedUp)
            ->setGiroservice($giroservice)
            ->setGiroserviceNetFreightSurcharge($giroserviceNetFreightSurcharge)
            ->setGiroserviceRegularShippingSurcharge($giroserviceRegularShippingSurcharge)
            ->setSchenkerSpecial($schenkerSpecial)
            ->setReshipping($reshipping)
            ->setPrivateDeliveryInside($privateDeliveryInside)
            ->setPrivateDeliveryAtWork($privateDeliveryAtWork)
            ->setPrivateDeliveryInsideReturnablePackaging($privateDeliveryInsideReturnablePackaging)
            ->setPrivateDeliveryInsideReturnOfOldDevice($privateDeliveryInsideReturnOfOldDevice)
            ->setPrivateDeliveryInsideReturnablePackagingOldDevice($privateDeliveryInsideReturnablePackagingOldDevice)
            ->setReturnShipment($returnShipment)
            ->setDispersionAgreement($dispersionAgreement)
            ->setCustomsClearanceImportShipmentSentToCustomsWarehouse($customsClearanceImportShipmentSentToCustomsWarehouse)
            ->setRefrigerated($refrigerated)
            ->setVolumeGoods($volumeGoods)
            ->setDeliveryPreNoticeSms($deliveryPreNoticeSms)
            ->setDeliveryPreNoticeEmail($deliveryPreNoticeEmail)
            ->setAssistanceDriverDelivery($assistanceDriverDelivery)
            ->setAssistanceDriverPickup($assistanceDriverPickup)
            ->setIndoorPickup($indoorPickup)
            ->setUnmannedLocationDelivery($unmannedLocationDelivery)
            ->setUnmannedLocationPickup($unmannedLocationPickup)
            ->setCraneServiceDelivery($craneServiceDelivery)
            ->setCraneServicePickup($craneServicePickup)
            ->setRecycling($recycling)
            ->setRemovalAndRecyclingOfPackagingMaterial($removalAndRecyclingOfPackagingMaterial)
            ->setSar($sar)
            ->setPharma($pharma)
            ->setPallet($pallet)
            ->setWeCare($weCare)
            ->setExpressFr($expressFr);
    }
    /**
     * Get serviceType value
     * @return string
     */
    public function getServiceType()
    {
        return $this->serviceType;
    }
    /**
     * Set serviceType value
     * @uses \DBSchenker\EnumType\ServiceLandType::valueIsValid()
     * @uses \DBSchenker\EnumType\ServiceLandType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $serviceType
     * @return \DBSchenker\StructType\BookingLandType
     */
    public function setServiceType($serviceType = null)
    {
        // validation for constraint: enumeration
        if (!\DBSchenker\EnumType\ServiceLandType::valueIsValid($serviceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \DBSchenker\EnumType\ServiceLandType', is_array($serviceType) ? implode(', ', $serviceType) : var_export($serviceType, true), implode(', ', \DBSchenker\EnumType\ServiceLandType::getValidValues())), __LINE__);
        }
        $this->serviceType = $serviceType;
        return $this;
    }
    /**
     * Get shippingInformation value
     * @return \DBSchenker\StructType\ShippingInformationType
     */
    public function getShippingInformation()
    {
        return $this->shippingInformation;
    }
    /**
     * Set shippingInformation value
     * @param \DBSchenker\StructType\ShippingInformationType $shippingInformation
     * @return \DBSchenker\StructType\BookingLandType
     */
    public function setShippingInformation(\DBSchenker\StructType\ShippingInformationType $shippingInformation = null)
    {
        $this->shippingInformation = $shippingInformation;
        return $this;
    }
    /**
     * Get measureUnit value
     * @return string
     */
    public function getMeasureUnit()
    {
        return $this->measureUnit;
    }
    /**
     * Set measureUnit value
     * @uses \DBSchenker\EnumType\MeasureUnitType::valueIsValid()
     * @uses \DBSchenker\EnumType\MeasureUnitType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $measureUnit
     * @return \DBSchenker\StructType\BookingLandType
     */
    public function setMeasureUnit($measureUnit = null)
    {
        // validation for constraint: enumeration
        if (!\DBSchenker\EnumType\MeasureUnitType::valueIsValid($measureUnit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \DBSchenker\EnumType\MeasureUnitType', is_array($measureUnit) ? implode(', ', $measureUnit) : var_export($measureUnit, true), implode(', ', \DBSchenker\EnumType\MeasureUnitType::getValidValues())), __LINE__);
        }
        $this->measureUnit = $measureUnit;
        return $this;
    }
    /**
     * Get incotermDestinationType value
     * @return string|null
     */
    public function getIncotermDestinationType()
    {
        return $this->incotermDestinationType;
    }
    /**
     * Set incotermDestinationType value
     * @uses \DBSchenker\EnumType\IncotermDestinationType::valueIsValid()
     * @uses \DBSchenker\EnumType\IncotermDestinationType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $incotermDestinationType
     * @return \DBSchenker\StructType\BookingLandType
     */
    public function setIncotermDestinationType($incotermDestinationType = null)
    {
        // validation for constraint: enumeration
        if (!\DBSchenker\EnumType\IncotermDestinationType::valueIsValid($incotermDestinationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \DBSchenker\EnumType\IncotermDestinationType', is_array($incotermDestinationType) ? implode(', ', $incotermDestinationType) : var_export($incotermDestinationType, true), implode(', ', \DBSchenker\EnumType\IncotermDestinationType::getValidValues())), __LINE__);
        }
        $this->incotermDestinationType = $incotermDestinationType;
        return $this;
    }
    /**
     * Get preAdviseToConsignee value
     * @return \DBSchenker\StructType\PreAdvise|null
     */
    public function getPreAdviseToConsignee()
    {
        return $this->preAdviseToConsignee;
    }
    /**
     * Set preAdviseToConsignee value
     * @param \DBSchenker\StructType\PreAdvise $preAdviseToConsignee
     * @return \DBSchenker\StructType\BookingLandType
     */
    public function setPreAdviseToConsignee(\DBSchenker\StructType\PreAdvise $preAdviseToConsignee = null)
    {
        $this->preAdviseToConsignee = $preAdviseToConsignee;
        return $this;
    }
    /**
     * Get deliveryDateConsignee value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \DBSchenker\StructType\DeliveryDateConsignee|null
     */
    public function getDeliveryDateConsignee()
    {
        return isset($this->deliveryDateConsignee) ? $this->deliveryDateConsignee : null;
    }
    /**
     * Set deliveryDateConsignee value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \DBSchenker\StructType\DeliveryDateConsignee $deliveryDateConsignee
     * @return \DBSchenker\StructType\BookingLandType
     */
    public function setDeliveryDateConsignee(\DBSchenker\StructType\DeliveryDateConsignee $deliveryDateConsignee = null)
    {
        if (is_null($deliveryDateConsignee) || (is_array($deliveryDateConsignee) && empty($deliveryDateConsignee))) {
            unset($this->deliveryDateConsignee);
        } else {
            $this->deliveryDateConsignee = $deliveryDateConsignee;
        }
        return $this;
    }
    /**
     * Get express value
     * @return bool|null
     */
    public function getExpress()
    {
        return $this->express;
    }
    /**
     * Set express value
     * @param bool $express
     * @return \DBSchenker\StructType\BookingLandType
     */
    public function setExpress($express = null)
    {
        // validation for constraint: boolean
        if (!is_null($express) && !is_bool($express)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($express, true), gettype($express)), __LINE__);
        }
        $this->express = $express;
        return $this;
    }
    /**
     * Get foodRelated value
     * @return bool|null
     */
    public function getFoodRelated()
    {
        return $this->foodRelated;
    }
    /**
     * Set foodRelated value
     * @param bool $foodRelated
     * @return \DBSchenker\StructType\BookingLandType
     */
    public function setFoodRelated($foodRelated = null)
    {
        // validation for constraint: boolean
        if (!is_null($foodRelated) && !is_bool($foodRelated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($foodRelated, true), gettype($foodRelated)), __LINE__);
        }
        $this->foodRelated = $foodRelated;
        return $this;
    }
    /**
     * Get heatedTransport value
     * @return bool|null
     */
    public function getHeatedTransport()
    {
        return $this->heatedTransport;
    }
    /**
     * Set heatedTransport value
     * @param bool $heatedTransport
     * @return \DBSchenker\StructType\BookingLandType
     */
    public function setHeatedTransport($heatedTransport = null)
    {
        // validation for constraint: boolean
        if (!is_null($heatedTransport) && !is_bool($heatedTransport)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($heatedTransport, true), gettype($heatedTransport)), __LINE__);
        }
        $this->heatedTransport = $heatedTransport;
        return $this;
    }
    /**
     * Get homeDelivery value
     * @return bool|null
     */
    public function getHomeDelivery()
    {
        return $this->homeDelivery;
    }
    /**
     * Set homeDelivery value
     * @param bool $homeDelivery
     * @return \DBSchenker\StructType\BookingLandType
     */
    public function setHomeDelivery($homeDelivery = null)
    {
        // validation for constraint: boolean
        if (!is_null($homeDelivery) && !is_bool($homeDelivery)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($homeDelivery, true), gettype($homeDelivery)), __LINE__);
        }
        $this->homeDelivery = $homeDelivery;
        return $this;
    }
    /**
     * Get measureUnitLoadingMeters value
     * @return float|null
     */
    public function getMeasureUnitLoadingMeters()
    {
        return $this->measureUnitLoadingMeters;
    }
    /**
     * Set measureUnitLoadingMeters value
     * @param float $measureUnitLoadingMeters
     * @return \DBSchenker\StructType\BookingLandType
     */
    public function setMeasureUnitLoadingMeters($measureUnitLoadingMeters = null)
    {
        // validation for constraint: float
        if (!is_null($measureUnitLoadingMeters) && !(is_float($measureUnitLoadingMeters) || is_numeric($measureUnitLoadingMeters))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($measureUnitLoadingMeters, true), gettype($measureUnitLoadingMeters)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($measureUnitLoadingMeters) && mb_strlen(mb_substr($measureUnitLoadingMeters, false !== mb_strpos($measureUnitLoadingMeters, '.') ? mb_strpos($measureUnitLoadingMeters, '.') + 1 : mb_strlen($measureUnitLoadingMeters))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($measureUnitLoadingMeters, true), mb_strlen(mb_substr($measureUnitLoadingMeters, mb_strpos($measureUnitLoadingMeters, '.') + 1))), __LINE__);
        }
        // validation for constraint: minExclusive
        if (!is_null($measureUnitLoadingMeters) && $measureUnitLoadingMeters <= 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than 0', var_export($measureUnitLoadingMeters, true)), __LINE__);
        }
        // validation for constraint: pattern([^\.]*(\.[0-9]{1,2})?)
        if (!is_null($measureUnitLoadingMeters) && !preg_match('/[^\\.]*(\\.[0-9]{1,2})?/', $measureUnitLoadingMeters)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [^\.]*(\.[0-9]{1,2})?', var_export($measureUnitLoadingMeters, true)), __LINE__);
        }
        // validation for constraint: totalDigits(5)
        if (!is_null($measureUnitLoadingMeters) && mb_strlen(preg_replace('/(\D)/', '', $measureUnitLoadingMeters)) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 5 digits, "%d" given', var_export($measureUnitLoadingMeters, true), mb_strlen(preg_replace('/(\D)/', '', $measureUnitLoadingMeters))), __LINE__);
        }
        $this->measureUnitLoadingMeters = $measureUnitLoadingMeters;
        return $this;
    }
    /**
     * Get measureUnitPalletSpace value
     * @return float|null
     */
    public function getMeasureUnitPalletSpace()
    {
        return $this->measureUnitPalletSpace;
    }
    /**
     * Set measureUnitPalletSpace value
     * @param float $measureUnitPalletSpace
     * @return \DBSchenker\StructType\BookingLandType
     */
    public function setMeasureUnitPalletSpace($measureUnitPalletSpace = null)
    {
        // validation for constraint: float
        if (!is_null($measureUnitPalletSpace) && !(is_float($measureUnitPalletSpace) || is_numeric($measureUnitPalletSpace))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($measureUnitPalletSpace, true), gettype($measureUnitPalletSpace)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($measureUnitPalletSpace) && mb_strlen(mb_substr($measureUnitPalletSpace, false !== mb_strpos($measureUnitPalletSpace, '.') ? mb_strpos($measureUnitPalletSpace, '.') + 1 : mb_strlen($measureUnitPalletSpace))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($measureUnitPalletSpace, true), mb_strlen(mb_substr($measureUnitPalletSpace, mb_strpos($measureUnitPalletSpace, '.') + 1))), __LINE__);
        }
        // validation for constraint: minExclusive
        if (!is_null($measureUnitPalletSpace) && $measureUnitPalletSpace <= 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than 0', var_export($measureUnitPalletSpace, true)), __LINE__);
        }
        // validation for constraint: pattern([^\.]*(\.[0-9]{1,2})?)
        if (!is_null($measureUnitPalletSpace) && !preg_match('/[^\\.]*(\\.[0-9]{1,2})?/', $measureUnitPalletSpace)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [^\.]*(\.[0-9]{1,2})?', var_export($measureUnitPalletSpace, true)), __LINE__);
        }
        // validation for constraint: totalDigits(9)
        if (!is_null($measureUnitPalletSpace) && mb_strlen(preg_replace('/(\D)/', '', $measureUnitPalletSpace)) > 9) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 9 digits, "%d" given', var_export($measureUnitPalletSpace, true), mb_strlen(preg_replace('/(\D)/', '', $measureUnitPalletSpace))), __LINE__);
        }
        $this->measureUnitPalletSpace = $measureUnitPalletSpace;
        return $this;
    }
    /**
     * Get measureUnitPieces value
     * @return int|null
     */
    public function getMeasureUnitPieces()
    {
        return $this->measureUnitPieces;
    }
    /**
     * Set measureUnitPieces value
     * @param int $measureUnitPieces
     * @return \DBSchenker\StructType\BookingLandType
     */
    public function setMeasureUnitPieces($measureUnitPieces = null)
    {
        // validation for constraint: int
        if (!is_null($measureUnitPieces) && !(is_int($measureUnitPieces) || ctype_digit($measureUnitPieces))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($measureUnitPieces, true), gettype($measureUnitPieces)), __LINE__);
        }
        $this->measureUnitPieces = $measureUnitPieces;
        return $this;
    }
    /**
     * Get measureUnitVolume value
     * @return float|null
     */
    public function getMeasureUnitVolume()
    {
        return $this->measureUnitVolume;
    }
    /**
     * Set measureUnitVolume value
     * @param float $measureUnitVolume
     * @return \DBSchenker\StructType\BookingLandType
     */
    public function setMeasureUnitVolume($measureUnitVolume = null)
    {
        // validation for constraint: float
        if (!is_null($measureUnitVolume) && !(is_float($measureUnitVolume) || is_numeric($measureUnitVolume))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($measureUnitVolume, true), gettype($measureUnitVolume)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($measureUnitVolume) && mb_strlen(mb_substr($measureUnitVolume, false !== mb_strpos($measureUnitVolume, '.') ? mb_strpos($measureUnitVolume, '.') + 1 : mb_strlen($measureUnitVolume))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($measureUnitVolume, true), mb_strlen(mb_substr($measureUnitVolume, mb_strpos($measureUnitVolume, '.') + 1))), __LINE__);
        }
        // validation for constraint: minExclusive
        if (!is_null($measureUnitVolume) && $measureUnitVolume <= 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than 0', var_export($measureUnitVolume, true)), __LINE__);
        }
        // validation for constraint: pattern([^\.]*(\.[0-9]{1,2})?)
        if (!is_null($measureUnitVolume) && !preg_match('/[^\\.]*(\\.[0-9]{1,2})?/', $measureUnitVolume)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [^\.]*(\.[0-9]{1,2})?', var_export($measureUnitVolume, true)), __LINE__);
        }
        // validation for constraint: totalDigits(9)
        if (!is_null($measureUnitVolume) && mb_strlen(preg_replace('/(\D)/', '', $measureUnitVolume)) > 9) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 9 digits, "%d" given', var_export($measureUnitVolume, true), mb_strlen(preg_replace('/(\D)/', '', $measureUnitVolume))), __LINE__);
        }
        $this->measureUnitVolume = $measureUnitVolume;
        return $this;
    }
    /**
     * Get ownPickup value
     * @return bool|null
     */
    public function getOwnPickup()
    {
        return $this->ownPickup;
    }
    /**
     * Set ownPickup value
     * @param bool $ownPickup
     * @return \DBSchenker\StructType\BookingLandType
     */
    public function setOwnPickup($ownPickup = null)
    {
        // validation for constraint: boolean
        if (!is_null($ownPickup) && !is_bool($ownPickup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($ownPickup, true), gettype($ownPickup)), __LINE__);
        }
        $this->ownPickup = $ownPickup;
        return $this;
    }
    /**
     * Get pharmaceuticals value
     * @return bool|null
     */
    public function getPharmaceuticals()
    {
        return $this->pharmaceuticals;
    }
    /**
     * Set pharmaceuticals value
     * @param bool $pharmaceuticals
     * @return \DBSchenker\StructType\BookingLandType
     */
    public function setPharmaceuticals($pharmaceuticals = null)
    {
        // validation for constraint: boolean
        if (!is_null($pharmaceuticals) && !is_bool($pharmaceuticals)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($pharmaceuticals, true), gettype($pharmaceuticals)), __LINE__);
        }
        $this->pharmaceuticals = $pharmaceuticals;
        return $this;
    }
    /**
     * Get driverPreAdvise value
     * @return \DBSchenker\StructType\PreAdvise|null
     */
    public function getDriverPreAdvise()
    {
        return $this->driverPreAdvise;
    }
    /**
     * Set driverPreAdvise value
     * @param \DBSchenker\StructType\PreAdvise $driverPreAdvise
     * @return \DBSchenker\StructType\BookingLandType
     */
    public function setDriverPreAdvise(\DBSchenker\StructType\PreAdvise $driverPreAdvise = null)
    {
        $this->driverPreAdvise = $driverPreAdvise;
        return $this;
    }
    /**
     * Get transportTemperature value
     * @return \DBSchenker\StructType\Temperature|null
     */
    public function getTransportTemperature()
    {
        return $this->transportTemperature;
    }
    /**
     * Set transportTemperature value
     * @param \DBSchenker\StructType\Temperature $transportTemperature
     * @return \DBSchenker\StructType\BookingLandType
     */
    public function setTransportTemperature(\DBSchenker\StructType\Temperature $transportTemperature = null)
    {
        $this->transportTemperature = $transportTemperature;
        return $this;
    }
    /**
     * Get returnPallet value
     * @return \DBSchenker\StructType\ReturnPallet|null
     */
    public function getReturnPallet()
    {
        return $this->returnPallet;
    }
    /**
     * Set returnPallet value
     * @param \DBSchenker\StructType\ReturnPallet $returnPallet
     * @return \DBSchenker\StructType\BookingLandType
     */
    public function setReturnPallet(\DBSchenker\StructType\ReturnPallet $returnPallet = null)
    {
        $this->returnPallet = $returnPallet;
        return $this;
    }
    /**
     * Get loadingDevice value
     * @return \DBSchenker\StructType\LoadingDevice|null
     */
    public function getLoadingDevice()
    {
        return $this->loadingDevice;
    }
    /**
     * Set loadingDevice value
     * @param \DBSchenker\StructType\LoadingDevice $loadingDevice
     * @return \DBSchenker\StructType\BookingLandType
     */
    public function setLoadingDevice(\DBSchenker\StructType\LoadingDevice $loadingDevice = null)
    {
        $this->loadingDevice = $loadingDevice;
        return $this;
    }
    /**
     * Get preAdviseToConsigneeEmail value
     * @return string|null
     */
    public function getPreAdviseToConsigneeEmail()
    {
        return $this->preAdviseToConsigneeEmail;
    }
    /**
     * Set preAdviseToConsigneeEmail value
     * @param string $preAdviseToConsigneeEmail
     * @return \DBSchenker\StructType\BookingLandType
     */
    public function setPreAdviseToConsigneeEmail($preAdviseToConsigneeEmail = null)
    {
        // validation for constraint: string
        if (!is_null($preAdviseToConsigneeEmail) && !is_string($preAdviseToConsigneeEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($preAdviseToConsigneeEmail, true), gettype($preAdviseToConsigneeEmail)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($preAdviseToConsigneeEmail) && mb_strlen($preAdviseToConsigneeEmail) > 80) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen($preAdviseToConsigneeEmail)), __LINE__);
        }
        $this->preAdviseToConsigneeEmail = $preAdviseToConsigneeEmail;
        return $this;
    }
    /**
     * Get frostFree value
     * @return bool|null
     */
    public function getFrostFree()
    {
        return $this->frostFree;
    }
    /**
     * Set frostFree value
     * @param bool $frostFree
     * @return \DBSchenker\StructType\BookingLandType
     */
    public function setFrostFree($frostFree = null)
    {
        // validation for constraint: boolean
        if (!is_null($frostFree) && !is_bool($frostFree)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($frostFree, true), gettype($frostFree)), __LINE__);
        }
        $this->frostFree = $frostFree;
        return $this;
    }
    /**
     * Get preNotice value
     * @return \DBSchenker\StructType\PreAdvise|null
     */
    public function getPreNotice()
    {
        return $this->preNotice;
    }
    /**
     * Set preNotice value
     * @param \DBSchenker\StructType\PreAdvise $preNotice
     * @return \DBSchenker\StructType\BookingLandType
     */
    public function setPreNotice(\DBSchenker\StructType\PreAdvise $preNotice = null)
    {
        $this->preNotice = $preNotice;
        return $this;
    }
    /**
     * Get deliveryDateFixToBeAgreed value
     * @return \DBSchenker\StructType\PreAdvise|null
     */
    public function getDeliveryDateFixToBeAgreed()
    {
        return $this->deliveryDateFixToBeAgreed;
    }
    /**
     * Set deliveryDateFixToBeAgreed value
     * @param \DBSchenker\StructType\PreAdvise $deliveryDateFixToBeAgreed
     * @return \DBSchenker\StructType\BookingLandType
     */
    public function setDeliveryDateFixToBeAgreed(\DBSchenker\StructType\PreAdvise $deliveryDateFixToBeAgreed = null)
    {
        $this->deliveryDateFixToBeAgreed = $deliveryDateFixToBeAgreed;
        return $this;
    }
    /**
     * Get customData value
     * @return string|null
     */
    public function getCustomData()
    {
        return $this->customData;
    }
    /**
     * Set customData value
     * @param string $customData
     * @return \DBSchenker\StructType\BookingLandType
     */
    public function setCustomData($customData = null)
    {
        // validation for constraint: string
        if (!is_null($customData) && !is_string($customData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customData, true), gettype($customData)), __LINE__);
        }
        // validation for constraint: maxLength(1000)
        if (!is_null($customData) && mb_strlen($customData) > 1000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1000', mb_strlen($customData)), __LINE__);
        }
        $this->customData = $customData;
        return $this;
    }
    /**
     * Get preadviseToPickup value
     * @return \DBSchenker\StructType\PreAdvise|null
     */
    public function getPreadviseToPickup()
    {
        return $this->preadviseToPickup;
    }
    /**
     * Set preadviseToPickup value
     * @param \DBSchenker\StructType\PreAdvise $preadviseToPickup
     * @return \DBSchenker\StructType\BookingLandType
     */
    public function setPreadviseToPickup(\DBSchenker\StructType\PreAdvise $preadviseToPickup = null)
    {
        $this->preadviseToPickup = $preadviseToPickup;
        return $this;
    }
    /**
     * Get equipment value
     * @return \DBSchenker\StructType\LandEquipmentType|null
     */
    public function getEquipment()
    {
        return $this->equipment;
    }
    /**
     * Set equipment value
     * @param \DBSchenker\StructType\LandEquipmentType $equipment
     * @return \DBSchenker\StructType\BookingLandType
     */
    public function setEquipment(\DBSchenker\StructType\LandEquipmentType $equipment = null)
    {
        $this->equipment = $equipment;
        return $this;
    }
    /**
     * Get loadSecuringEquipment value
     * @return \DBSchenker\StructType\LoadSecuringEquipmentType[]|null
     */
    public function getLoadSecuringEquipment()
    {
        return $this->loadSecuringEquipment;
    }
    /**
     * This method is responsible for validating the values passed to the setLoadSecuringEquipment method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLoadSecuringEquipment method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLoadSecuringEquipmentForArrayConstraintsFromSetLoadSecuringEquipment(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $bookingLandTypeLoadSecuringEquipmentItem) {
            // validation for constraint: itemType
            if (!$bookingLandTypeLoadSecuringEquipmentItem instanceof \DBSchenker\StructType\LoadSecuringEquipmentType) {
                $invalidValues[] = is_object($bookingLandTypeLoadSecuringEquipmentItem) ? get_class($bookingLandTypeLoadSecuringEquipmentItem) : sprintf('%s(%s)', gettype($bookingLandTypeLoadSecuringEquipmentItem), var_export($bookingLandTypeLoadSecuringEquipmentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The loadSecuringEquipment property can only contain items of type \DBSchenker\StructType\LoadSecuringEquipmentType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set loadSecuringEquipment value
     * @throws \InvalidArgumentException
     * @param \DBSchenker\StructType\LoadSecuringEquipmentType[] $loadSecuringEquipment
     * @return \DBSchenker\StructType\BookingLandType
     */
    public function setLoadSecuringEquipment(array $loadSecuringEquipment = array())
    {
        // validation for constraint: array
        if ('' !== ($loadSecuringEquipmentArrayErrorMessage = self::validateLoadSecuringEquipmentForArrayConstraintsFromSetLoadSecuringEquipment($loadSecuringEquipment))) {
            throw new \InvalidArgumentException($loadSecuringEquipmentArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(4)
        if (is_array($loadSecuringEquipment) && count($loadSecuringEquipment) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 4', count($loadSecuringEquipment)), __LINE__);
        }
        $this->loadSecuringEquipment = $loadSecuringEquipment;
        return $this;
    }
    /**
     * Add item to loadSecuringEquipment value
     * @throws \InvalidArgumentException
     * @param \DBSchenker\StructType\LoadSecuringEquipmentType $item
     * @return \DBSchenker\StructType\BookingLandType
     */
    public function addToLoadSecuringEquipment(\DBSchenker\StructType\LoadSecuringEquipmentType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \DBSchenker\StructType\LoadSecuringEquipmentType) {
            throw new \InvalidArgumentException(sprintf('The loadSecuringEquipment property can only contain items of type \DBSchenker\StructType\LoadSecuringEquipmentType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(4)
        if (is_array($this->loadSecuringEquipment) && count($this->loadSecuringEquipment) >= 4) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 4', count($this->loadSecuringEquipment)), __LINE__);
        }
        $this->loadSecuringEquipment[] = $item;
        return $this;
    }
    /**
     * Get palletExchange value
     * @return bool|null
     */
    public function getPalletExchange()
    {
        return $this->palletExchange;
    }
    /**
     * Set palletExchange value
     * @param bool $palletExchange
     * @return \DBSchenker\StructType\BookingLandType
     */
    public function setPalletExchange($palletExchange = null)
    {
        // validation for constraint: boolean
        if (!is_null($palletExchange) && !is_bool($palletExchange)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($palletExchange, true), gettype($palletExchange)), __LINE__);
        }
        $this->palletExchange = $palletExchange;
        return $this;
    }
    /**
     * Get mixedLoadingRestriction value
     * @return bool|null
     */
    public function getMixedLoadingRestriction()
    {
        return $this->mixedLoadingRestriction;
    }
    /**
     * Set mixedLoadingRestriction value
     * @param bool $mixedLoadingRestriction
     * @return \DBSchenker\StructType\BookingLandType
     */
    public function setMixedLoadingRestriction($mixedLoadingRestriction = null)
    {
        // validation for constraint: boolean
        if (!is_null($mixedLoadingRestriction) && !is_bool($mixedLoadingRestriction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($mixedLoadingRestriction, true), gettype($mixedLoadingRestriction)), __LINE__);
        }
        $this->mixedLoadingRestriction = $mixedLoadingRestriction;
        return $this;
    }
    /**
     * Get mixedLoadingRestrictionDescription value
     * @return string|null
     */
    public function getMixedLoadingRestrictionDescription()
    {
        return $this->mixedLoadingRestrictionDescription;
    }
    /**
     * Set mixedLoadingRestrictionDescription value
     * @param string $mixedLoadingRestrictionDescription
     * @return \DBSchenker\StructType\BookingLandType
     */
    public function setMixedLoadingRestrictionDescription($mixedLoadingRestrictionDescription = null)
    {
        // validation for constraint: string
        if (!is_null($mixedLoadingRestrictionDescription) && !is_string($mixedLoadingRestrictionDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mixedLoadingRestrictionDescription, true), gettype($mixedLoadingRestrictionDescription)), __LINE__);
        }
        $this->mixedLoadingRestrictionDescription = $mixedLoadingRestrictionDescription;
        return $this;
    }
    /**
     * Get transShipmentRestriction value
     * @return bool|null
     */
    public function getTransShipmentRestriction()
    {
        return $this->transShipmentRestriction;
    }
    /**
     * Set transShipmentRestriction value
     * @param bool $transShipmentRestriction
     * @return \DBSchenker\StructType\BookingLandType
     */
    public function setTransShipmentRestriction($transShipmentRestriction = null)
    {
        // validation for constraint: boolean
        if (!is_null($transShipmentRestriction) && !is_bool($transShipmentRestriction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($transShipmentRestriction, true), gettype($transShipmentRestriction)), __LINE__);
        }
        $this->transShipmentRestriction = $transShipmentRestriction;
        return $this;
    }
    /**
     * Get liftingPlatform value
     * @return string[]|null
     */
    public function getLiftingPlatform()
    {
        return $this->liftingPlatform;
    }
    /**
     * This method is responsible for validating the values passed to the setLiftingPlatform method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLiftingPlatform method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLiftingPlatformForArrayConstraintsFromSetLiftingPlatform(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $bookingLandTypeLiftingPlatformItem) {
            // validation for constraint: enumeration
            if (!\DBSchenker\EnumType\LiftingPlatform::valueIsValid($bookingLandTypeLiftingPlatformItem)) {
                $invalidValues[] = is_object($bookingLandTypeLiftingPlatformItem) ? get_class($bookingLandTypeLiftingPlatformItem) : sprintf('%s(%s)', gettype($bookingLandTypeLiftingPlatformItem), var_export($bookingLandTypeLiftingPlatformItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \DBSchenker\EnumType\LiftingPlatform', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \DBSchenker\EnumType\LiftingPlatform::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set liftingPlatform value
     * @uses \DBSchenker\EnumType\LiftingPlatform::valueIsValid()
     * @uses \DBSchenker\EnumType\LiftingPlatform::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $liftingPlatform
     * @return \DBSchenker\StructType\BookingLandType
     */
    public function setLiftingPlatform(array $liftingPlatform = array())
    {
        // validation for constraint: array
        if ('' !== ($liftingPlatformArrayErrorMessage = self::validateLiftingPlatformForArrayConstraintsFromSetLiftingPlatform($liftingPlatform))) {
            throw new \InvalidArgumentException($liftingPlatformArrayErrorMessage, __LINE__);
        }
        $this->liftingPlatform = $liftingPlatform;
        return $this;
    }
    /**
     * Add item to liftingPlatform value
     * @uses \DBSchenker\EnumType\LiftingPlatform::valueIsValid()
     * @uses \DBSchenker\EnumType\LiftingPlatform::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \DBSchenker\StructType\BookingLandType
     */
    public function addToLiftingPlatform($item)
    {
        // validation for constraint: enumeration
        if (!\DBSchenker\EnumType\LiftingPlatform::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \DBSchenker\EnumType\LiftingPlatform', is_array($item) ? implode(', ', $item) : var_export($item, true), implode(', ', \DBSchenker\EnumType\LiftingPlatform::getValidValues())), __LINE__);
        }
        $this->liftingPlatform[] = $item;
        return $this;
    }
    /**
     * Get ekaerNumber value
     * @return string|null
     */
    public function getEkaerNumber()
    {
        return $this->ekaerNumber;
    }
    /**
     * Set ekaerNumber value
     * @param string $ekaerNumber
     * @return \DBSchenker\StructType\BookingLandType
     */
    public function setEkaerNumber($ekaerNumber = null)
    {
        // validation for constraint: string
        if (!is_null($ekaerNumber) && !is_string($ekaerNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ekaerNumber, true), gettype($ekaerNumber)), __LINE__);
        }
        // validation for constraint: pattern(E[a-zA-Z0-9]{0,14})
        if (!is_null($ekaerNumber) && !preg_match('/E[a-zA-Z0-9]{0,14}/', $ekaerNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression E[a-zA-Z0-9]{0,14}', var_export($ekaerNumber, true)), __LINE__);
        }
        $this->ekaerNumber = $ekaerNumber;
        return $this;
    }
    /**
     * Get printCmrEmail value
     * @return string|null
     */
    public function getPrintCmrEmail()
    {
        return $this->printCmrEmail;
    }
    /**
     * Set printCmrEmail value
     * @param string $printCmrEmail
     * @return \DBSchenker\StructType\BookingLandType
     */
    public function setPrintCmrEmail($printCmrEmail = null)
    {
        // validation for constraint: string
        if (!is_null($printCmrEmail) && !is_string($printCmrEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($printCmrEmail, true), gettype($printCmrEmail)), __LINE__);
        }
        // validation for constraint: maxLength(250)
        if (!is_null($printCmrEmail) && mb_strlen($printCmrEmail) > 250) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 250', mb_strlen($printCmrEmail)), __LINE__);
        }
        // validation for constraint: pattern([^@]+@[^\.]+\..+)
        if (!is_null($printCmrEmail) && !preg_match('/[^@]+@[^\\.]+\\..+/', $printCmrEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [^@]+@[^\.]+\..+', var_export($printCmrEmail, true)), __LINE__);
        }
        $this->printCmrEmail = $printCmrEmail;
        return $this;
    }
    /**
     * Get sentApplicable value
     * @return \DBSchenker\StructType\SentApplicable|null
     */
    public function getSentApplicable()
    {
        return $this->sentApplicable;
    }
    /**
     * Set sentApplicable value
     * @param \DBSchenker\StructType\SentApplicable $sentApplicable
     * @return \DBSchenker\StructType\BookingLandType
     */
    public function setSentApplicable(\DBSchenker\StructType\SentApplicable $sentApplicable = null)
    {
        $this->sentApplicable = $sentApplicable;
        return $this;
    }
    /**
     * Get longGoods value
     * @return string|null
     */
    public function getLongGoods()
    {
        return $this->longGoods;
    }
    /**
     * Set longGoods value
     * @uses \DBSchenker\EnumType\LongGoodsType::valueIsValid()
     * @uses \DBSchenker\EnumType\LongGoodsType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $longGoods
     * @return \DBSchenker\StructType\BookingLandType
     */
    public function setLongGoods($longGoods = null)
    {
        // validation for constraint: enumeration
        if (!\DBSchenker\EnumType\LongGoodsType::valueIsValid($longGoods)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \DBSchenker\EnumType\LongGoodsType', is_array($longGoods) ? implode(', ', $longGoods) : var_export($longGoods, true), implode(', ', \DBSchenker\EnumType\LongGoodsType::getValidValues())), __LINE__);
        }
        $this->longGoods = $longGoods;
        return $this;
    }
    /**
     * Get nextDayCollection value
     * @return bool|null
     */
    public function getNextDayCollection()
    {
        return $this->nextDayCollection;
    }
    /**
     * Set nextDayCollection value
     * @param bool $nextDayCollection
     * @return \DBSchenker\StructType\BookingLandType
     */
    public function setNextDayCollection($nextDayCollection = null)
    {
        // validation for constraint: boolean
        if (!is_null($nextDayCollection) && !is_bool($nextDayCollection)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($nextDayCollection, true), gettype($nextDayCollection)), __LINE__);
        }
        $this->nextDayCollection = $nextDayCollection;
        return $this;
    }
    /**
     * Get proofOfDelivery value
     * @return bool|null
     */
    public function getProofOfDelivery()
    {
        return $this->proofOfDelivery;
    }
    /**
     * Set proofOfDelivery value
     * @param bool $proofOfDelivery
     * @return \DBSchenker\StructType\BookingLandType
     */
    public function setProofOfDelivery($proofOfDelivery = null)
    {
        // validation for constraint: boolean
        if (!is_null($proofOfDelivery) && !is_bool($proofOfDelivery)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($proofOfDelivery, true), gettype($proofOfDelivery)), __LINE__);
        }
        $this->proofOfDelivery = $proofOfDelivery;
        return $this;
    }
    /**
     * Get preNoticePickup value
     * @return \DBSchenker\StructType\PreNoticeContactType|null
     */
    public function getPreNoticePickup()
    {
        return $this->preNoticePickup;
    }
    /**
     * Set preNoticePickup value
     * @param \DBSchenker\StructType\PreNoticeContactType $preNoticePickup
     * @return \DBSchenker\StructType\BookingLandType
     */
    public function setPreNoticePickup(\DBSchenker\StructType\PreNoticeContactType $preNoticePickup = null)
    {
        $this->preNoticePickup = $preNoticePickup;
        return $this;
    }
    /**
     * Get preNoticeDelivery value
     * @return \DBSchenker\StructType\PreNoticeContactType|null
     */
    public function getPreNoticeDelivery()
    {
        return $this->preNoticeDelivery;
    }
    /**
     * Set preNoticeDelivery value
     * @param \DBSchenker\StructType\PreNoticeContactType $preNoticeDelivery
     * @return \DBSchenker\StructType\BookingLandType
     */
    public function setPreNoticeDelivery(\DBSchenker\StructType\PreNoticeContactType $preNoticeDelivery = null)
    {
        $this->preNoticeDelivery = $preNoticeDelivery;
        return $this;
    }
    /**
     * Get fixDayPickup value
     * @return bool|null
     */
    public function getFixDayPickup()
    {
        return $this->fixDayPickup;
    }
    /**
     * Set fixDayPickup value
     * @param bool $fixDayPickup
     * @return \DBSchenker\StructType\BookingLandType
     */
    public function setFixDayPickup($fixDayPickup = null)
    {
        // validation for constraint: boolean
        if (!is_null($fixDayPickup) && !is_bool($fixDayPickup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($fixDayPickup, true), gettype($fixDayPickup)), __LINE__);
        }
        $this->fixDayPickup = $fixDayPickup;
        return $this;
    }
    /**
     * Get timeWindowPickup value
     * @return string|null
     */
    public function getTimeWindowPickup()
    {
        return $this->timeWindowPickup;
    }
    /**
     * Set timeWindowPickup value
     * @uses \DBSchenker\EnumType\TimeWindowOptionType::valueIsValid()
     * @uses \DBSchenker\EnumType\TimeWindowOptionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $timeWindowPickup
     * @return \DBSchenker\StructType\BookingLandType
     */
    public function setTimeWindowPickup($timeWindowPickup = null)
    {
        // validation for constraint: enumeration
        if (!\DBSchenker\EnumType\TimeWindowOptionType::valueIsValid($timeWindowPickup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \DBSchenker\EnumType\TimeWindowOptionType', is_array($timeWindowPickup) ? implode(', ', $timeWindowPickup) : var_export($timeWindowPickup, true), implode(', ', \DBSchenker\EnumType\TimeWindowOptionType::getValidValues())), __LINE__);
        }
        $this->timeWindowPickup = $timeWindowPickup;
        return $this;
    }
    /**
     * Get timeWindowDelivery value
     * @return string|null
     */
    public function getTimeWindowDelivery()
    {
        return $this->timeWindowDelivery;
    }
    /**
     * Set timeWindowDelivery value
     * @uses \DBSchenker\EnumType\TimeWindowOptionType::valueIsValid()
     * @uses \DBSchenker\EnumType\TimeWindowOptionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $timeWindowDelivery
     * @return \DBSchenker\StructType\BookingLandType
     */
    public function setTimeWindowDelivery($timeWindowDelivery = null)
    {
        // validation for constraint: enumeration
        if (!\DBSchenker\EnumType\TimeWindowOptionType::valueIsValid($timeWindowDelivery)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \DBSchenker\EnumType\TimeWindowOptionType', is_array($timeWindowDelivery) ? implode(', ', $timeWindowDelivery) : var_export($timeWindowDelivery, true), implode(', ', \DBSchenker\EnumType\TimeWindowOptionType::getValidValues())), __LINE__);
        }
        $this->timeWindowDelivery = $timeWindowDelivery;
        return $this;
    }
    /**
     * Get specialLoadingSpecification value
     * @return string[]|null
     */
    public function getSpecialLoadingSpecification()
    {
        return $this->specialLoadingSpecification;
    }
    /**
     * This method is responsible for validating the values passed to the setSpecialLoadingSpecification method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSpecialLoadingSpecification method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSpecialLoadingSpecificationForArrayConstraintsFromSetSpecialLoadingSpecification(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $bookingLandTypeSpecialLoadingSpecificationItem) {
            // validation for constraint: enumeration
            if (!\DBSchenker\EnumType\SpecialLoadingSpecificationType::valueIsValid($bookingLandTypeSpecialLoadingSpecificationItem)) {
                $invalidValues[] = is_object($bookingLandTypeSpecialLoadingSpecificationItem) ? get_class($bookingLandTypeSpecialLoadingSpecificationItem) : sprintf('%s(%s)', gettype($bookingLandTypeSpecialLoadingSpecificationItem), var_export($bookingLandTypeSpecialLoadingSpecificationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \DBSchenker\EnumType\SpecialLoadingSpecificationType', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \DBSchenker\EnumType\SpecialLoadingSpecificationType::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set specialLoadingSpecification value
     * @uses \DBSchenker\EnumType\SpecialLoadingSpecificationType::valueIsValid()
     * @uses \DBSchenker\EnumType\SpecialLoadingSpecificationType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $specialLoadingSpecification
     * @return \DBSchenker\StructType\BookingLandType
     */
    public function setSpecialLoadingSpecification(array $specialLoadingSpecification = array())
    {
        // validation for constraint: array
        if ('' !== ($specialLoadingSpecificationArrayErrorMessage = self::validateSpecialLoadingSpecificationForArrayConstraintsFromSetSpecialLoadingSpecification($specialLoadingSpecification))) {
            throw new \InvalidArgumentException($specialLoadingSpecificationArrayErrorMessage, __LINE__);
        }
        $this->specialLoadingSpecification = $specialLoadingSpecification;
        return $this;
    }
    /**
     * Add item to specialLoadingSpecification value
     * @uses \DBSchenker\EnumType\SpecialLoadingSpecificationType::valueIsValid()
     * @uses \DBSchenker\EnumType\SpecialLoadingSpecificationType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \DBSchenker\StructType\BookingLandType
     */
    public function addToSpecialLoadingSpecification($item)
    {
        // validation for constraint: enumeration
        if (!\DBSchenker\EnumType\SpecialLoadingSpecificationType::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \DBSchenker\EnumType\SpecialLoadingSpecificationType', is_array($item) ? implode(', ', $item) : var_export($item, true), implode(', ', \DBSchenker\EnumType\SpecialLoadingSpecificationType::getValidValues())), __LINE__);
        }
        $this->specialLoadingSpecification[] = $item;
        return $this;
    }
    /**
     * Get partloadPickedUp value
     * @return bool|null
     */
    public function getPartloadPickedUp()
    {
        return $this->partloadPickedUp;
    }
    /**
     * Set partloadPickedUp value
     * @param bool $partloadPickedUp
     * @return \DBSchenker\StructType\BookingLandType
     */
    public function setPartloadPickedUp($partloadPickedUp = null)
    {
        // validation for constraint: boolean
        if (!is_null($partloadPickedUp) && !is_bool($partloadPickedUp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($partloadPickedUp, true), gettype($partloadPickedUp)), __LINE__);
        }
        $this->partloadPickedUp = $partloadPickedUp;
        return $this;
    }
    /**
     * Get giroservice value
     * @return bool|null
     */
    public function getGiroservice()
    {
        return $this->giroservice;
    }
    /**
     * Set giroservice value
     * @param bool $giroservice
     * @return \DBSchenker\StructType\BookingLandType
     */
    public function setGiroservice($giroservice = null)
    {
        // validation for constraint: boolean
        if (!is_null($giroservice) && !is_bool($giroservice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($giroservice, true), gettype($giroservice)), __LINE__);
        }
        $this->giroservice = $giroservice;
        return $this;
    }
    /**
     * Get giroserviceNetFreightSurcharge value
     * @return bool|null
     */
    public function getGiroserviceNetFreightSurcharge()
    {
        return $this->giroserviceNetFreightSurcharge;
    }
    /**
     * Set giroserviceNetFreightSurcharge value
     * @param bool $giroserviceNetFreightSurcharge
     * @return \DBSchenker\StructType\BookingLandType
     */
    public function setGiroserviceNetFreightSurcharge($giroserviceNetFreightSurcharge = null)
    {
        // validation for constraint: boolean
        if (!is_null($giroserviceNetFreightSurcharge) && !is_bool($giroserviceNetFreightSurcharge)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($giroserviceNetFreightSurcharge, true), gettype($giroserviceNetFreightSurcharge)), __LINE__);
        }
        $this->giroserviceNetFreightSurcharge = $giroserviceNetFreightSurcharge;
        return $this;
    }
    /**
     * Get giroserviceRegularShippingSurcharge value
     * @return bool|null
     */
    public function getGiroserviceRegularShippingSurcharge()
    {
        return $this->giroserviceRegularShippingSurcharge;
    }
    /**
     * Set giroserviceRegularShippingSurcharge value
     * @param bool $giroserviceRegularShippingSurcharge
     * @return \DBSchenker\StructType\BookingLandType
     */
    public function setGiroserviceRegularShippingSurcharge($giroserviceRegularShippingSurcharge = null)
    {
        // validation for constraint: boolean
        if (!is_null($giroserviceRegularShippingSurcharge) && !is_bool($giroserviceRegularShippingSurcharge)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($giroserviceRegularShippingSurcharge, true), gettype($giroserviceRegularShippingSurcharge)), __LINE__);
        }
        $this->giroserviceRegularShippingSurcharge = $giroserviceRegularShippingSurcharge;
        return $this;
    }
    /**
     * Get schenkerSpecial value
     * @return bool|null
     */
    public function getSchenkerSpecial()
    {
        return $this->schenkerSpecial;
    }
    /**
     * Set schenkerSpecial value
     * @param bool $schenkerSpecial
     * @return \DBSchenker\StructType\BookingLandType
     */
    public function setSchenkerSpecial($schenkerSpecial = null)
    {
        // validation for constraint: boolean
        if (!is_null($schenkerSpecial) && !is_bool($schenkerSpecial)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($schenkerSpecial, true), gettype($schenkerSpecial)), __LINE__);
        }
        $this->schenkerSpecial = $schenkerSpecial;
        return $this;
    }
    /**
     * Get reshipping value
     * @return bool|null
     */
    public function getReshipping()
    {
        return $this->reshipping;
    }
    /**
     * Set reshipping value
     * @param bool $reshipping
     * @return \DBSchenker\StructType\BookingLandType
     */
    public function setReshipping($reshipping = null)
    {
        // validation for constraint: boolean
        if (!is_null($reshipping) && !is_bool($reshipping)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($reshipping, true), gettype($reshipping)), __LINE__);
        }
        $this->reshipping = $reshipping;
        return $this;
    }
    /**
     * Get privateDeliveryInside value
     * @return bool|null
     */
    public function getPrivateDeliveryInside()
    {
        return $this->privateDeliveryInside;
    }
    /**
     * Set privateDeliveryInside value
     * @param bool $privateDeliveryInside
     * @return \DBSchenker\StructType\BookingLandType
     */
    public function setPrivateDeliveryInside($privateDeliveryInside = null)
    {
        // validation for constraint: boolean
        if (!is_null($privateDeliveryInside) && !is_bool($privateDeliveryInside)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($privateDeliveryInside, true), gettype($privateDeliveryInside)), __LINE__);
        }
        $this->privateDeliveryInside = $privateDeliveryInside;
        return $this;
    }
    /**
     * Get privateDeliveryAtWork value
     * @return bool|null
     */
    public function getPrivateDeliveryAtWork()
    {
        return $this->privateDeliveryAtWork;
    }
    /**
     * Set privateDeliveryAtWork value
     * @param bool $privateDeliveryAtWork
     * @return \DBSchenker\StructType\BookingLandType
     */
    public function setPrivateDeliveryAtWork($privateDeliveryAtWork = null)
    {
        // validation for constraint: boolean
        if (!is_null($privateDeliveryAtWork) && !is_bool($privateDeliveryAtWork)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($privateDeliveryAtWork, true), gettype($privateDeliveryAtWork)), __LINE__);
        }
        $this->privateDeliveryAtWork = $privateDeliveryAtWork;
        return $this;
    }
    /**
     * Get privateDeliveryInsideReturnablePackaging value
     * @return bool|null
     */
    public function getPrivateDeliveryInsideReturnablePackaging()
    {
        return $this->privateDeliveryInsideReturnablePackaging;
    }
    /**
     * Set privateDeliveryInsideReturnablePackaging value
     * @param bool $privateDeliveryInsideReturnablePackaging
     * @return \DBSchenker\StructType\BookingLandType
     */
    public function setPrivateDeliveryInsideReturnablePackaging($privateDeliveryInsideReturnablePackaging = null)
    {
        // validation for constraint: boolean
        if (!is_null($privateDeliveryInsideReturnablePackaging) && !is_bool($privateDeliveryInsideReturnablePackaging)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($privateDeliveryInsideReturnablePackaging, true), gettype($privateDeliveryInsideReturnablePackaging)), __LINE__);
        }
        $this->privateDeliveryInsideReturnablePackaging = $privateDeliveryInsideReturnablePackaging;
        return $this;
    }
    /**
     * Get privateDeliveryInsideReturnOfOldDevice value
     * @return bool|null
     */
    public function getPrivateDeliveryInsideReturnOfOldDevice()
    {
        return $this->privateDeliveryInsideReturnOfOldDevice;
    }
    /**
     * Set privateDeliveryInsideReturnOfOldDevice value
     * @param bool $privateDeliveryInsideReturnOfOldDevice
     * @return \DBSchenker\StructType\BookingLandType
     */
    public function setPrivateDeliveryInsideReturnOfOldDevice($privateDeliveryInsideReturnOfOldDevice = null)
    {
        // validation for constraint: boolean
        if (!is_null($privateDeliveryInsideReturnOfOldDevice) && !is_bool($privateDeliveryInsideReturnOfOldDevice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($privateDeliveryInsideReturnOfOldDevice, true), gettype($privateDeliveryInsideReturnOfOldDevice)), __LINE__);
        }
        $this->privateDeliveryInsideReturnOfOldDevice = $privateDeliveryInsideReturnOfOldDevice;
        return $this;
    }
    /**
     * Get privateDeliveryInsideReturnablePackagingOldDevice value
     * @return bool|null
     */
    public function getPrivateDeliveryInsideReturnablePackagingOldDevice()
    {
        return $this->privateDeliveryInsideReturnablePackagingOldDevice;
    }
    /**
     * Set privateDeliveryInsideReturnablePackagingOldDevice value
     * @param bool $privateDeliveryInsideReturnablePackagingOldDevice
     * @return \DBSchenker\StructType\BookingLandType
     */
    public function setPrivateDeliveryInsideReturnablePackagingOldDevice($privateDeliveryInsideReturnablePackagingOldDevice = null)
    {
        // validation for constraint: boolean
        if (!is_null($privateDeliveryInsideReturnablePackagingOldDevice) && !is_bool($privateDeliveryInsideReturnablePackagingOldDevice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($privateDeliveryInsideReturnablePackagingOldDevice, true), gettype($privateDeliveryInsideReturnablePackagingOldDevice)), __LINE__);
        }
        $this->privateDeliveryInsideReturnablePackagingOldDevice = $privateDeliveryInsideReturnablePackagingOldDevice;
        return $this;
    }
    /**
     * Get returnShipment value
     * @return bool|null
     */
    public function getReturnShipment()
    {
        return $this->returnShipment;
    }
    /**
     * Set returnShipment value
     * @param bool $returnShipment
     * @return \DBSchenker\StructType\BookingLandType
     */
    public function setReturnShipment($returnShipment = null)
    {
        // validation for constraint: boolean
        if (!is_null($returnShipment) && !is_bool($returnShipment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($returnShipment, true), gettype($returnShipment)), __LINE__);
        }
        $this->returnShipment = $returnShipment;
        return $this;
    }
    /**
     * Get dispersionAgreement value
     * @return bool|null
     */
    public function getDispersionAgreement()
    {
        return $this->dispersionAgreement;
    }
    /**
     * Set dispersionAgreement value
     * @param bool $dispersionAgreement
     * @return \DBSchenker\StructType\BookingLandType
     */
    public function setDispersionAgreement($dispersionAgreement = null)
    {
        // validation for constraint: boolean
        if (!is_null($dispersionAgreement) && !is_bool($dispersionAgreement)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($dispersionAgreement, true), gettype($dispersionAgreement)), __LINE__);
        }
        $this->dispersionAgreement = $dispersionAgreement;
        return $this;
    }
    /**
     * Get customsClearanceImportShipmentSentToCustomsWarehouse value
     * @return bool|null
     */
    public function getCustomsClearanceImportShipmentSentToCustomsWarehouse()
    {
        return $this->customsClearanceImportShipmentSentToCustomsWarehouse;
    }
    /**
     * Set customsClearanceImportShipmentSentToCustomsWarehouse value
     * @param bool $customsClearanceImportShipmentSentToCustomsWarehouse
     * @return \DBSchenker\StructType\BookingLandType
     */
    public function setCustomsClearanceImportShipmentSentToCustomsWarehouse($customsClearanceImportShipmentSentToCustomsWarehouse = null)
    {
        // validation for constraint: boolean
        if (!is_null($customsClearanceImportShipmentSentToCustomsWarehouse) && !is_bool($customsClearanceImportShipmentSentToCustomsWarehouse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($customsClearanceImportShipmentSentToCustomsWarehouse, true), gettype($customsClearanceImportShipmentSentToCustomsWarehouse)), __LINE__);
        }
        $this->customsClearanceImportShipmentSentToCustomsWarehouse = $customsClearanceImportShipmentSentToCustomsWarehouse;
        return $this;
    }
    /**
     * Get refrigerated value
     * @return bool|null
     */
    public function getRefrigerated()
    {
        return $this->refrigerated;
    }
    /**
     * Set refrigerated value
     * @param bool $refrigerated
     * @return \DBSchenker\StructType\BookingLandType
     */
    public function setRefrigerated($refrigerated = null)
    {
        // validation for constraint: boolean
        if (!is_null($refrigerated) && !is_bool($refrigerated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($refrigerated, true), gettype($refrigerated)), __LINE__);
        }
        $this->refrigerated = $refrigerated;
        return $this;
    }
    /**
     * Get volumeGoods value
     * @return bool|null
     */
    public function getVolumeGoods()
    {
        return $this->volumeGoods;
    }
    /**
     * Set volumeGoods value
     * @param bool $volumeGoods
     * @return \DBSchenker\StructType\BookingLandType
     */
    public function setVolumeGoods($volumeGoods = null)
    {
        // validation for constraint: boolean
        if (!is_null($volumeGoods) && !is_bool($volumeGoods)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($volumeGoods, true), gettype($volumeGoods)), __LINE__);
        }
        $this->volumeGoods = $volumeGoods;
        return $this;
    }
    /**
     * Get deliveryPreNoticeSms value
     * @return \DBSchenker\StructType\DeliveryPreNoticeSmsType|null
     */
    public function getDeliveryPreNoticeSms()
    {
        return $this->deliveryPreNoticeSms;
    }
    /**
     * Set deliveryPreNoticeSms value
     * @param \DBSchenker\StructType\DeliveryPreNoticeSmsType $deliveryPreNoticeSms
     * @return \DBSchenker\StructType\BookingLandType
     */
    public function setDeliveryPreNoticeSms(\DBSchenker\StructType\DeliveryPreNoticeSmsType $deliveryPreNoticeSms = null)
    {
        $this->deliveryPreNoticeSms = $deliveryPreNoticeSms;
        return $this;
    }
    /**
     * Get deliveryPreNoticeEmail value
     * @return \DBSchenker\StructType\DeliveryPreNoticeEmailType|null
     */
    public function getDeliveryPreNoticeEmail()
    {
        return $this->deliveryPreNoticeEmail;
    }
    /**
     * Set deliveryPreNoticeEmail value
     * @param \DBSchenker\StructType\DeliveryPreNoticeEmailType $deliveryPreNoticeEmail
     * @return \DBSchenker\StructType\BookingLandType
     */
    public function setDeliveryPreNoticeEmail(\DBSchenker\StructType\DeliveryPreNoticeEmailType $deliveryPreNoticeEmail = null)
    {
        $this->deliveryPreNoticeEmail = $deliveryPreNoticeEmail;
        return $this;
    }
    /**
     * Get assistanceDriverDelivery value
     * @return bool|null
     */
    public function getAssistanceDriverDelivery()
    {
        return $this->assistanceDriverDelivery;
    }
    /**
     * Set assistanceDriverDelivery value
     * @param bool $assistanceDriverDelivery
     * @return \DBSchenker\StructType\BookingLandType
     */
    public function setAssistanceDriverDelivery($assistanceDriverDelivery = null)
    {
        // validation for constraint: boolean
        if (!is_null($assistanceDriverDelivery) && !is_bool($assistanceDriverDelivery)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($assistanceDriverDelivery, true), gettype($assistanceDriverDelivery)), __LINE__);
        }
        $this->assistanceDriverDelivery = $assistanceDriverDelivery;
        return $this;
    }
    /**
     * Get assistanceDriverPickup value
     * @return bool|null
     */
    public function getAssistanceDriverPickup()
    {
        return $this->assistanceDriverPickup;
    }
    /**
     * Set assistanceDriverPickup value
     * @param bool $assistanceDriverPickup
     * @return \DBSchenker\StructType\BookingLandType
     */
    public function setAssistanceDriverPickup($assistanceDriverPickup = null)
    {
        // validation for constraint: boolean
        if (!is_null($assistanceDriverPickup) && !is_bool($assistanceDriverPickup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($assistanceDriverPickup, true), gettype($assistanceDriverPickup)), __LINE__);
        }
        $this->assistanceDriverPickup = $assistanceDriverPickup;
        return $this;
    }
    /**
     * Get indoorPickup value
     * @return bool|null
     */
    public function getIndoorPickup()
    {
        return $this->indoorPickup;
    }
    /**
     * Set indoorPickup value
     * @param bool $indoorPickup
     * @return \DBSchenker\StructType\BookingLandType
     */
    public function setIndoorPickup($indoorPickup = null)
    {
        // validation for constraint: boolean
        if (!is_null($indoorPickup) && !is_bool($indoorPickup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($indoorPickup, true), gettype($indoorPickup)), __LINE__);
        }
        $this->indoorPickup = $indoorPickup;
        return $this;
    }
    /**
     * Get unmannedLocationDelivery value
     * @return bool|null
     */
    public function getUnmannedLocationDelivery()
    {
        return $this->unmannedLocationDelivery;
    }
    /**
     * Set unmannedLocationDelivery value
     * @param bool $unmannedLocationDelivery
     * @return \DBSchenker\StructType\BookingLandType
     */
    public function setUnmannedLocationDelivery($unmannedLocationDelivery = null)
    {
        // validation for constraint: boolean
        if (!is_null($unmannedLocationDelivery) && !is_bool($unmannedLocationDelivery)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($unmannedLocationDelivery, true), gettype($unmannedLocationDelivery)), __LINE__);
        }
        $this->unmannedLocationDelivery = $unmannedLocationDelivery;
        return $this;
    }
    /**
     * Get unmannedLocationPickup value
     * @return bool|null
     */
    public function getUnmannedLocationPickup()
    {
        return $this->unmannedLocationPickup;
    }
    /**
     * Set unmannedLocationPickup value
     * @param bool $unmannedLocationPickup
     * @return \DBSchenker\StructType\BookingLandType
     */
    public function setUnmannedLocationPickup($unmannedLocationPickup = null)
    {
        // validation for constraint: boolean
        if (!is_null($unmannedLocationPickup) && !is_bool($unmannedLocationPickup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($unmannedLocationPickup, true), gettype($unmannedLocationPickup)), __LINE__);
        }
        $this->unmannedLocationPickup = $unmannedLocationPickup;
        return $this;
    }
    /**
     * Get craneServiceDelivery value
     * @return bool|null
     */
    public function getCraneServiceDelivery()
    {
        return $this->craneServiceDelivery;
    }
    /**
     * Set craneServiceDelivery value
     * @param bool $craneServiceDelivery
     * @return \DBSchenker\StructType\BookingLandType
     */
    public function setCraneServiceDelivery($craneServiceDelivery = null)
    {
        // validation for constraint: boolean
        if (!is_null($craneServiceDelivery) && !is_bool($craneServiceDelivery)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($craneServiceDelivery, true), gettype($craneServiceDelivery)), __LINE__);
        }
        $this->craneServiceDelivery = $craneServiceDelivery;
        return $this;
    }
    /**
     * Get craneServicePickup value
     * @return bool|null
     */
    public function getCraneServicePickup()
    {
        return $this->craneServicePickup;
    }
    /**
     * Set craneServicePickup value
     * @param bool $craneServicePickup
     * @return \DBSchenker\StructType\BookingLandType
     */
    public function setCraneServicePickup($craneServicePickup = null)
    {
        // validation for constraint: boolean
        if (!is_null($craneServicePickup) && !is_bool($craneServicePickup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($craneServicePickup, true), gettype($craneServicePickup)), __LINE__);
        }
        $this->craneServicePickup = $craneServicePickup;
        return $this;
    }
    /**
     * Get recycling value
     * @return int|null
     */
    public function getRecycling()
    {
        return $this->recycling;
    }
    /**
     * Set recycling value
     * @param int $recycling
     * @return \DBSchenker\StructType\BookingLandType
     */
    public function setRecycling($recycling = null)
    {
        // validation for constraint: int
        if (!is_null($recycling) && !(is_int($recycling) || ctype_digit($recycling))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($recycling, true), gettype($recycling)), __LINE__);
        }
        $this->recycling = $recycling;
        return $this;
    }
    /**
     * Get removalAndRecyclingOfPackagingMaterial value
     * @return bool|null
     */
    public function getRemovalAndRecyclingOfPackagingMaterial()
    {
        return $this->removalAndRecyclingOfPackagingMaterial;
    }
    /**
     * Set removalAndRecyclingOfPackagingMaterial value
     * @param bool $removalAndRecyclingOfPackagingMaterial
     * @return \DBSchenker\StructType\BookingLandType
     */
    public function setRemovalAndRecyclingOfPackagingMaterial($removalAndRecyclingOfPackagingMaterial = null)
    {
        // validation for constraint: boolean
        if (!is_null($removalAndRecyclingOfPackagingMaterial) && !is_bool($removalAndRecyclingOfPackagingMaterial)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($removalAndRecyclingOfPackagingMaterial, true), gettype($removalAndRecyclingOfPackagingMaterial)), __LINE__);
        }
        $this->removalAndRecyclingOfPackagingMaterial = $removalAndRecyclingOfPackagingMaterial;
        return $this;
    }
    /**
     * Get sar value
     * @return bool|null
     */
    public function getSar()
    {
        return $this->sar;
    }
    /**
     * Set sar value
     * @param bool $sar
     * @return \DBSchenker\StructType\BookingLandType
     */
    public function setSar($sar = null)
    {
        // validation for constraint: boolean
        if (!is_null($sar) && !is_bool($sar)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sar, true), gettype($sar)), __LINE__);
        }
        $this->sar = $sar;
        return $this;
    }
    /**
     * Get pharma value
     * @return bool|null
     */
    public function getPharma()
    {
        return $this->pharma;
    }
    /**
     * Set pharma value
     * @param bool $pharma
     * @return \DBSchenker\StructType\BookingLandType
     */
    public function setPharma($pharma = null)
    {
        // validation for constraint: boolean
        if (!is_null($pharma) && !is_bool($pharma)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($pharma, true), gettype($pharma)), __LINE__);
        }
        $this->pharma = $pharma;
        return $this;
    }
    /**
     * Get pallet value
     * @return bool|null
     */
    public function getPallet()
    {
        return $this->pallet;
    }
    /**
     * Set pallet value
     * @param bool $pallet
     * @return \DBSchenker\StructType\BookingLandType
     */
    public function setPallet($pallet = null)
    {
        // validation for constraint: boolean
        if (!is_null($pallet) && !is_bool($pallet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($pallet, true), gettype($pallet)), __LINE__);
        }
        $this->pallet = $pallet;
        return $this;
    }
    /**
     * Get weCare value
     * @return bool|null
     */
    public function getWeCare()
    {
        return $this->weCare;
    }
    /**
     * Set weCare value
     * @param bool $weCare
     * @return \DBSchenker\StructType\BookingLandType
     */
    public function setWeCare($weCare = null)
    {
        // validation for constraint: boolean
        if (!is_null($weCare) && !is_bool($weCare)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($weCare, true), gettype($weCare)), __LINE__);
        }
        $this->weCare = $weCare;
        return $this;
    }
    /**
     * Get expressFr value
     * @return bool|null
     */
    public function getExpressFr()
    {
        return $this->expressFr;
    }
    /**
     * Set expressFr value
     * @param bool $expressFr
     * @return \DBSchenker\StructType\BookingLandType
     */
    public function setExpressFr($expressFr = null)
    {
        // validation for constraint: boolean
        if (!is_null($expressFr) && !is_bool($expressFr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($expressFr, true), gettype($expressFr)), __LINE__);
        }
        $this->expressFr = $expressFr;
        return $this;
    }
}
