<?php

namespace DBSchenker\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for bookingAirType StructType
 * Meta information extracted from the WSDL
 * - documentation: Air Booking type
 * @subpackage Structs
 */
class BookingAirType extends BookingType
{
    /**
     * The serviceType
     * Meta information extracted from the WSDL
     * - documentation: Defines service type: D2D, D2A, A2D, A2A
     * - minOccurs: 1
     * @var string
     */
    public $serviceType;
    /**
     * The shippingInformation
     * Meta information extracted from the WSDL
     * - documentation: Holds the air shipping information
     * - minOccurs: 1
     * @var \DBSchenker\StructType\ShippingInformationType
     */
    public $shippingInformation;
    /**
     * The precarriageType
     * Meta information extracted from the WSDL
     * - documentation: Holds precarriage value: PICKUP_REQUEST or OWN_DELIVERY
     * - minOccurs: 1
     * @var string
     */
    public $precarriageType;
    /**
     * The myAirBusiness
     * Meta information extracted from the WSDL
     * - documentation: Specifies "My Air Business"
     * - base: xs:string
     * - maxLength: 500
     * - minOccurs: 0
     * @var string
     */
    public $myAirBusiness;
    /**
     * The departureAirport
     * Meta information extracted from the WSDL
     * - documentation: Defines 3-character airport code of departure
     * - base: xs:string
     * - length: 3
     * - minOccurs: 0
     * @var string
     */
    public $departureAirport;
    /**
     * The destinationAirport
     * Meta information extracted from the WSDL
     * - documentation: Defines 3-character airport code of destination
     * - base: xs:string
     * - length: 3
     * - minOccurs: 0
     * @var string
     */
    public $destinationAirport;
    /**
     * Constructor method for bookingAirType
     * @uses BookingAirType::setServiceType()
     * @uses BookingAirType::setShippingInformation()
     * @uses BookingAirType::setPrecarriageType()
     * @uses BookingAirType::setMyAirBusiness()
     * @uses BookingAirType::setDepartureAirport()
     * @uses BookingAirType::setDestinationAirport()
     * @param string $serviceType
     * @param \DBSchenker\StructType\ShippingInformationType $shippingInformation
     * @param string $precarriageType
     * @param string $myAirBusiness
     * @param string $departureAirport
     * @param string $destinationAirport
     */
    public function __construct($serviceType = null, \DBSchenker\StructType\ShippingInformationType $shippingInformation = null, $precarriageType = null, $myAirBusiness = null, $departureAirport = null, $destinationAirport = null)
    {
        $this
            ->setServiceType($serviceType)
            ->setShippingInformation($shippingInformation)
            ->setPrecarriageType($precarriageType)
            ->setMyAirBusiness($myAirBusiness)
            ->setDepartureAirport($departureAirport)
            ->setDestinationAirport($destinationAirport);
    }
    /**
     * Get serviceType value
     * @return string
     */
    public function getServiceType()
    {
        return $this->serviceType;
    }
    /**
     * Set serviceType value
     * @uses \DBSchenker\EnumType\ServiceAirType::valueIsValid()
     * @uses \DBSchenker\EnumType\ServiceAirType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $serviceType
     * @return \DBSchenker\StructType\BookingAirType
     */
    public function setServiceType($serviceType = null)
    {
        // validation for constraint: enumeration
        if (!\DBSchenker\EnumType\ServiceAirType::valueIsValid($serviceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \DBSchenker\EnumType\ServiceAirType', is_array($serviceType) ? implode(', ', $serviceType) : var_export($serviceType, true), implode(', ', \DBSchenker\EnumType\ServiceAirType::getValidValues())), __LINE__);
        }
        $this->serviceType = $serviceType;
        return $this;
    }
    /**
     * Get shippingInformation value
     * @return \DBSchenker\StructType\ShippingInformationType
     */
    public function getShippingInformation()
    {
        return $this->shippingInformation;
    }
    /**
     * Set shippingInformation value
     * @param \DBSchenker\StructType\ShippingInformationType $shippingInformation
     * @return \DBSchenker\StructType\BookingAirType
     */
    public function setShippingInformation(\DBSchenker\StructType\ShippingInformationType $shippingInformation = null)
    {
        $this->shippingInformation = $shippingInformation;
        return $this;
    }
    /**
     * Get precarriageType value
     * @return string
     */
    public function getPrecarriageType()
    {
        return $this->precarriageType;
    }
    /**
     * Set precarriageType value
     * @uses \DBSchenker\EnumType\PrecarriageType::valueIsValid()
     * @uses \DBSchenker\EnumType\PrecarriageType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $precarriageType
     * @return \DBSchenker\StructType\BookingAirType
     */
    public function setPrecarriageType($precarriageType = null)
    {
        // validation for constraint: enumeration
        if (!\DBSchenker\EnumType\PrecarriageType::valueIsValid($precarriageType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \DBSchenker\EnumType\PrecarriageType', is_array($precarriageType) ? implode(', ', $precarriageType) : var_export($precarriageType, true), implode(', ', \DBSchenker\EnumType\PrecarriageType::getValidValues())), __LINE__);
        }
        $this->precarriageType = $precarriageType;
        return $this;
    }
    /**
     * Get myAirBusiness value
     * @return string|null
     */
    public function getMyAirBusiness()
    {
        return $this->myAirBusiness;
    }
    /**
     * Set myAirBusiness value
     * @param string $myAirBusiness
     * @return \DBSchenker\StructType\BookingAirType
     */
    public function setMyAirBusiness($myAirBusiness = null)
    {
        // validation for constraint: string
        if (!is_null($myAirBusiness) && !is_string($myAirBusiness)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($myAirBusiness, true), gettype($myAirBusiness)), __LINE__);
        }
        // validation for constraint: maxLength(500)
        if (!is_null($myAirBusiness) && mb_strlen($myAirBusiness) > 500) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 500', mb_strlen($myAirBusiness)), __LINE__);
        }
        $this->myAirBusiness = $myAirBusiness;
        return $this;
    }
    /**
     * Get departureAirport value
     * @return string|null
     */
    public function getDepartureAirport()
    {
        return $this->departureAirport;
    }
    /**
     * Set departureAirport value
     * @param string $departureAirport
     * @return \DBSchenker\StructType\BookingAirType
     */
    public function setDepartureAirport($departureAirport = null)
    {
        // validation for constraint: string
        if (!is_null($departureAirport) && !is_string($departureAirport)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departureAirport, true), gettype($departureAirport)), __LINE__);
        }
        // validation for constraint: length(3)
        if (!is_null($departureAirport) && mb_strlen($departureAirport) !== 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 3', mb_strlen($departureAirport)), __LINE__);
        }
        $this->departureAirport = $departureAirport;
        return $this;
    }
    /**
     * Get destinationAirport value
     * @return string|null
     */
    public function getDestinationAirport()
    {
        return $this->destinationAirport;
    }
    /**
     * Set destinationAirport value
     * @param string $destinationAirport
     * @return \DBSchenker\StructType\BookingAirType
     */
    public function setDestinationAirport($destinationAirport = null)
    {
        // validation for constraint: string
        if (!is_null($destinationAirport) && !is_string($destinationAirport)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destinationAirport, true), gettype($destinationAirport)), __LINE__);
        }
        // validation for constraint: length(3)
        if (!is_null($destinationAirport) && mb_strlen($destinationAirport) !== 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 3', mb_strlen($destinationAirport)), __LINE__);
        }
        $this->destinationAirport = $destinationAirport;
        return $this;
    }
}
