<?php

namespace DBSchenker\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for barcodeReferenceType StructType
 * Meta information extracted from the WSDL
 * - documentation: Defines barcode reference
 * @subpackage Structs
 */
class BarcodeReferenceType extends AbstractStructBase
{
    /**
     * The barcode
     * Meta information extracted from the WSDL
     * - documentation: Defines barcode value
     * - base: xs:string
     * - maxLength: 100
     * - minOccurs: 1
     * @var string
     */
    public $barcode;
    /**
     * The barcodeType
     * Meta information extracted from the WSDL
     * - documentation: Defines type of the barcode: SSCC
     * - base: xs:string
     * - maxLength: 30
     * - minOccurs: 1
     * @var string
     */
    public $barcodeType;
    /**
     * Constructor method for barcodeReferenceType
     * @uses BarcodeReferenceType::setBarcode()
     * @uses BarcodeReferenceType::setBarcodeType()
     * @param string $barcode
     * @param string $barcodeType
     */
    public function __construct($barcode = null, $barcodeType = null)
    {
        $this
            ->setBarcode($barcode)
            ->setBarcodeType($barcodeType);
    }
    /**
     * Get barcode value
     * @return string
     */
    public function getBarcode()
    {
        return $this->barcode;
    }
    /**
     * Set barcode value
     * @param string $barcode
     * @return \DBSchenker\StructType\BarcodeReferenceType
     */
    public function setBarcode($barcode = null)
    {
        // validation for constraint: string
        if (!is_null($barcode) && !is_string($barcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($barcode, true), gettype($barcode)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($barcode) && mb_strlen($barcode) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($barcode)), __LINE__);
        }
        $this->barcode = $barcode;
        return $this;
    }
    /**
     * Get barcodeType value
     * @return string
     */
    public function getBarcodeType()
    {
        return $this->barcodeType;
    }
    /**
     * Set barcodeType value
     * @param string $barcodeType
     * @return \DBSchenker\StructType\BarcodeReferenceType
     */
    public function setBarcodeType($barcodeType = null)
    {
        // validation for constraint: string
        if (!is_null($barcodeType) && !is_string($barcodeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($barcodeType, true), gettype($barcodeType)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($barcodeType) && mb_strlen($barcodeType) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($barcodeType)), __LINE__);
        }
        $this->barcodeType = $barcodeType;
        return $this;
    }
}
