<?php

namespace DBSchenker\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for technologyType EnumType
 * Meta information extracted from the WSDL
 * - documentation: Defines technology type
 * @subpackage Enumerations
 */
class TechnologyType extends AbstractStructEnumBase
{
    /**
     * Constant for value 'CODE_XL_TARPAULIN'
     * @return string 'CODE_XL_TARPAULIN'
     */
    const VALUE_CODE_XL_TARPAULIN = 'CODE_XL_TARPAULIN';
    /**
     * Constant for value 'COIL_RECESS'
     * @return string 'COIL_RECESS'
     */
    const VALUE_COIL_RECESS = 'COIL_RECESS';
    /**
     * Constant for value 'TAIL_LIFT'
     * @return string 'TAIL_LIFT'
     */
    const VALUE_TAIL_LIFT = 'TAIL_LIFT';
    /**
     * Constant for value 'FORK_LIFT'
     * @return string 'FORK_LIFT'
     */
    const VALUE_FORK_LIFT = 'FORK_LIFT';
    /**
     * Constant for value 'JOLODA_ROLLER_BED'
     * @return string 'JOLODA_ROLLER_BED'
     */
    const VALUE_JOLODA_ROLLER_BED = 'JOLODA_ROLLER_BED';
    /**
     * Return allowed values
     * @uses self::VALUE_CODE_XL_TARPAULIN
     * @uses self::VALUE_COIL_RECESS
     * @uses self::VALUE_TAIL_LIFT
     * @uses self::VALUE_FORK_LIFT
     * @uses self::VALUE_JOLODA_ROLLER_BED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CODE_XL_TARPAULIN,
            self::VALUE_COIL_RECESS,
            self::VALUE_TAIL_LIFT,
            self::VALUE_FORK_LIFT,
            self::VALUE_JOLODA_ROLLER_BED,
        );
    }
}
