<?php

namespace DBSchenker\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for serviceOceanType EnumType
 * Meta information extracted from the WSDL
 * - documentation: Defines the service type like door2door(D2D), port2port(P2P) ...
 * @subpackage Enumerations
 */
class ServiceOceanType extends AbstractStructEnumBase
{
    /**
     * Constant for value 'D2D'
     * @return string 'D2D'
     */
    const VALUE_D_2_D = 'D2D';
    /**
     * Constant for value 'D2P'
     * @return string 'D2P'
     */
    const VALUE_D_2_P = 'D2P';
    /**
     * Constant for value 'P2D'
     * @return string 'P2D'
     */
    const VALUE_P_2_D = 'P2D';
    /**
     * Constant for value 'P2P'
     * @return string 'P2P'
     */
    const VALUE_P_2_P = 'P2P';
    /**
     * Return allowed values
     * @uses self::VALUE_D_2_D
     * @uses self::VALUE_D_2_P
     * @uses self::VALUE_P_2_D
     * @uses self::VALUE_P_2_P
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_D_2_D,
            self::VALUE_D_2_P,
            self::VALUE_P_2_D,
            self::VALUE_P_2_P,
        );
    }
}
