<?php

namespace DBSchenker\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for packageGroup EnumType
 * Meta information extracted from the WSDL
 * - documentation: Specifies dangerous goods package group: I, II, III, NA
 * @subpackage Enumerations
 */
class PackageGroup extends AbstractStructEnumBase
{
    /**
     * Constant for value 'I'
     * @return string 'I'
     */
    const VALUE_I = 'I';
    /**
     * Constant for value 'II'
     * @return string 'II'
     */
    const VALUE_II = 'II';
    /**
     * Constant for value 'III'
     * @return string 'III'
     */
    const VALUE_III = 'III';
    /**
     * Constant for value 'NA'
     * @return string 'NA'
     */
    const VALUE_NA = 'NA';
    /**
     * Return allowed values
     * @uses self::VALUE_I
     * @uses self::VALUE_II
     * @uses self::VALUE_III
     * @uses self::VALUE_NA
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_I,
            self::VALUE_II,
            self::VALUE_III,
            self::VALUE_NA,
        );
    }
}
