<?php

namespace Service\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TAttivita StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:TAttivita
 * @subpackage Structs
 */
class TAttivita extends AttivitaModel
{
    /**
     * The NumMaxPersonale
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $NumMaxPersonale;
    /**
     * The NumMinPersonale
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $NumMinPersonale;
    /**
     * The Partecipanti
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Service\ArrayType\ArrayOfTPartecipante
     */
    public $Partecipanti;
    /**
     * The Richiesta
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Richiesta;
    /**
     * Constructor method for TAttivita
     * @uses TAttivita::setNumMaxPersonale()
     * @uses TAttivita::setNumMinPersonale()
     * @uses TAttivita::setPartecipanti()
     * @uses TAttivita::setRichiesta()
     * @param int $numMaxPersonale
     * @param int $numMinPersonale
     * @param \Service\ArrayType\ArrayOfTPartecipante $partecipanti
     * @param bool $richiesta
     */
    public function __construct($numMaxPersonale = null, $numMinPersonale = null, \Service\ArrayType\ArrayOfTPartecipante $partecipanti = null, $richiesta = null)
    {
        $this
            ->setNumMaxPersonale($numMaxPersonale)
            ->setNumMinPersonale($numMinPersonale)
            ->setPartecipanti($partecipanti)
            ->setRichiesta($richiesta);
    }
    /**
     * Get NumMaxPersonale value
     * @return int|null
     */
    public function getNumMaxPersonale()
    {
        return $this->NumMaxPersonale;
    }
    /**
     * Set NumMaxPersonale value
     * @param int $numMaxPersonale
     * @return \Service\StructType\TAttivita
     */
    public function setNumMaxPersonale($numMaxPersonale = null)
    {
        $this->NumMaxPersonale = $numMaxPersonale;
        return $this;
    }
    /**
     * Get NumMinPersonale value
     * @return int|null
     */
    public function getNumMinPersonale()
    {
        return $this->NumMinPersonale;
    }
    /**
     * Set NumMinPersonale value
     * @param int $numMinPersonale
     * @return \Service\StructType\TAttivita
     */
    public function setNumMinPersonale($numMinPersonale = null)
    {
        $this->NumMinPersonale = $numMinPersonale;
        return $this;
    }
    /**
     * Get Partecipanti value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Service\ArrayType\ArrayOfTPartecipante|null
     */
    public function getPartecipanti()
    {
        return isset($this->Partecipanti) ? $this->Partecipanti : null;
    }
    /**
     * Set Partecipanti value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Service\ArrayType\ArrayOfTPartecipante $partecipanti
     * @return \Service\StructType\TAttivita
     */
    public function setPartecipanti(\Service\ArrayType\ArrayOfTPartecipante $partecipanti = null)
    {
        if (is_null($partecipanti) || (is_array($partecipanti) && empty($partecipanti))) {
            unset($this->Partecipanti);
        } else {
            $this->Partecipanti = $partecipanti;
        }
        return $this;
    }
    /**
     * Get Richiesta value
     * @return bool|null
     */
    public function getRichiesta()
    {
        return $this->Richiesta;
    }
    /**
     * Set Richiesta value
     * @param bool $richiesta
     * @return \Service\StructType\TAttivita
     */
    public function setRichiesta($richiesta = null)
    {
        $this->Richiesta = $richiesta;
        return $this;
    }
}
