<?php

namespace Service\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SendRecapiti StructType
 * @subpackage Structs
 */
class SendRecapiti extends AbstractStructBase
{
    /**
     * The IDAnagrafe
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IDAnagrafe;
    /**
     * The Recapiti
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Service\ArrayType\ArrayOfRecapito
     */
    public $Recapiti;
    /**
     * Constructor method for SendRecapiti
     * @uses SendRecapiti::setIDAnagrafe()
     * @uses SendRecapiti::setRecapiti()
     * @param int $iDAnagrafe
     * @param \Service\ArrayType\ArrayOfRecapito $recapiti
     */
    public function __construct($iDAnagrafe = null, \Service\ArrayType\ArrayOfRecapito $recapiti = null)
    {
        $this
            ->setIDAnagrafe($iDAnagrafe)
            ->setRecapiti($recapiti);
    }
    /**
     * Get IDAnagrafe value
     * @return int|null
     */
    public function getIDAnagrafe()
    {
        return $this->IDAnagrafe;
    }
    /**
     * Set IDAnagrafe value
     * @param int $iDAnagrafe
     * @return \Service\StructType\SendRecapiti
     */
    public function setIDAnagrafe($iDAnagrafe = null)
    {
        $this->IDAnagrafe = $iDAnagrafe;
        return $this;
    }
    /**
     * Get Recapiti value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Service\ArrayType\ArrayOfRecapito|null
     */
    public function getRecapiti()
    {
        return isset($this->Recapiti) ? $this->Recapiti : null;
    }
    /**
     * Set Recapiti value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Service\ArrayType\ArrayOfRecapito $recapiti
     * @return \Service\StructType\SendRecapiti
     */
    public function setRecapiti(\Service\ArrayType\ArrayOfRecapito $recapiti = null)
    {
        if (is_null($recapiti) || (is_array($recapiti) && empty($recapiti))) {
            unset($this->Recapiti);
        } else {
            $this->Recapiti = $recapiti;
        }
        return $this;
    }
}
