<?php

namespace Service\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Login_SGEServer_Result StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Login_SGEServer_Result
 * @subpackage Structs
 */
class Login_SGEServer_Result extends AbstractStructBase
{
    /**
     * The AuthToken
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AuthToken;
    /**
     * The ClasseNuoviSoci
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Service\StructType\Classe_Model
     */
    public $ClasseNuoviSoci;
    /**
     * The ClasseRiattivazioneSoci
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Service\StructType\Classe_Model
     */
    public $ClasseRiattivazioneSoci;
    /**
     * The Informazioni
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Service\StructType\AdditionaInformation
     */
    public $Informazioni;
    /**
     * The Province
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Service\ArrayType\ArrayOfProvincia_Model
     */
    public $Province;
    /**
     * The TipiRecpito
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Service\ArrayType\ArrayOfTipoRecapito
     */
    public $TipiRecpito;
    /**
     * Constructor method for Login_SGEServer_Result
     * @uses Login_SGEServer_Result::setAuthToken()
     * @uses Login_SGEServer_Result::setClasseNuoviSoci()
     * @uses Login_SGEServer_Result::setClasseRiattivazioneSoci()
     * @uses Login_SGEServer_Result::setInformazioni()
     * @uses Login_SGEServer_Result::setProvince()
     * @uses Login_SGEServer_Result::setTipiRecpito()
     * @param string $authToken
     * @param \Service\StructType\Classe_Model $classeNuoviSoci
     * @param \Service\StructType\Classe_Model $classeRiattivazioneSoci
     * @param \Service\StructType\AdditionaInformation $informazioni
     * @param \Service\ArrayType\ArrayOfProvincia_Model $province
     * @param \Service\ArrayType\ArrayOfTipoRecapito $tipiRecpito
     */
    public function __construct($authToken = null, \Service\StructType\Classe_Model $classeNuoviSoci = null, \Service\StructType\Classe_Model $classeRiattivazioneSoci = null, \Service\StructType\AdditionaInformation $informazioni = null, \Service\ArrayType\ArrayOfProvincia_Model $province = null, \Service\ArrayType\ArrayOfTipoRecapito $tipiRecpito = null)
    {
        $this
            ->setAuthToken($authToken)
            ->setClasseNuoviSoci($classeNuoviSoci)
            ->setClasseRiattivazioneSoci($classeRiattivazioneSoci)
            ->setInformazioni($informazioni)
            ->setProvince($province)
            ->setTipiRecpito($tipiRecpito);
    }
    /**
     * Get AuthToken value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAuthToken()
    {
        return isset($this->AuthToken) ? $this->AuthToken : null;
    }
    /**
     * Set AuthToken value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $authToken
     * @return \Service\StructType\Login_SGEServer_Result
     */
    public function setAuthToken($authToken = null)
    {
        if (is_null($authToken) || (is_array($authToken) && empty($authToken))) {
            unset($this->AuthToken);
        } else {
            $this->AuthToken = $authToken;
        }
        return $this;
    }
    /**
     * Get ClasseNuoviSoci value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Service\StructType\Classe_Model|null
     */
    public function getClasseNuoviSoci()
    {
        return isset($this->ClasseNuoviSoci) ? $this->ClasseNuoviSoci : null;
    }
    /**
     * Set ClasseNuoviSoci value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Service\StructType\Classe_Model $classeNuoviSoci
     * @return \Service\StructType\Login_SGEServer_Result
     */
    public function setClasseNuoviSoci(\Service\StructType\Classe_Model $classeNuoviSoci = null)
    {
        if (is_null($classeNuoviSoci) || (is_array($classeNuoviSoci) && empty($classeNuoviSoci))) {
            unset($this->ClasseNuoviSoci);
        } else {
            $this->ClasseNuoviSoci = $classeNuoviSoci;
        }
        return $this;
    }
    /**
     * Get ClasseRiattivazioneSoci value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Service\StructType\Classe_Model|null
     */
    public function getClasseRiattivazioneSoci()
    {
        return isset($this->ClasseRiattivazioneSoci) ? $this->ClasseRiattivazioneSoci : null;
    }
    /**
     * Set ClasseRiattivazioneSoci value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Service\StructType\Classe_Model $classeRiattivazioneSoci
     * @return \Service\StructType\Login_SGEServer_Result
     */
    public function setClasseRiattivazioneSoci(\Service\StructType\Classe_Model $classeRiattivazioneSoci = null)
    {
        if (is_null($classeRiattivazioneSoci) || (is_array($classeRiattivazioneSoci) && empty($classeRiattivazioneSoci))) {
            unset($this->ClasseRiattivazioneSoci);
        } else {
            $this->ClasseRiattivazioneSoci = $classeRiattivazioneSoci;
        }
        return $this;
    }
    /**
     * Get Informazioni value
     * @return \Service\StructType\AdditionaInformation|null
     */
    public function getInformazioni()
    {
        return $this->Informazioni;
    }
    /**
     * Set Informazioni value
     * @param \Service\StructType\AdditionaInformation $informazioni
     * @return \Service\StructType\Login_SGEServer_Result
     */
    public function setInformazioni(\Service\StructType\AdditionaInformation $informazioni = null)
    {
        $this->Informazioni = $informazioni;
        return $this;
    }
    /**
     * Get Province value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Service\ArrayType\ArrayOfProvincia_Model|null
     */
    public function getProvince()
    {
        return isset($this->Province) ? $this->Province : null;
    }
    /**
     * Set Province value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Service\ArrayType\ArrayOfProvincia_Model $province
     * @return \Service\StructType\Login_SGEServer_Result
     */
    public function setProvince(\Service\ArrayType\ArrayOfProvincia_Model $province = null)
    {
        if (is_null($province) || (is_array($province) && empty($province))) {
            unset($this->Province);
        } else {
            $this->Province = $province;
        }
        return $this;
    }
    /**
     * Get TipiRecpito value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Service\ArrayType\ArrayOfTipoRecapito|null
     */
    public function getTipiRecpito()
    {
        return isset($this->TipiRecpito) ? $this->TipiRecpito : null;
    }
    /**
     * Set TipiRecpito value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Service\ArrayType\ArrayOfTipoRecapito $tipiRecpito
     * @return \Service\StructType\Login_SGEServer_Result
     */
    public function setTipiRecpito(\Service\ArrayType\ArrayOfTipoRecapito $tipiRecpito = null)
    {
        if (is_null($tipiRecpito) || (is_array($tipiRecpito) && empty($tipiRecpito))) {
            unset($this->TipiRecpito);
        } else {
            $this->TipiRecpito = $tipiRecpito;
        }
        return $this;
    }
}
