<?php

namespace Service\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InviaPresenza StructType
 * @subpackage Structs
 */
class InviaPresenza extends AbstractStructBase
{
    /**
     * The IDAnagafica
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IDAnagafica;
    /**
     * The IDSezione
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IDSezione;
    /**
     * The Causale
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Causale;
    /**
     * The IDAttivita
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IDAttivita;
    /**
     * Constructor method for InviaPresenza
     * @uses InviaPresenza::setIDAnagafica()
     * @uses InviaPresenza::setIDSezione()
     * @uses InviaPresenza::setCausale()
     * @uses InviaPresenza::setIDAttivita()
     * @param int $iDAnagafica
     * @param string $iDSezione
     * @param string $causale
     * @param int $iDAttivita
     */
    public function __construct($iDAnagafica = null, $iDSezione = null, $causale = null, $iDAttivita = null)
    {
        $this
            ->setIDAnagafica($iDAnagafica)
            ->setIDSezione($iDSezione)
            ->setCausale($causale)
            ->setIDAttivita($iDAttivita);
    }
    /**
     * Get IDAnagafica value
     * @return int|null
     */
    public function getIDAnagafica()
    {
        return $this->IDAnagafica;
    }
    /**
     * Set IDAnagafica value
     * @param int $iDAnagafica
     * @return \Service\StructType\InviaPresenza
     */
    public function setIDAnagafica($iDAnagafica = null)
    {
        $this->IDAnagafica = $iDAnagafica;
        return $this;
    }
    /**
     * Get IDSezione value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIDSezione()
    {
        return isset($this->IDSezione) ? $this->IDSezione : null;
    }
    /**
     * Set IDSezione value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $iDSezione
     * @return \Service\StructType\InviaPresenza
     */
    public function setIDSezione($iDSezione = null)
    {
        if (is_null($iDSezione) || (is_array($iDSezione) && empty($iDSezione))) {
            unset($this->IDSezione);
        } else {
            $this->IDSezione = $iDSezione;
        }
        return $this;
    }
    /**
     * Get Causale value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCausale()
    {
        return isset($this->Causale) ? $this->Causale : null;
    }
    /**
     * Set Causale value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $causale
     * @return \Service\StructType\InviaPresenza
     */
    public function setCausale($causale = null)
    {
        if (is_null($causale) || (is_array($causale) && empty($causale))) {
            unset($this->Causale);
        } else {
            $this->Causale = $causale;
        }
        return $this;
    }
    /**
     * Get IDAttivita value
     * @return int|null
     */
    public function getIDAttivita()
    {
        return $this->IDAttivita;
    }
    /**
     * Set IDAttivita value
     * @param int $iDAttivita
     * @return \Service\StructType\InviaPresenza
     */
    public function setIDAttivita($iDAttivita = null)
    {
        $this->IDAttivita = $iDAttivita;
        return $this;
    }
}
