<?php

namespace Service\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetQualifiche_Result StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetQualifiche_Result
 * @subpackage Structs
 */
class GetQualifiche_Result extends AbstractStructBase
{
    /**
     * The Informazioni
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Service\StructType\AdditionaInformation
     */
    public $Informazioni;
    /**
     * The Qualifiche
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Service\ArrayType\ArrayOfQualifica
     */
    public $Qualifiche;
    /**
     * Constructor method for GetQualifiche_Result
     * @uses GetQualifiche_Result::setInformazioni()
     * @uses GetQualifiche_Result::setQualifiche()
     * @param \Service\StructType\AdditionaInformation $informazioni
     * @param \Service\ArrayType\ArrayOfQualifica $qualifiche
     */
    public function __construct(\Service\StructType\AdditionaInformation $informazioni = null, \Service\ArrayType\ArrayOfQualifica $qualifiche = null)
    {
        $this
            ->setInformazioni($informazioni)
            ->setQualifiche($qualifiche);
    }
    /**
     * Get Informazioni value
     * @return \Service\StructType\AdditionaInformation|null
     */
    public function getInformazioni()
    {
        return $this->Informazioni;
    }
    /**
     * Set Informazioni value
     * @param \Service\StructType\AdditionaInformation $informazioni
     * @return \Service\StructType\GetQualifiche_Result
     */
    public function setInformazioni(\Service\StructType\AdditionaInformation $informazioni = null)
    {
        $this->Informazioni = $informazioni;
        return $this;
    }
    /**
     * Get Qualifiche value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Service\ArrayType\ArrayOfQualifica|null
     */
    public function getQualifiche()
    {
        return isset($this->Qualifiche) ? $this->Qualifiche : null;
    }
    /**
     * Set Qualifiche value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Service\ArrayType\ArrayOfQualifica $qualifiche
     * @return \Service\StructType\GetQualifiche_Result
     */
    public function setQualifiche(\Service\ArrayType\ArrayOfQualifica $qualifiche = null)
    {
        if (is_null($qualifiche) || (is_array($qualifiche) && empty($qualifiche))) {
            unset($this->Qualifiche);
        } else {
            $this->Qualifiche = $qualifiche;
        }
        return $this;
    }
}
