<?php

namespace Service\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Anagrafe_Get_Result StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Anagrafe_Get_Result
 * @subpackage Structs
 */
class Anagrafe_Get_Result extends WebService_GenericResult
{
    /**
     * The Anagrafica
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Service\StructType\AnagraficaDettaglio_Model
     */
    public $Anagrafica;
    /**
     * The ComuniDomicilio
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Service\ArrayType\ArrayOfResultCodiceDescrizione
     */
    public $ComuniDomicilio;
    /**
     * The ComuniNascita
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Service\ArrayType\ArrayOfResultCodiceDescrizione
     */
    public $ComuniNascita;
    /**
     * The ComuniResidenza
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Service\ArrayType\ArrayOfResultCodiceDescrizione
     */
    public $ComuniResidenza;
    /**
     * Constructor method for Anagrafe_Get_Result
     * @uses Anagrafe_Get_Result::setAnagrafica()
     * @uses Anagrafe_Get_Result::setComuniDomicilio()
     * @uses Anagrafe_Get_Result::setComuniNascita()
     * @uses Anagrafe_Get_Result::setComuniResidenza()
     * @param \Service\StructType\AnagraficaDettaglio_Model $anagrafica
     * @param \Service\ArrayType\ArrayOfResultCodiceDescrizione $comuniDomicilio
     * @param \Service\ArrayType\ArrayOfResultCodiceDescrizione $comuniNascita
     * @param \Service\ArrayType\ArrayOfResultCodiceDescrizione $comuniResidenza
     */
    public function __construct(\Service\StructType\AnagraficaDettaglio_Model $anagrafica = null, \Service\ArrayType\ArrayOfResultCodiceDescrizione $comuniDomicilio = null, \Service\ArrayType\ArrayOfResultCodiceDescrizione $comuniNascita = null, \Service\ArrayType\ArrayOfResultCodiceDescrizione $comuniResidenza = null)
    {
        $this
            ->setAnagrafica($anagrafica)
            ->setComuniDomicilio($comuniDomicilio)
            ->setComuniNascita($comuniNascita)
            ->setComuniResidenza($comuniResidenza);
    }
    /**
     * Get Anagrafica value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Service\StructType\AnagraficaDettaglio_Model|null
     */
    public function getAnagrafica()
    {
        return isset($this->Anagrafica) ? $this->Anagrafica : null;
    }
    /**
     * Set Anagrafica value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Service\StructType\AnagraficaDettaglio_Model $anagrafica
     * @return \Service\StructType\Anagrafe_Get_Result
     */
    public function setAnagrafica(\Service\StructType\AnagraficaDettaglio_Model $anagrafica = null)
    {
        if (is_null($anagrafica) || (is_array($anagrafica) && empty($anagrafica))) {
            unset($this->Anagrafica);
        } else {
            $this->Anagrafica = $anagrafica;
        }
        return $this;
    }
    /**
     * Get ComuniDomicilio value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Service\ArrayType\ArrayOfResultCodiceDescrizione|null
     */
    public function getComuniDomicilio()
    {
        return isset($this->ComuniDomicilio) ? $this->ComuniDomicilio : null;
    }
    /**
     * Set ComuniDomicilio value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Service\ArrayType\ArrayOfResultCodiceDescrizione $comuniDomicilio
     * @return \Service\StructType\Anagrafe_Get_Result
     */
    public function setComuniDomicilio(\Service\ArrayType\ArrayOfResultCodiceDescrizione $comuniDomicilio = null)
    {
        if (is_null($comuniDomicilio) || (is_array($comuniDomicilio) && empty($comuniDomicilio))) {
            unset($this->ComuniDomicilio);
        } else {
            $this->ComuniDomicilio = $comuniDomicilio;
        }
        return $this;
    }
    /**
     * Get ComuniNascita value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Service\ArrayType\ArrayOfResultCodiceDescrizione|null
     */
    public function getComuniNascita()
    {
        return isset($this->ComuniNascita) ? $this->ComuniNascita : null;
    }
    /**
     * Set ComuniNascita value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Service\ArrayType\ArrayOfResultCodiceDescrizione $comuniNascita
     * @return \Service\StructType\Anagrafe_Get_Result
     */
    public function setComuniNascita(\Service\ArrayType\ArrayOfResultCodiceDescrizione $comuniNascita = null)
    {
        if (is_null($comuniNascita) || (is_array($comuniNascita) && empty($comuniNascita))) {
            unset($this->ComuniNascita);
        } else {
            $this->ComuniNascita = $comuniNascita;
        }
        return $this;
    }
    /**
     * Get ComuniResidenza value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Service\ArrayType\ArrayOfResultCodiceDescrizione|null
     */
    public function getComuniResidenza()
    {
        return isset($this->ComuniResidenza) ? $this->ComuniResidenza : null;
    }
    /**
     * Set ComuniResidenza value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Service\ArrayType\ArrayOfResultCodiceDescrizione $comuniResidenza
     * @return \Service\StructType\Anagrafe_Get_Result
     */
    public function setComuniResidenza(\Service\ArrayType\ArrayOfResultCodiceDescrizione $comuniResidenza = null)
    {
        if (is_null($comuniResidenza) || (is_array($comuniResidenza) && empty($comuniResidenza))) {
            unset($this->ComuniResidenza);
        } else {
            $this->ComuniResidenza = $comuniResidenza;
        }
        return $this;
    }
}
