<?php

namespace Service\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfTPartecipante ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfTPartecipante
 * @subpackage Arrays
 */
class ArrayOfTPartecipante extends AbstractStructArrayBase
{
    /**
     * The TPartecipante
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Service\StructType\TPartecipante[]
     */
    public $TPartecipante;
    /**
     * Constructor method for ArrayOfTPartecipante
     * @uses ArrayOfTPartecipante::setTPartecipante()
     * @param \Service\StructType\TPartecipante[] $tPartecipante
     */
    public function __construct(array $tPartecipante = array())
    {
        $this
            ->setTPartecipante($tPartecipante);
    }
    /**
     * Get TPartecipante value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Service\StructType\TPartecipante[]|null
     */
    public function getTPartecipante()
    {
        return isset($this->TPartecipante) ? $this->TPartecipante : null;
    }
    /**
     * Set TPartecipante value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Service\StructType\TPartecipante[] $tPartecipante
     * @return \Service\ArrayType\ArrayOfTPartecipante
     */
    public function setTPartecipante(array $tPartecipante = array())
    {
        if (is_null($tPartecipante) || (is_array($tPartecipante) && empty($tPartecipante))) {
            unset($this->TPartecipante);
        } else {
            $this->TPartecipante = $tPartecipante;
        }
        return $this;
    }
    /**
     * Add item to TPartecipante value
     * @throws \InvalidArgumentException
     * @param \Service\StructType\TPartecipante $item
     * @return \Service\ArrayType\ArrayOfTPartecipante
     */
    public function addToTPartecipante(\Service\StructType\TPartecipante $item)
    {
        $this->TPartecipante[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \Service\StructType\TPartecipante|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \Service\StructType\TPartecipante|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \Service\StructType\TPartecipante|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \Service\StructType\TPartecipante|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \Service\StructType\TPartecipante|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string TPartecipante
     */
    public function getAttributeName()
    {
        return 'TPartecipante';
    }
}
