<?php

namespace Service\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfRecapito ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfRecapito
 * @subpackage Arrays
 */
class ArrayOfRecapito extends AbstractStructArrayBase
{
    /**
     * The Recapito
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Service\StructType\Recapito[]
     */
    public $Recapito;
    /**
     * Constructor method for ArrayOfRecapito
     * @uses ArrayOfRecapito::setRecapito()
     * @param \Service\StructType\Recapito[] $recapito
     */
    public function __construct(array $recapito = array())
    {
        $this
            ->setRecapito($recapito);
    }
    /**
     * Get Recapito value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Service\StructType\Recapito[]|null
     */
    public function getRecapito()
    {
        return isset($this->Recapito) ? $this->Recapito : null;
    }
    /**
     * Set Recapito value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Service\StructType\Recapito[] $recapito
     * @return \Service\ArrayType\ArrayOfRecapito
     */
    public function setRecapito(array $recapito = array())
    {
        if (is_null($recapito) || (is_array($recapito) && empty($recapito))) {
            unset($this->Recapito);
        } else {
            $this->Recapito = $recapito;
        }
        return $this;
    }
    /**
     * Add item to Recapito value
     * @throws \InvalidArgumentException
     * @param \Service\StructType\Recapito $item
     * @return \Service\ArrayType\ArrayOfRecapito
     */
    public function addToRecapito(\Service\StructType\Recapito $item)
    {
        $this->Recapito[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \Service\StructType\Recapito|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \Service\StructType\Recapito|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \Service\StructType\Recapito|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \Service\StructType\Recapito|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \Service\StructType\Recapito|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Recapito
     */
    public function getAttributeName()
    {
        return 'Recapito';
    }
}
