<?php

namespace Service\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfQualifica ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfQualifica
 * @subpackage Arrays
 */
class ArrayOfQualifica extends AbstractStructArrayBase
{
    /**
     * The Qualifica
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Service\StructType\Qualifica[]
     */
    public $Qualifica;
    /**
     * Constructor method for ArrayOfQualifica
     * @uses ArrayOfQualifica::setQualifica()
     * @param \Service\StructType\Qualifica[] $qualifica
     */
    public function __construct(array $qualifica = array())
    {
        $this
            ->setQualifica($qualifica);
    }
    /**
     * Get Qualifica value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Service\StructType\Qualifica[]|null
     */
    public function getQualifica()
    {
        return isset($this->Qualifica) ? $this->Qualifica : null;
    }
    /**
     * Set Qualifica value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Service\StructType\Qualifica[] $qualifica
     * @return \Service\ArrayType\ArrayOfQualifica
     */
    public function setQualifica(array $qualifica = array())
    {
        if (is_null($qualifica) || (is_array($qualifica) && empty($qualifica))) {
            unset($this->Qualifica);
        } else {
            $this->Qualifica = $qualifica;
        }
        return $this;
    }
    /**
     * Add item to Qualifica value
     * @throws \InvalidArgumentException
     * @param \Service\StructType\Qualifica $item
     * @return \Service\ArrayType\ArrayOfQualifica
     */
    public function addToQualifica(\Service\StructType\Qualifica $item)
    {
        $this->Qualifica[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \Service\StructType\Qualifica|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \Service\StructType\Qualifica|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \Service\StructType\Qualifica|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \Service\StructType\Qualifica|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \Service\StructType\Qualifica|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Qualifica
     */
    public function getAttributeName()
    {
        return 'Qualifica';
    }
}
