<?php

namespace Service\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfNotificaClient ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfNotificaClient
 * @subpackage Arrays
 */
class ArrayOfNotificaClient extends AbstractStructArrayBase
{
    /**
     * The NotificaClient
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Service\StructType\NotificaClient[]
     */
    public $NotificaClient;
    /**
     * Constructor method for ArrayOfNotificaClient
     * @uses ArrayOfNotificaClient::setNotificaClient()
     * @param \Service\StructType\NotificaClient[] $notificaClient
     */
    public function __construct(array $notificaClient = array())
    {
        $this
            ->setNotificaClient($notificaClient);
    }
    /**
     * Get NotificaClient value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Service\StructType\NotificaClient[]|null
     */
    public function getNotificaClient()
    {
        return isset($this->NotificaClient) ? $this->NotificaClient : null;
    }
    /**
     * Set NotificaClient value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Service\StructType\NotificaClient[] $notificaClient
     * @return \Service\ArrayType\ArrayOfNotificaClient
     */
    public function setNotificaClient(array $notificaClient = array())
    {
        if (is_null($notificaClient) || (is_array($notificaClient) && empty($notificaClient))) {
            unset($this->NotificaClient);
        } else {
            $this->NotificaClient = $notificaClient;
        }
        return $this;
    }
    /**
     * Add item to NotificaClient value
     * @throws \InvalidArgumentException
     * @param \Service\StructType\NotificaClient $item
     * @return \Service\ArrayType\ArrayOfNotificaClient
     */
    public function addToNotificaClient(\Service\StructType\NotificaClient $item)
    {
        $this->NotificaClient[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \Service\StructType\NotificaClient|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \Service\StructType\NotificaClient|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \Service\StructType\NotificaClient|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \Service\StructType\NotificaClient|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \Service\StructType\NotificaClient|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string NotificaClient
     */
    public function getAttributeName()
    {
        return 'NotificaClient';
    }
}
