<?php

namespace Service\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfEvento ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfEvento
 * @subpackage Arrays
 */
class ArrayOfEvento extends AbstractStructArrayBase
{
    /**
     * The Evento
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Service\StructType\Evento[]
     */
    public $Evento;
    /**
     * Constructor method for ArrayOfEvento
     * @uses ArrayOfEvento::setEvento()
     * @param \Service\StructType\Evento[] $evento
     */
    public function __construct(array $evento = array())
    {
        $this
            ->setEvento($evento);
    }
    /**
     * Get Evento value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Service\StructType\Evento[]|null
     */
    public function getEvento()
    {
        return isset($this->Evento) ? $this->Evento : null;
    }
    /**
     * Set Evento value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Service\StructType\Evento[] $evento
     * @return \Service\ArrayType\ArrayOfEvento
     */
    public function setEvento(array $evento = array())
    {
        if (is_null($evento) || (is_array($evento) && empty($evento))) {
            unset($this->Evento);
        } else {
            $this->Evento = $evento;
        }
        return $this;
    }
    /**
     * Add item to Evento value
     * @throws \InvalidArgumentException
     * @param \Service\StructType\Evento $item
     * @return \Service\ArrayType\ArrayOfEvento
     */
    public function addToEvento(\Service\StructType\Evento $item)
    {
        $this->Evento[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \Service\StructType\Evento|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \Service\StructType\Evento|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \Service\StructType\Evento|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \Service\StructType\Evento|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \Service\StructType\Evento|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Evento
     */
    public function getAttributeName()
    {
        return 'Evento';
    }
}
