<?php

namespace Service\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCorso ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfCorso
 * @subpackage Arrays
 */
class ArrayOfCorso extends AbstractStructArrayBase
{
    /**
     * The Corso
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Service\StructType\Corso[]
     */
    public $Corso;
    /**
     * Constructor method for ArrayOfCorso
     * @uses ArrayOfCorso::setCorso()
     * @param \Service\StructType\Corso[] $corso
     */
    public function __construct(array $corso = array())
    {
        $this
            ->setCorso($corso);
    }
    /**
     * Get Corso value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Service\StructType\Corso[]|null
     */
    public function getCorso()
    {
        return isset($this->Corso) ? $this->Corso : null;
    }
    /**
     * Set Corso value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Service\StructType\Corso[] $corso
     * @return \Service\ArrayType\ArrayOfCorso
     */
    public function setCorso(array $corso = array())
    {
        if (is_null($corso) || (is_array($corso) && empty($corso))) {
            unset($this->Corso);
        } else {
            $this->Corso = $corso;
        }
        return $this;
    }
    /**
     * Add item to Corso value
     * @throws \InvalidArgumentException
     * @param \Service\StructType\Corso $item
     * @return \Service\ArrayType\ArrayOfCorso
     */
    public function addToCorso(\Service\StructType\Corso $item)
    {
        $this->Corso[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \Service\StructType\Corso|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \Service\StructType\Corso|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \Service\StructType\Corso|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \Service\StructType\Corso|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \Service\StructType\Corso|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Corso
     */
    public function getAttributeName()
    {
        return 'Corso';
    }
}
