<?php

namespace Service\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetNotifiche_Result StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetNotifiche_Result
 * @subpackage Structs
 */
class GetNotifiche_Result extends WebService_GenericResult
{
    /**
     * The Notifiche
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Service\ArrayType\ArrayOfNotificaClient
     */
    public $Notifiche;
    /**
     * The NotificheResidue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $NotificheResidue;
    /**
     * The TotaleNotficheDaNotificare
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TotaleNotficheDaNotificare;
    /**
     * Constructor method for GetNotifiche_Result
     * @uses GetNotifiche_Result::setNotifiche()
     * @uses GetNotifiche_Result::setNotificheResidue()
     * @uses GetNotifiche_Result::setTotaleNotficheDaNotificare()
     * @param \Service\ArrayType\ArrayOfNotificaClient $notifiche
     * @param bool $notificheResidue
     * @param int $totaleNotficheDaNotificare
     */
    public function __construct(\Service\ArrayType\ArrayOfNotificaClient $notifiche = null, $notificheResidue = null, $totaleNotficheDaNotificare = null)
    {
        $this
            ->setNotifiche($notifiche)
            ->setNotificheResidue($notificheResidue)
            ->setTotaleNotficheDaNotificare($totaleNotficheDaNotificare);
    }
    /**
     * Get Notifiche value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Service\ArrayType\ArrayOfNotificaClient|null
     */
    public function getNotifiche()
    {
        return isset($this->Notifiche) ? $this->Notifiche : null;
    }
    /**
     * Set Notifiche value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Service\ArrayType\ArrayOfNotificaClient $notifiche
     * @return \Service\StructType\GetNotifiche_Result
     */
    public function setNotifiche(\Service\ArrayType\ArrayOfNotificaClient $notifiche = null)
    {
        if (is_null($notifiche) || (is_array($notifiche) && empty($notifiche))) {
            unset($this->Notifiche);
        } else {
            $this->Notifiche = $notifiche;
        }
        return $this;
    }
    /**
     * Get NotificheResidue value
     * @return bool|null
     */
    public function getNotificheResidue()
    {
        return $this->NotificheResidue;
    }
    /**
     * Set NotificheResidue value
     * @param bool $notificheResidue
     * @return \Service\StructType\GetNotifiche_Result
     */
    public function setNotificheResidue($notificheResidue = null)
    {
        $this->NotificheResidue = $notificheResidue;
        return $this;
    }
    /**
     * Get TotaleNotficheDaNotificare value
     * @return int|null
     */
    public function getTotaleNotficheDaNotificare()
    {
        return $this->TotaleNotficheDaNotificare;
    }
    /**
     * Set TotaleNotficheDaNotificare value
     * @param int $totaleNotficheDaNotificare
     * @return \Service\StructType\GetNotifiche_Result
     */
    public function setTotaleNotficheDaNotificare($totaleNotficheDaNotificare = null)
    {
        $this->TotaleNotficheDaNotificare = $totaleNotficheDaNotificare;
        return $this;
    }
}
