<?php

namespace Service\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPartecipante ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfPartecipante
 * @subpackage Arrays
 */
class ArrayOfPartecipante extends AbstractStructArrayBase
{
    /**
     * The Partecipante
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Service\StructType\Partecipante[]
     */
    public $Partecipante;
    /**
     * Constructor method for ArrayOfPartecipante
     * @uses ArrayOfPartecipante::setPartecipante()
     * @param \Service\StructType\Partecipante[] $partecipante
     */
    public function __construct(array $partecipante = array())
    {
        $this
            ->setPartecipante($partecipante);
    }
    /**
     * Get Partecipante value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Service\StructType\Partecipante[]|null
     */
    public function getPartecipante()
    {
        return isset($this->Partecipante) ? $this->Partecipante : null;
    }
    /**
     * Set Partecipante value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Service\StructType\Partecipante[] $partecipante
     * @return \Service\ArrayType\ArrayOfPartecipante
     */
    public function setPartecipante(array $partecipante = array())
    {
        if (is_null($partecipante) || (is_array($partecipante) && empty($partecipante))) {
            unset($this->Partecipante);
        } else {
            $this->Partecipante = $partecipante;
        }
        return $this;
    }
    /**
     * Add item to Partecipante value
     * @throws \InvalidArgumentException
     * @param \Service\StructType\Partecipante $item
     * @return \Service\ArrayType\ArrayOfPartecipante
     */
    public function addToPartecipante(\Service\StructType\Partecipante $item)
    {
        $this->Partecipante[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \Service\StructType\Partecipante|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \Service\StructType\Partecipante|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \Service\StructType\Partecipante|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \Service\StructType\Partecipante|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \Service\StructType\Partecipante|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Partecipante
     */
    public function getAttributeName()
    {
        return 'Partecipante';
    }
}
