<?php

namespace Service\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfMessaggio ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfMessaggio
 * @subpackage Arrays
 */
class ArrayOfMessaggio extends AbstractStructArrayBase
{
    /**
     * The Messaggio
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Service\StructType\Messaggio[]
     */
    public $Messaggio;
    /**
     * Constructor method for ArrayOfMessaggio
     * @uses ArrayOfMessaggio::setMessaggio()
     * @param \Service\StructType\Messaggio[] $messaggio
     */
    public function __construct(array $messaggio = array())
    {
        $this
            ->setMessaggio($messaggio);
    }
    /**
     * Get Messaggio value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Service\StructType\Messaggio[]|null
     */
    public function getMessaggio()
    {
        return isset($this->Messaggio) ? $this->Messaggio : null;
    }
    /**
     * Set Messaggio value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Service\StructType\Messaggio[] $messaggio
     * @return \Service\ArrayType\ArrayOfMessaggio
     */
    public function setMessaggio(array $messaggio = array())
    {
        if (is_null($messaggio) || (is_array($messaggio) && empty($messaggio))) {
            unset($this->Messaggio);
        } else {
            $this->Messaggio = $messaggio;
        }
        return $this;
    }
    /**
     * Add item to Messaggio value
     * @throws \InvalidArgumentException
     * @param \Service\StructType\Messaggio $item
     * @return \Service\ArrayType\ArrayOfMessaggio
     */
    public function addToMessaggio(\Service\StructType\Messaggio $item)
    {
        $this->Messaggio[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \Service\StructType\Messaggio|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \Service\StructType\Messaggio|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \Service\StructType\Messaggio|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \Service\StructType\Messaggio|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \Service\StructType\Messaggio|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Messaggio
     */
    public function getAttributeName()
    {
        return 'Messaggio';
    }
}
