<?php

namespace Service\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IncassaQuotaAssociativa StructType
 * @subpackage Structs
 */
class IncassaQuotaAssociativa extends AbstractStructBase
{
    /**
     * The IDProdotto
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $IDProdotto;
    /**
     * The TipoVersamento
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TipoVersamento;
    /**
     * The IDAnagrafe
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IDAnagrafe;
    /**
     * The Importo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Importo;
    /**
     * Constructor method for IncassaQuotaAssociativa
     * @uses IncassaQuotaAssociativa::setIDProdotto()
     * @uses IncassaQuotaAssociativa::setTipoVersamento()
     * @uses IncassaQuotaAssociativa::setIDAnagrafe()
     * @uses IncassaQuotaAssociativa::setImporto()
     * @param string $iDProdotto
     * @param int $tipoVersamento
     * @param int $iDAnagrafe
     * @param float $importo
     */
    public function __construct($iDProdotto = null, $tipoVersamento = null, $iDAnagrafe = null, $importo = null)
    {
        $this
            ->setIDProdotto($iDProdotto)
            ->setTipoVersamento($tipoVersamento)
            ->setIDAnagrafe($iDAnagrafe)
            ->setImporto($importo);
    }
    /**
     * Get IDProdotto value
     * @return string|null
     */
    public function getIDProdotto()
    {
        return $this->IDProdotto;
    }
    /**
     * Set IDProdotto value
     * @param string $iDProdotto
     * @return \Service\StructType\IncassaQuotaAssociativa
     */
    public function setIDProdotto($iDProdotto = null)
    {
        $this->IDProdotto = $iDProdotto;
        return $this;
    }
    /**
     * Get TipoVersamento value
     * @return int|null
     */
    public function getTipoVersamento()
    {
        return $this->TipoVersamento;
    }
    /**
     * Set TipoVersamento value
     * @param int $tipoVersamento
     * @return \Service\StructType\IncassaQuotaAssociativa
     */
    public function setTipoVersamento($tipoVersamento = null)
    {
        $this->TipoVersamento = $tipoVersamento;
        return $this;
    }
    /**
     * Get IDAnagrafe value
     * @return int|null
     */
    public function getIDAnagrafe()
    {
        return $this->IDAnagrafe;
    }
    /**
     * Set IDAnagrafe value
     * @param int $iDAnagrafe
     * @return \Service\StructType\IncassaQuotaAssociativa
     */
    public function setIDAnagrafe($iDAnagrafe = null)
    {
        $this->IDAnagrafe = $iDAnagrafe;
        return $this;
    }
    /**
     * Get Importo value
     * @return float|null
     */
    public function getImporto()
    {
        return $this->Importo;
    }
    /**
     * Set Importo value
     * @param float $importo
     * @return \Service\StructType\IncassaQuotaAssociativa
     */
    public function setImporto($importo = null)
    {
        $this->Importo = $importo;
        return $this;
    }
}
