<?php

namespace Service\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GruppoTurni StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GruppoTurni
 * @subpackage Structs
 */
class GruppoTurni extends AbstractStructBase
{
    /**
     * The Descrizione
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Descrizione;
    /**
     * The GiorniDaVisualizzare
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $GiorniDaVisualizzare;
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ID;
    /**
     * The RichiedeAutenticazione
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $RichiedeAutenticazione;
    /**
     * The ScartoGiorni
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ScartoGiorni;
    /**
     * The Tipo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Tipo;
    /**
     * The TipoLayout
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TipoLayout;
    /**
     * The VisualizzaGiorniSenzaTurni
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $VisualizzaGiorniSenzaTurni;
    /**
     * Constructor method for GruppoTurni
     * @uses GruppoTurni::setDescrizione()
     * @uses GruppoTurni::setGiorniDaVisualizzare()
     * @uses GruppoTurni::setID()
     * @uses GruppoTurni::setRichiedeAutenticazione()
     * @uses GruppoTurni::setScartoGiorni()
     * @uses GruppoTurni::setTipo()
     * @uses GruppoTurni::setTipoLayout()
     * @uses GruppoTurni::setVisualizzaGiorniSenzaTurni()
     * @param string $descrizione
     * @param int $giorniDaVisualizzare
     * @param int $iD
     * @param bool $richiedeAutenticazione
     * @param int $scartoGiorni
     * @param string $tipo
     * @param string $tipoLayout
     * @param bool $visualizzaGiorniSenzaTurni
     */
    public function __construct($descrizione = null, $giorniDaVisualizzare = null, $iD = null, $richiedeAutenticazione = null, $scartoGiorni = null, $tipo = null, $tipoLayout = null, $visualizzaGiorniSenzaTurni = null)
    {
        $this
            ->setDescrizione($descrizione)
            ->setGiorniDaVisualizzare($giorniDaVisualizzare)
            ->setID($iD)
            ->setRichiedeAutenticazione($richiedeAutenticazione)
            ->setScartoGiorni($scartoGiorni)
            ->setTipo($tipo)
            ->setTipoLayout($tipoLayout)
            ->setVisualizzaGiorniSenzaTurni($visualizzaGiorniSenzaTurni);
    }
    /**
     * Get Descrizione value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescrizione()
    {
        return isset($this->Descrizione) ? $this->Descrizione : null;
    }
    /**
     * Set Descrizione value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $descrizione
     * @return \Service\StructType\GruppoTurni
     */
    public function setDescrizione($descrizione = null)
    {
        if (is_null($descrizione) || (is_array($descrizione) && empty($descrizione))) {
            unset($this->Descrizione);
        } else {
            $this->Descrizione = $descrizione;
        }
        return $this;
    }
    /**
     * Get GiorniDaVisualizzare value
     * @return int|null
     */
    public function getGiorniDaVisualizzare()
    {
        return $this->GiorniDaVisualizzare;
    }
    /**
     * Set GiorniDaVisualizzare value
     * @param int $giorniDaVisualizzare
     * @return \Service\StructType\GruppoTurni
     */
    public function setGiorniDaVisualizzare($giorniDaVisualizzare = null)
    {
        $this->GiorniDaVisualizzare = $giorniDaVisualizzare;
        return $this;
    }
    /**
     * Get ID value
     * @return int|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \Service\StructType\GruppoTurni
     */
    public function setID($iD = null)
    {
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get RichiedeAutenticazione value
     * @return bool|null
     */
    public function getRichiedeAutenticazione()
    {
        return $this->RichiedeAutenticazione;
    }
    /**
     * Set RichiedeAutenticazione value
     * @param bool $richiedeAutenticazione
     * @return \Service\StructType\GruppoTurni
     */
    public function setRichiedeAutenticazione($richiedeAutenticazione = null)
    {
        $this->RichiedeAutenticazione = $richiedeAutenticazione;
        return $this;
    }
    /**
     * Get ScartoGiorni value
     * @return int|null
     */
    public function getScartoGiorni()
    {
        return $this->ScartoGiorni;
    }
    /**
     * Set ScartoGiorni value
     * @param int $scartoGiorni
     * @return \Service\StructType\GruppoTurni
     */
    public function setScartoGiorni($scartoGiorni = null)
    {
        $this->ScartoGiorni = $scartoGiorni;
        return $this;
    }
    /**
     * Get Tipo value
     * @return string|null
     */
    public function getTipo()
    {
        return $this->Tipo;
    }
    /**
     * Set Tipo value
     * @param string $tipo
     * @return \Service\StructType\GruppoTurni
     */
    public function setTipo($tipo = null)
    {
        $this->Tipo = $tipo;
        return $this;
    }
    /**
     * Get TipoLayout value
     * @return string|null
     */
    public function getTipoLayout()
    {
        return $this->TipoLayout;
    }
    /**
     * Set TipoLayout value
     * @param string $tipoLayout
     * @return \Service\StructType\GruppoTurni
     */
    public function setTipoLayout($tipoLayout = null)
    {
        $this->TipoLayout = $tipoLayout;
        return $this;
    }
    /**
     * Get VisualizzaGiorniSenzaTurni value
     * @return bool|null
     */
    public function getVisualizzaGiorniSenzaTurni()
    {
        return $this->VisualizzaGiorniSenzaTurni;
    }
    /**
     * Set VisualizzaGiorniSenzaTurni value
     * @param bool $visualizzaGiorniSenzaTurni
     * @return \Service\StructType\GruppoTurni
     */
    public function setVisualizzaGiorniSenzaTurni($visualizzaGiorniSenzaTurni = null)
    {
        $this->VisualizzaGiorniSenzaTurni = $visualizzaGiorniSenzaTurni;
        return $this;
    }
}
