<?php

namespace Service\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfSezione ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfSezione
 * @subpackage Arrays
 */
class ArrayOfSezione extends AbstractStructArrayBase
{
    /**
     * The Sezione
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Service\StructType\Sezione[]
     */
    public $Sezione;
    /**
     * Constructor method for ArrayOfSezione
     * @uses ArrayOfSezione::setSezione()
     * @param \Service\StructType\Sezione[] $sezione
     */
    public function __construct(array $sezione = array())
    {
        $this
            ->setSezione($sezione);
    }
    /**
     * Get Sezione value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Service\StructType\Sezione[]|null
     */
    public function getSezione()
    {
        return isset($this->Sezione) ? $this->Sezione : null;
    }
    /**
     * Set Sezione value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Service\StructType\Sezione[] $sezione
     * @return \Service\ArrayType\ArrayOfSezione
     */
    public function setSezione(array $sezione = array())
    {
        if (is_null($sezione) || (is_array($sezione) && empty($sezione))) {
            unset($this->Sezione);
        } else {
            $this->Sezione = $sezione;
        }
        return $this;
    }
    /**
     * Add item to Sezione value
     * @throws \InvalidArgumentException
     * @param \Service\StructType\Sezione $item
     * @return \Service\ArrayType\ArrayOfSezione
     */
    public function addToSezione(\Service\StructType\Sezione $item)
    {
        $this->Sezione[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \Service\StructType\Sezione|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \Service\StructType\Sezione|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \Service\StructType\Sezione|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \Service\StructType\Sezione|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \Service\StructType\Sezione|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Sezione
     */
    public function getAttributeName()
    {
        return 'Sezione';
    }
}
