<?php

namespace Service\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfEPartecipante ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfEPartecipante
 * @subpackage Arrays
 */
class ArrayOfEPartecipante extends AbstractStructArrayBase
{
    /**
     * The EPartecipante
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Service\StructType\EPartecipante[]
     */
    public $EPartecipante;
    /**
     * Constructor method for ArrayOfEPartecipante
     * @uses ArrayOfEPartecipante::setEPartecipante()
     * @param \Service\StructType\EPartecipante[] $ePartecipante
     */
    public function __construct(array $ePartecipante = array())
    {
        $this
            ->setEPartecipante($ePartecipante);
    }
    /**
     * Get EPartecipante value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Service\StructType\EPartecipante[]|null
     */
    public function getEPartecipante()
    {
        return isset($this->EPartecipante) ? $this->EPartecipante : null;
    }
    /**
     * Set EPartecipante value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Service\StructType\EPartecipante[] $ePartecipante
     * @return \Service\ArrayType\ArrayOfEPartecipante
     */
    public function setEPartecipante(array $ePartecipante = array())
    {
        if (is_null($ePartecipante) || (is_array($ePartecipante) && empty($ePartecipante))) {
            unset($this->EPartecipante);
        } else {
            $this->EPartecipante = $ePartecipante;
        }
        return $this;
    }
    /**
     * Add item to EPartecipante value
     * @throws \InvalidArgumentException
     * @param \Service\StructType\EPartecipante $item
     * @return \Service\ArrayType\ArrayOfEPartecipante
     */
    public function addToEPartecipante(\Service\StructType\EPartecipante $item)
    {
        $this->EPartecipante[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \Service\StructType\EPartecipante|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \Service\StructType\EPartecipante|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \Service\StructType\EPartecipante|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \Service\StructType\EPartecipante|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \Service\StructType\EPartecipante|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string EPartecipante
     */
    public function getAttributeName()
    {
        return 'EPartecipante';
    }
}
