<?php

namespace Service\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetListaArticoliSegnalazioneGuasto StructType
 * @subpackage Structs
 */
class GetListaArticoliSegnalazioneGuasto extends AbstractStructBase
{
    /**
     * The Tipologia
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Tipologia;
    /**
     * The ArticoloPrincipale
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ArticoloPrincipale;
    /**
     * Constructor method for GetListaArticoliSegnalazioneGuasto
     * @uses GetListaArticoliSegnalazioneGuasto::setTipologia()
     * @uses GetListaArticoliSegnalazioneGuasto::setArticoloPrincipale()
     * @param string $tipologia
     * @param string $articoloPrincipale
     */
    public function __construct($tipologia = null, $articoloPrincipale = null)
    {
        $this
            ->setTipologia($tipologia)
            ->setArticoloPrincipale($articoloPrincipale);
    }
    /**
     * Get Tipologia value
     * @return string|null
     */
    public function getTipologia()
    {
        return $this->Tipologia;
    }
    /**
     * Set Tipologia value
     * @uses \Service\EnumType\TipiSegnalazioneGuasto::valueIsValid()
     * @uses \Service\EnumType\TipiSegnalazioneGuasto::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tipologia
     * @return \Service\StructType\GetListaArticoliSegnalazioneGuasto
     */
    public function setTipologia($tipologia = null)
    {
        // validation for constraint: enumeration
        if (!\Service\EnumType\TipiSegnalazioneGuasto::valueIsValid($tipologia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Service\EnumType\TipiSegnalazioneGuasto', is_array($tipologia) ? implode(', ', $tipologia) : var_export($tipologia, true), implode(', ', \Service\EnumType\TipiSegnalazioneGuasto::getValidValues())), __LINE__);
        }
        $this->Tipologia = $tipologia;
        return $this;
    }
    /**
     * Get ArticoloPrincipale value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getArticoloPrincipale()
    {
        return isset($this->ArticoloPrincipale) ? $this->ArticoloPrincipale : null;
    }
    /**
     * Set ArticoloPrincipale value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $articoloPrincipale
     * @return \Service\StructType\GetListaArticoliSegnalazioneGuasto
     */
    public function setArticoloPrincipale($articoloPrincipale = null)
    {
        // validation for constraint: string
        if (!is_null($articoloPrincipale) && !is_string($articoloPrincipale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($articoloPrincipale, true), gettype($articoloPrincipale)), __LINE__);
        }
        if (is_null($articoloPrincipale) || (is_array($articoloPrincipale) && empty($articoloPrincipale))) {
            unset($this->ArticoloPrincipale);
        } else {
            $this->ArticoloPrincipale = $articoloPrincipale;
        }
        return $this;
    }
}
