<?php

namespace Service\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetLastPresenza_Result StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetLastPresenza_Result
 * @subpackage Structs
 */
class GetLastPresenza_Result extends AbstractStructBase
{
    /**
     * The Informazioni
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Service\StructType\AdditionaInformation
     */
    public $Informazioni;
    /**
     * The Presenza
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Service\StructType\Presenza
     */
    public $Presenza;
    /**
     * Constructor method for GetLastPresenza_Result
     * @uses GetLastPresenza_Result::setInformazioni()
     * @uses GetLastPresenza_Result::setPresenza()
     * @param \Service\StructType\AdditionaInformation $informazioni
     * @param \Service\StructType\Presenza $presenza
     */
    public function __construct(\Service\StructType\AdditionaInformation $informazioni = null, \Service\StructType\Presenza $presenza = null)
    {
        $this
            ->setInformazioni($informazioni)
            ->setPresenza($presenza);
    }
    /**
     * Get Informazioni value
     * @return \Service\StructType\AdditionaInformation|null
     */
    public function getInformazioni()
    {
        return $this->Informazioni;
    }
    /**
     * Set Informazioni value
     * @param \Service\StructType\AdditionaInformation $informazioni
     * @return \Service\StructType\GetLastPresenza_Result
     */
    public function setInformazioni(\Service\StructType\AdditionaInformation $informazioni = null)
    {
        $this->Informazioni = $informazioni;
        return $this;
    }
    /**
     * Get Presenza value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Service\StructType\Presenza|null
     */
    public function getPresenza()
    {
        return isset($this->Presenza) ? $this->Presenza : null;
    }
    /**
     * Set Presenza value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Service\StructType\Presenza $presenza
     * @return \Service\StructType\GetLastPresenza_Result
     */
    public function setPresenza(\Service\StructType\Presenza $presenza = null)
    {
        if (is_null($presenza) || (is_array($presenza) && empty($presenza))) {
            unset($this->Presenza);
        } else {
            $this->Presenza = $presenza;
        }
        return $this;
    }
}
