<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for all operations
 * @subpackage Services
 */
class Service extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetVersion
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetVersion $parameters
     * @return \StructType\GetVersionResponse|bool
     */
    public function GetVersion(\StructType\GetVersion $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetVersion($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Login
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Login $parameters
     * @return \StructType\LoginResponse|bool
     */
    public function Login(\StructType\Login $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->Login($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RegistraFCMToken
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RegistraFCMToken $parameters
     * @return \StructType\RegistraFCMTokenResponse|bool
     */
    public function RegistraFCMToken(\StructType\RegistraFCMToken $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RegistraFCMToken($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UnRegisterFCMToken
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UnRegisterFCMToken $parameters
     * @return \StructType\UnRegisterFCMTokenResponse|bool
     */
    public function UnRegisterFCMToken(\StructType\UnRegisterFCMToken $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UnRegisterFCMToken($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Login_Tessera
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Login_Tessera $parameters
     * @return \StructType\Login_TesseraResponse|bool
     */
    public function Login_Tessera(\StructType\Login_Tessera $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->Login_Tessera($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Login_EasyGAV_Web
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Login_EasyGAV_Web $parameters
     * @return \StructType\Login_EasyGAV_WebResponse|bool
     */
    public function Login_EasyGAV_Web(\StructType\Login_EasyGAV_Web $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->Login_EasyGAV_Web($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Login_SGEServer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Login_SGEServer $parameters
     * @return \StructType\Login_SGEServerResponse|bool
     */
    public function Login_SGEServer(\StructType\Login_SGEServer $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->Login_SGEServer($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetInternalProtocolVersion
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetInternalProtocolVersion $parameters
     * @return \StructType\GetInternalProtocolVersionResponse|bool
     */
    public function GetInternalProtocolVersion(\StructType\GetInternalProtocolVersion $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetInternalProtocolVersion($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetProfilo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetProfilo $parameters
     * @return \StructType\GetProfiloResponse|bool
     */
    public function GetProfilo(\StructType\GetProfilo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetProfilo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateUser
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateUser $parameters
     * @return \StructType\UpdateUserResponse|bool
     */
    public function UpdateUser(\StructType\UpdateUser $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateUser($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateUserProfilePhoto
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateUserProfilePhoto $parameters
     * @return \StructType\UpdateUserProfilePhotoResponse|bool
     */
    public function UpdateUserProfilePhoto(\StructType\UpdateUserProfilePhoto $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateUserProfilePhoto($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetConfigurazione
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetConfigurazione $parameters
     * @return \StructType\GetConfigurazioneResponse|bool
     */
    public function GetConfigurazione(\StructType\GetConfigurazione $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetConfigurazione($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named InviaPresenza
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\InviaPresenza $parameters
     * @return \StructType\InviaPresenzaResponse|bool
     */
    public function InviaPresenza(\StructType\InviaPresenza $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->InviaPresenza($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named InviaPresenza2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\InviaPresenza2 $parameters
     * @return \StructType\InviaPresenza2Response|bool
     */
    public function InviaPresenza2(\StructType\InviaPresenza2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->InviaPresenza2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named InviaPresenza3
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\InviaPresenza3 $parameters
     * @return \StructType\InviaPresenza3Response|bool
     */
    public function InviaPresenza3(\StructType\InviaPresenza3 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->InviaPresenza3($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCheckList_Richieste
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCheckList_Richieste $parameters
     * @return \StructType\GetCheckList_RichiesteResponse|bool
     */
    public function GetCheckList_Richieste(\StructType\GetCheckList_Richieste $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCheckList_Richieste($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetRegioni
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetRegioni $parameters
     * @return \StructType\GetRegioniResponse|bool
     */
    public function GetRegioni(\StructType\GetRegioni $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetRegioni($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetProvince
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetProvince $parameters
     * @return \StructType\GetProvinceResponse|bool
     */
    public function GetProvince(\StructType\GetProvince $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetProvince($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetComuni
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetComuni $parameters
     * @return \StructType\GetComuniResponse|bool
     */
    public function GetComuni(\StructType\GetComuni $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetComuni($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetRecapiti
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetRecapiti $parameters
     * @return \StructType\GetRecapitiResponse|bool
     */
    public function GetRecapiti(\StructType\GetRecapiti $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetRecapiti($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetRecapito
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetRecapito $parameters
     * @return \StructType\GetRecapitoResponse|bool
     */
    public function GetRecapito(\StructType\GetRecapito $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetRecapito($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SalvaRecapito
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SalvaRecapito $parameters
     * @return \StructType\SalvaRecapitoResponse|bool
     */
    public function SalvaRecapito(\StructType\SalvaRecapito $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SalvaRecapito($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteRecapito
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeleteRecapito $parameters
     * @return \StructType\DeleteRecapitoResponse|bool
     */
    public function DeleteRecapito(\StructType\DeleteRecapito $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DeleteRecapito($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetQualifiche
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetQualifiche $parameters
     * @return \StructType\GetQualificheResponse|bool
     */
    public function GetQualifiche(\StructType\GetQualifiche $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetQualifiche($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SendRecapiti
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SendRecapiti $parameters
     * @return \StructType\SendRecapitiResponse|bool
     */
    public function SendRecapiti(\StructType\SendRecapiti $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SendRecapiti($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCorsi
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCorsi $parameters
     * @return \StructType\GetCorsiResponse|bool
     */
    public function GetCorsi(\StructType\GetCorsi $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCorsi($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCorsiUtente
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCorsiUtente $parameters
     * @return \StructType\GetCorsiUtenteResponse|bool
     */
    public function GetCorsiUtente(\StructType\GetCorsiUtente $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCorsiUtente($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CancellaIscrizioneACorso
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CancellaIscrizioneACorso $parameters
     * @return \StructType\CancellaIscrizioneACorsoResponse|bool
     */
    public function CancellaIscrizioneACorso(\StructType\CancellaIscrizioneACorso $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CancellaIscrizioneACorso($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SendCorsoRegistrazione
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SendCorsoRegistrazione $parameters
     * @return \StructType\SendCorsoRegistrazioneResponse|bool
     */
    public function SendCorsoRegistrazione(\StructType\SendCorsoRegistrazione $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SendCorsoRegistrazione($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SendCorsoCancellaRegistrazione
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SendCorsoCancellaRegistrazione $parameters
     * @return \StructType\SendCorsoCancellaRegistrazioneResponse|bool
     */
    public function SendCorsoCancellaRegistrazione(\StructType\SendCorsoCancellaRegistrazione $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SendCorsoCancellaRegistrazione($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetTurni
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetTurni $parameters
     * @return \StructType\GetTurniResponse|bool
     */
    public function GetTurni(\StructType\GetTurni $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetTurni($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetTurniOperatore
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetTurniOperatore $parameters
     * @return \StructType\GetTurniOperatoreResponse|bool
     */
    public function GetTurniOperatore(\StructType\GetTurniOperatore $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetTurniOperatore($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetEventiOperatore
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetEventiOperatore $parameters
     * @return \StructType\GetEventiOperatoreResponse|bool
     */
    public function GetEventiOperatore(\StructType\GetEventiOperatore $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetEventiOperatore($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCalendarioTurni
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCalendarioTurni $parameters
     * @return \StructType\GetCalendarioTurniResponse|bool
     */
    public function GetCalendarioTurni(\StructType\GetCalendarioTurni $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCalendarioTurni($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCalendarioTurniLite
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCalendarioTurniLite $parameters
     * @return \StructType\GetCalendarioTurniLiteResponse|bool
     */
    public function GetCalendarioTurniLite(\StructType\GetCalendarioTurniLite $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCalendarioTurniLite($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetEventi
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetEventi $parameters
     * @return \StructType\GetEventiResponse|bool
     */
    public function GetEventi(\StructType\GetEventi $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetEventi($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCalendarioEventi
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCalendarioEventi $parameters
     * @return \StructType\GetCalendarioEventiResponse|bool
     */
    public function GetCalendarioEventi(\StructType\GetCalendarioEventi $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCalendarioEventi($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetTurnoSpecifico
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetTurnoSpecifico $parameters
     * @return \StructType\GetTurnoSpecificoResponse|bool
     */
    public function GetTurnoSpecifico(\StructType\GetTurnoSpecifico $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetTurnoSpecifico($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetTurnoSpecifico2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetTurnoSpecifico2 $parameters
     * @return \StructType\GetTurnoSpecifico2Response|bool
     */
    public function GetTurnoSpecifico2(\StructType\GetTurnoSpecifico2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetTurnoSpecifico2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetGiornoEvento
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetGiornoEvento $parameters
     * @return \StructType\GetGiornoEventoResponse|bool
     */
    public function GetGiornoEvento(\StructType\GetGiornoEvento $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetGiornoEvento($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named IscrizioneTurno
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\IscrizioneTurno $parameters
     * @return \StructType\IscrizioneTurnoResponse|bool
     */
    public function IscrizioneTurno(\StructType\IscrizioneTurno $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->IscrizioneTurno($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named IscrizioneTurno2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\IscrizioneTurno2 $parameters
     * @return \StructType\IscrizioneTurno2Response|bool
     */
    public function IscrizioneTurno2(\StructType\IscrizioneTurno2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->IscrizioneTurno2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ModificaIscrizioneTurno
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ModificaIscrizioneTurno $parameters
     * @return \StructType\ModificaIscrizioneTurnoResponse|bool
     */
    public function ModificaIscrizioneTurno(\StructType\ModificaIscrizioneTurno $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ModificaIscrizioneTurno($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ModificaIscrizioneTurno2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ModificaIscrizioneTurno2 $parameters
     * @return \StructType\ModificaIscrizioneTurno2Response|bool
     */
    public function ModificaIscrizioneTurno2(\StructType\ModificaIscrizioneTurno2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ModificaIscrizioneTurno2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named IscrizioneEvento
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\IscrizioneEvento $parameters
     * @return \StructType\IscrizioneEventoResponse|bool
     */
    public function IscrizioneEvento(\StructType\IscrizioneEvento $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->IscrizioneEvento($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CancellazioneIscrizioneTurno
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CancellazioneIscrizioneTurno $parameters
     * @return \StructType\CancellazioneIscrizioneTurnoResponse|bool
     */
    public function CancellazioneIscrizioneTurno(\StructType\CancellazioneIscrizioneTurno $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CancellazioneIscrizioneTurno($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CancellazioneIscrizioneTurno2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CancellazioneIscrizioneTurno2 $parameters
     * @return \StructType\CancellazioneIscrizioneTurno2Response|bool
     */
    public function CancellazioneIscrizioneTurno2(\StructType\CancellazioneIscrizioneTurno2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CancellazioneIscrizioneTurno2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CancellazioneIscrizioneEvento
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CancellazioneIscrizioneEvento $parameters
     * @return \StructType\CancellazioneIscrizioneEventoResponse|bool
     */
    public function CancellazioneIscrizioneEvento(\StructType\CancellazioneIscrizioneEvento $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CancellazioneIscrizioneEvento($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAttivitaUtente
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAttivitaUtente $parameters
     * @return \StructType\GetAttivitaUtenteResponse|bool
     */
    public function GetAttivitaUtente(\StructType\GetAttivitaUtente $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAttivitaUtente($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetMessaggi
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetMessaggi $parameters
     * @return \StructType\GetMessaggiResponse|bool
     */
    public function GetMessaggi(\StructType\GetMessaggi $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetMessaggi($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetLastPresenza
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetLastPresenza $parameters
     * @return \StructType\GetLastPresenzaResponse|bool
     */
    public function GetLastPresenza(\StructType\GetLastPresenza $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetLastPresenza($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetLastPresenza2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetLastPresenza2 $parameters
     * @return \StructType\GetLastPresenza2Response|bool
     */
    public function GetLastPresenza2(\StructType\GetLastPresenza2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetLastPresenza2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetNotifiche
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetNotifiche $parameters
     * @return \StructType\GetNotificheResponse|bool
     */
    public function GetNotifiche(\StructType\GetNotifiche $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetNotifiche($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetTestoNotifica
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetTestoNotifica $parameters
     * @return \StructType\GetTestoNotificaResponse|bool
     */
    public function GetTestoNotifica(\StructType\GetTestoNotifica $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetTestoNotifica($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetTotaleNotificheDaNotificare
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetTotaleNotificheDaNotificare $parameters
     * @return \StructType\GetTotaleNotificheDaNotificareResponse|bool
     */
    public function GetTotaleNotificheDaNotificare(\StructType\GetTotaleNotificheDaNotificare $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetTotaleNotificheDaNotificare($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetNotificaLetta
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetNotificaLetta $parameters
     * @return \StructType\SetNotificaLettaResponse|bool
     */
    public function SetNotificaLetta(\StructType\SetNotificaLetta $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SetNotificaLetta($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetNotificheNotificate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetNotificheNotificate $parameters
     * @return \StructType\SetNotificheNotificateResponse|bool
     */
    public function SetNotificheNotificate(\StructType\SetNotificheNotificate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SetNotificheNotificate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RicercaAnagrafe
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RicercaAnagrafe $parameters
     * @return \StructType\RicercaAnagrafeResponse|bool
     */
    public function RicercaAnagrafe(\StructType\RicercaAnagrafe $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RicercaAnagrafe($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAnagrafe
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAnagrafe $parameters
     * @return \StructType\GetAnagrafeResponse|bool
     */
    public function GetAnagrafe(\StructType\GetAnagrafe $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAnagrafe($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SalvaAnagrafe
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SalvaAnagrafe $parameters
     * @return \StructType\SalvaAnagrafeResponse|bool
     */
    public function SalvaAnagrafe(\StructType\SalvaAnagrafe $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SalvaAnagrafe($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named IncassaQuotaAssociativa
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\IncassaQuotaAssociativa $parameters
     * @return \StructType\IncassaQuotaAssociativaResponse|bool
     */
    public function IncassaQuotaAssociativa(\StructType\IncassaQuotaAssociativa $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->IncassaQuotaAssociativa($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AnnullaIncassoQuotaAssociativa
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AnnullaIncassoQuotaAssociativa $parameters
     * @return \StructType\AnnullaIncassoQuotaAssociativaResponse|bool
     */
    public function AnnullaIncassoQuotaAssociativa(\StructType\AnnullaIncassoQuotaAssociativa $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AnnullaIncassoQuotaAssociativa($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named StampaModuloPrivacy
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\StampaModuloPrivacy $parameters
     * @return \StructType\StampaModuloPrivacyResponse|bool
     */
    public function StampaModuloPrivacy(\StructType\StampaModuloPrivacy $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->StampaModuloPrivacy($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RinnovaPrivacy
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RinnovaPrivacy $parameters
     * @return \StructType\RinnovaPrivacyResponse|bool
     */
    public function RinnovaPrivacy(\StructType\RinnovaPrivacy $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RinnovaPrivacy($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RevocaPrivacy
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RevocaPrivacy $parameters
     * @return \StructType\RevocaPrivacyResponse|bool
     */
    public function RevocaPrivacy(\StructType\RevocaPrivacy $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RevocaPrivacy($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCsvSociConRecapito
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCsvSociConRecapito $parameters
     * @return \StructType\GetCsvSociConRecapitoResponse|bool
     */
    public function GetCsvSociConRecapito(\StructType\GetCsvSociConRecapito $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCsvSociConRecapito($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCsvSituazionePrivacy
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCsvSituazionePrivacy $parameters
     * @return \StructType\GetCsvSituazionePrivacyResponse|bool
     */
    public function GetCsvSituazionePrivacy(\StructType\GetCsvSituazionePrivacy $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCsvSituazionePrivacy($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCsvCampagnaSoci
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCsvCampagnaSoci $parameters
     * @return \StructType\GetCsvCampagnaSociResponse|bool
     */
    public function GetCsvCampagnaSoci(\StructType\GetCsvCampagnaSoci $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCsvCampagnaSoci($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetListaSegnalazioniGuasto
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetListaSegnalazioniGuasto $parameters
     * @return \StructType\GetListaSegnalazioniGuastoResponse|bool
     */
    public function GetListaSegnalazioniGuasto(\StructType\GetListaSegnalazioniGuasto $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetListaSegnalazioniGuasto($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetListaArticoliSegnalazioneGuasto
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetListaArticoliSegnalazioneGuasto $parameters
     * @return \StructType\GetListaArticoliSegnalazioneGuastoResponse|bool
     */
    public function GetListaArticoliSegnalazioneGuasto(\StructType\GetListaArticoliSegnalazioneGuasto $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetListaArticoliSegnalazioneGuasto($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SendSegnalazioneGuasto
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SendSegnalazioneGuasto $parameters
     * @return \StructType\SendSegnalazioneGuastoResponse|bool
     */
    public function SendSegnalazioneGuasto(\StructType\SendSegnalazioneGuasto $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SendSegnalazioneGuasto($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RiassegnaMezzoMissioni
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RiassegnaMezzoMissioni $parameters
     * @return \StructType\RiassegnaMezzoMissioniResponse|bool
     */
    public function RiassegnaMezzoMissioni(\StructType\RiassegnaMezzoMissioni $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RiassegnaMezzoMissioni($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named InsertRichiestaCartellino
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\InsertRichiestaCartellino $parameters
     * @return \StructType\InsertRichiestaCartellinoResponse|bool
     */
    public function InsertRichiestaCartellino(\StructType\InsertRichiestaCartellino $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->InsertRichiestaCartellino($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateRichiestaCartellino
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateRichiestaCartellino $parameters
     * @return \StructType\UpdateRichiestaCartellinoResponse|bool
     */
    public function UpdateRichiestaCartellino(\StructType\UpdateRichiestaCartellino $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateRichiestaCartellino($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetRichiesteCartellino
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetRichiesteCartellino $parameters
     * @return \StructType\GetRichiesteCartellinoResponse|bool
     */
    public function GetRichiesteCartellino(\StructType\GetRichiesteCartellino $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetRichiesteCartellino($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetRichiestaCartellino
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetRichiestaCartellino $parameters
     * @return \StructType\GetRichiestaCartellinoResponse|bool
     */
    public function GetRichiestaCartellino(\StructType\GetRichiestaCartellino $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetRichiestaCartellino($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteRichiestaCartellino
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeleteRichiestaCartellino $parameters
     * @return \StructType\DeleteRichiestaCartellinoResponse|bool
     */
    public function DeleteRichiestaCartellino(\StructType\DeleteRichiestaCartellino $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DeleteRichiestaCartellino($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named InsertEventolRichiestaCartellino
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\InsertEventolRichiestaCartellino $parameters
     * @return \StructType\InsertEventolRichiestaCartellinoResponse|bool
     */
    public function InsertEventolRichiestaCartellino(\StructType\InsertEventolRichiestaCartellino $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->InsertEventolRichiestaCartellino($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetListaRuoliOperatori
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetListaRuoliOperatori $parameters
     * @return \StructType\GetListaRuoliOperatoriResponse|bool
     */
    public function GetListaRuoliOperatori(\StructType\GetListaRuoliOperatori $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetListaRuoliOperatori($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetListaStradari
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetListaStradari $parameters
     * @return \StructType\GetListaStradariResponse|bool
     */
    public function GetListaStradari(\StructType\GetListaStradari $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetListaStradari($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CheckGreenPass
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CheckGreenPass $parameters
     * @return \StructType\CheckGreenPassResponse|bool
     */
    public function CheckGreenPass(\StructType\CheckGreenPass $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CheckGreenPass($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\AnnullaIncassoQuotaAssociativaResponse|\StructType\CancellaIscrizioneACorsoResponse|\StructType\CancellazioneIscrizioneEventoResponse|\StructType\CancellazioneIscrizioneTurno2Response|\StructType\CancellazioneIscrizioneTurnoResponse|\StructType\CheckGreenPassResponse|\StructType\DeleteRecapitoResponse|\StructType\DeleteRichiestaCartellinoResponse|\StructType\GetAnagrafeResponse|\StructType\GetAttivitaUtenteResponse|\StructType\GetCalendarioEventiResponse|\StructType\GetCalendarioTurniLiteResponse|\StructType\GetCalendarioTurniResponse|\StructType\GetCheckList_RichiesteResponse|\StructType\GetComuniResponse|\StructType\GetConfigurazioneResponse|\StructType\GetCorsiResponse|\StructType\GetCorsiUtenteResponse|\StructType\GetCsvCampagnaSociResponse|\StructType\GetCsvSituazionePrivacyResponse|\StructType\GetCsvSociConRecapitoResponse|\StructType\GetEventiOperatoreResponse|\StructType\GetEventiResponse|\StructType\GetGiornoEventoResponse|\StructType\GetInternalProtocolVersionResponse|\StructType\GetLastPresenza2Response|\StructType\GetLastPresenzaResponse|\StructType\GetListaArticoliSegnalazioneGuastoResponse|\StructType\GetListaRuoliOperatoriResponse|\StructType\GetListaSegnalazioniGuastoResponse|\StructType\GetListaStradariResponse|\StructType\GetMessaggiResponse|\StructType\GetNotificheResponse|\StructType\GetProfiloResponse|\StructType\GetProvinceResponse|\StructType\GetQualificheResponse|\StructType\GetRecapitiResponse|\StructType\GetRecapitoResponse|\StructType\GetRegioniResponse|\StructType\GetRichiestaCartellinoResponse|\StructType\GetRichiesteCartellinoResponse|\StructType\GetTestoNotificaResponse|\StructType\GetTotaleNotificheDaNotificareResponse|\StructType\GetTurniOperatoreResponse|\StructType\GetTurniResponse|\StructType\GetTurnoSpecifico2Response|\StructType\GetTurnoSpecificoResponse|\StructType\GetVersionResponse|\StructType\IncassaQuotaAssociativaResponse|\StructType\InsertEventolRichiestaCartellinoResponse|\StructType\InsertRichiestaCartellinoResponse|\StructType\InviaPresenza2Response|\StructType\InviaPresenza3Response|\StructType\InviaPresenzaResponse|\StructType\IscrizioneEventoResponse|\StructType\IscrizioneTurno2Response|\StructType\IscrizioneTurnoResponse|\StructType\LoginResponse|\StructType\Login_EasyGAV_WebResponse|\StructType\Login_SGEServerResponse|\StructType\Login_TesseraResponse|\StructType\ModificaIscrizioneTurno2Response|\StructType\ModificaIscrizioneTurnoResponse|\StructType\RegistraFCMTokenResponse|\StructType\RevocaPrivacyResponse|\StructType\RiassegnaMezzoMissioniResponse|\StructType\RicercaAnagrafeResponse|\StructType\RinnovaPrivacyResponse|\StructType\SalvaAnagrafeResponse|\StructType\SalvaRecapitoResponse|\StructType\SendCorsoCancellaRegistrazioneResponse|\StructType\SendCorsoRegistrazioneResponse|\StructType\SendRecapitiResponse|\StructType\SendSegnalazioneGuastoResponse|\StructType\SetNotificaLettaResponse|\StructType\SetNotificheNotificateResponse|\StructType\StampaModuloPrivacyResponse|\StructType\UnRegisterFCMTokenResponse|\StructType\UpdateRichiestaCartellinoResponse|\StructType\UpdateUserProfilePhotoResponse|\StructType\UpdateUserResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
