<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RichiestaCartellino_Motivo StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RichiestaCartellino_Motivo
 * @subpackage Structs
 */
class RichiestaCartellino_Motivo extends AbstractStructBase
{
    /**
     * The DaApprovare
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $DaApprovare;
    /**
     * The Descrizione
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Descrizione;
    /**
     * The Identificativo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RichiestaCartellino_Motivo_Identificativo
     */
    public $Identificativo;
    /**
     * The Tipologia
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Tipologia;
    /**
     * Constructor method for RichiestaCartellino_Motivo
     * @uses RichiestaCartellino_Motivo::setDaApprovare()
     * @uses RichiestaCartellino_Motivo::setDescrizione()
     * @uses RichiestaCartellino_Motivo::setIdentificativo()
     * @uses RichiestaCartellino_Motivo::setTipologia()
     * @param bool $daApprovare
     * @param string $descrizione
     * @param \StructType\RichiestaCartellino_Motivo_Identificativo $identificativo
     * @param string $tipologia
     */
    public function __construct($daApprovare = null, $descrizione = null, \StructType\RichiestaCartellino_Motivo_Identificativo $identificativo = null, $tipologia = null)
    {
        $this
            ->setDaApprovare($daApprovare)
            ->setDescrizione($descrizione)
            ->setIdentificativo($identificativo)
            ->setTipologia($tipologia);
    }
    /**
     * Get DaApprovare value
     * @return bool|null
     */
    public function getDaApprovare()
    {
        return $this->DaApprovare;
    }
    /**
     * Set DaApprovare value
     * @param bool $daApprovare
     * @return \StructType\RichiestaCartellino_Motivo
     */
    public function setDaApprovare($daApprovare = null)
    {
        // validation for constraint: boolean
        if (!is_null($daApprovare) && !is_bool($daApprovare)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($daApprovare, true), gettype($daApprovare)), __LINE__);
        }
        $this->DaApprovare = $daApprovare;
        return $this;
    }
    /**
     * Get Descrizione value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescrizione()
    {
        return isset($this->Descrizione) ? $this->Descrizione : null;
    }
    /**
     * Set Descrizione value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $descrizione
     * @return \StructType\RichiestaCartellino_Motivo
     */
    public function setDescrizione($descrizione = null)
    {
        // validation for constraint: string
        if (!is_null($descrizione) && !is_string($descrizione)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descrizione, true), gettype($descrizione)), __LINE__);
        }
        if (is_null($descrizione) || (is_array($descrizione) && empty($descrizione))) {
            unset($this->Descrizione);
        } else {
            $this->Descrizione = $descrizione;
        }
        return $this;
    }
    /**
     * Get Identificativo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RichiestaCartellino_Motivo_Identificativo|null
     */
    public function getIdentificativo()
    {
        return isset($this->Identificativo) ? $this->Identificativo : null;
    }
    /**
     * Set Identificativo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\RichiestaCartellino_Motivo_Identificativo $identificativo
     * @return \StructType\RichiestaCartellino_Motivo
     */
    public function setIdentificativo(\StructType\RichiestaCartellino_Motivo_Identificativo $identificativo = null)
    {
        if (is_null($identificativo) || (is_array($identificativo) && empty($identificativo))) {
            unset($this->Identificativo);
        } else {
            $this->Identificativo = $identificativo;
        }
        return $this;
    }
    /**
     * Get Tipologia value
     * @return string|null
     */
    public function getTipologia()
    {
        return $this->Tipologia;
    }
    /**
     * Set Tipologia value
     * @uses \EnumType\RichestaCartellino_TipiMotivazione::valueIsValid()
     * @uses \EnumType\RichestaCartellino_TipiMotivazione::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tipologia
     * @return \StructType\RichiestaCartellino_Motivo
     */
    public function setTipologia($tipologia = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RichestaCartellino_TipiMotivazione::valueIsValid($tipologia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\RichestaCartellino_TipiMotivazione', is_array($tipologia) ? implode(', ', $tipologia) : var_export($tipologia, true), implode(', ', \EnumType\RichestaCartellino_TipiMotivazione::getValidValues())), __LINE__);
        }
        $this->Tipologia = $tipologia;
        return $this;
    }
}
