<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetRecapiti_Result StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetRecapiti_Result
 * @subpackage Structs
 */
class GetRecapiti_Result extends AbstractStructBase
{
    /**
     * The Informazioni
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AdditionaInformation
     */
    public $Informazioni;
    /**
     * The Recapiti
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfRecapito
     */
    public $Recapiti;
    /**
     * Constructor method for GetRecapiti_Result
     * @uses GetRecapiti_Result::setInformazioni()
     * @uses GetRecapiti_Result::setRecapiti()
     * @param \StructType\AdditionaInformation $informazioni
     * @param \ArrayType\ArrayOfRecapito $recapiti
     */
    public function __construct(\StructType\AdditionaInformation $informazioni = null, \ArrayType\ArrayOfRecapito $recapiti = null)
    {
        $this
            ->setInformazioni($informazioni)
            ->setRecapiti($recapiti);
    }
    /**
     * Get Informazioni value
     * @return \StructType\AdditionaInformation|null
     */
    public function getInformazioni()
    {
        return $this->Informazioni;
    }
    /**
     * Set Informazioni value
     * @param \StructType\AdditionaInformation $informazioni
     * @return \StructType\GetRecapiti_Result
     */
    public function setInformazioni(\StructType\AdditionaInformation $informazioni = null)
    {
        $this->Informazioni = $informazioni;
        return $this;
    }
    /**
     * Get Recapiti value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfRecapito|null
     */
    public function getRecapiti()
    {
        return isset($this->Recapiti) ? $this->Recapiti : null;
    }
    /**
     * Set Recapiti value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfRecapito $recapiti
     * @return \StructType\GetRecapiti_Result
     */
    public function setRecapiti(\ArrayType\ArrayOfRecapito $recapiti = null)
    {
        if (is_null($recapiti) || (is_array($recapiti) && empty($recapiti))) {
            unset($this->Recapiti);
        } else {
            $this->Recapiti = $recapiti;
        }
        return $this;
    }
}
