<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfSezione ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfSezione
 * @subpackage Arrays
 */
class ArrayOfSezione extends AbstractStructArrayBase
{
    /**
     * The Sezione
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Sezione[]
     */
    public $Sezione;
    /**
     * Constructor method for ArrayOfSezione
     * @uses ArrayOfSezione::setSezione()
     * @param \StructType\Sezione[] $sezione
     */
    public function __construct(array $sezione = array())
    {
        $this
            ->setSezione($sezione);
    }
    /**
     * Get Sezione value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Sezione[]|null
     */
    public function getSezione()
    {
        return isset($this->Sezione) ? $this->Sezione : null;
    }
    /**
     * This method is responsible for validating the values passed to the setSezione method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSezione method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSezioneForArrayConstraintsFromSetSezione(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfSezioneSezioneItem) {
            // validation for constraint: itemType
            if (!$arrayOfSezioneSezioneItem instanceof \StructType\Sezione) {
                $invalidValues[] = is_object($arrayOfSezioneSezioneItem) ? get_class($arrayOfSezioneSezioneItem) : sprintf('%s(%s)', gettype($arrayOfSezioneSezioneItem), var_export($arrayOfSezioneSezioneItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Sezione property can only contain items of type \StructType\Sezione, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Sezione value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Sezione[] $sezione
     * @return \ArrayType\ArrayOfSezione
     */
    public function setSezione(array $sezione = array())
    {
        // validation for constraint: array
        if ('' !== ($sezioneArrayErrorMessage = self::validateSezioneForArrayConstraintsFromSetSezione($sezione))) {
            throw new \InvalidArgumentException($sezioneArrayErrorMessage, __LINE__);
        }
        if (is_null($sezione) || (is_array($sezione) && empty($sezione))) {
            unset($this->Sezione);
        } else {
            $this->Sezione = $sezione;
        }
        return $this;
    }
    /**
     * Add item to Sezione value
     * @throws \InvalidArgumentException
     * @param \StructType\Sezione $item
     * @return \ArrayType\ArrayOfSezione
     */
    public function addToSezione(\StructType\Sezione $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Sezione) {
            throw new \InvalidArgumentException(sprintf('The Sezione property can only contain items of type \StructType\Sezione, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Sezione[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Sezione|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Sezione|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Sezione|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Sezione|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Sezione|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Sezione
     */
    public function getAttributeName()
    {
        return 'Sezione';
    }
}
