<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StampaModuloPrivacy StructType
 * @subpackage Structs
 */
class StampaModuloPrivacy extends AbstractStructBase
{
    /**
     * The IDAnagrafe
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IDAnagrafe;
    /**
     * The Tipo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Tipo;
    /**
     * Constructor method for StampaModuloPrivacy
     * @uses StampaModuloPrivacy::setIDAnagrafe()
     * @uses StampaModuloPrivacy::setTipo()
     * @param int $iDAnagrafe
     * @param string $tipo
     */
    public function __construct($iDAnagrafe = null, $tipo = null)
    {
        $this
            ->setIDAnagrafe($iDAnagrafe)
            ->setTipo($tipo);
    }
    /**
     * Get IDAnagrafe value
     * @return int|null
     */
    public function getIDAnagrafe()
    {
        return $this->IDAnagrafe;
    }
    /**
     * Set IDAnagrafe value
     * @param int $iDAnagrafe
     * @return StampaModuloPrivacy
     */
    public function setIDAnagrafe($iDAnagrafe = null)
    {
        // validation for constraint: int
        if (!is_null($iDAnagrafe) && !(is_int($iDAnagrafe) || ctype_digit($iDAnagrafe))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iDAnagrafe, true), gettype($iDAnagrafe)), __LINE__);
        }
        $this->IDAnagrafe = $iDAnagrafe;
        return $this;
    }
    /**
     * Get Tipo value
     * @return string|null
     */
    public function getTipo()
    {
        return $this->Tipo;
    }
    /**
     * Set Tipo value
     * @uses TipoReportPrivacy::valueIsValid()
     * @uses TipoReportPrivacy::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tipo
     * @return StampaModuloPrivacy
     */
    public function setTipo($tipo = null)
    {
        // validation for constraint: enumeration
        if (!TipoReportPrivacy::valueIsValid($tipo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class TipoReportPrivacy', is_array($tipo) ? implode(', ', $tipo) : var_export($tipo, true), implode(', ', TipoReportPrivacy::getValidValues())), __LINE__);
        }
        $this->Tipo = $tipo;
        return $this;
    }
}
