<?php
use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Set ServiceType
 * @subpackage Services
 */
class Set extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SetNotificaLetta
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param SetNotificaLetta $parameters
     * @return SetNotificaLettaResponse|bool
     */
    public function SetNotificaLetta(SetNotificaLetta $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SetNotificaLetta($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetNotificheNotificate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param SetNotificheNotificate $parameters
     * @return SetNotificheNotificateResponse|bool
     */
    public function SetNotificheNotificate(SetNotificheNotificate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SetNotificheNotificate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return SetNotificaLettaResponse|SetNotificheNotificateResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
