<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RichiestaCartellino_Evento StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RichiestaCartellino_Evento
 * @subpackage Structs
 */
class RichiestaCartellino_Evento extends AbstractStructBase
{
    /**
     * The DataInserimento
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DataInserimento;
    /**
     * The IDRichiesta
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var RichiestaCartellino_Identificativo
     */
    public $IDRichiesta;
    /**
     * The Identificativo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var RichiestaCartellino_Evento_Identificativo
     */
    public $Identificativo;
    /**
     * The Note
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Note;
    /**
     * The TipoEvento
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TipoEvento;
    /**
     * The Utente
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var AnagraficaModel
     */
    public $Utente;
    /**
     * Constructor method for RichiestaCartellino_Evento
     * @uses RichiestaCartellino_Evento::setDataInserimento()
     * @uses RichiestaCartellino_Evento::setIDRichiesta()
     * @uses RichiestaCartellino_Evento::setIdentificativo()
     * @uses RichiestaCartellino_Evento::setNote()
     * @uses RichiestaCartellino_Evento::setTipoEvento()
     * @uses RichiestaCartellino_Evento::setUtente()
     * @param string $dataInserimento
     * @param RichiestaCartellino_Identificativo $iDRichiesta
     * @param RichiestaCartellino_Evento_Identificativo $identificativo
     * @param string $note
     * @param string $tipoEvento
     * @param AnagraficaModel $utente
     */
    public function __construct($dataInserimento = null, RichiestaCartellino_Identificativo $iDRichiesta = null, RichiestaCartellino_Evento_Identificativo $identificativo = null, $note = null, $tipoEvento = null, AnagraficaModel $utente = null)
    {
        $this
            ->setDataInserimento($dataInserimento)
            ->setIDRichiesta($iDRichiesta)
            ->setIdentificativo($identificativo)
            ->setNote($note)
            ->setTipoEvento($tipoEvento)
            ->setUtente($utente);
    }
    /**
     * Get DataInserimento value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDataInserimento()
    {
        return isset($this->DataInserimento) ? $this->DataInserimento : null;
    }
    /**
     * Set DataInserimento value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dataInserimento
     * @return RichiestaCartellino_Evento
     */
    public function setDataInserimento($dataInserimento = null)
    {
        // validation for constraint: string
        if (!is_null($dataInserimento) && !is_string($dataInserimento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataInserimento, true), gettype($dataInserimento)), __LINE__);
        }
        if (is_null($dataInserimento) || (is_array($dataInserimento) && empty($dataInserimento))) {
            unset($this->DataInserimento);
        } else {
            $this->DataInserimento = $dataInserimento;
        }
        return $this;
    }
    /**
     * Get IDRichiesta value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return RichiestaCartellino_Identificativo|null
     */
    public function getIDRichiesta()
    {
        return isset($this->IDRichiesta) ? $this->IDRichiesta : null;
    }
    /**
     * Set IDRichiesta value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param RichiestaCartellino_Identificativo $iDRichiesta
     * @return RichiestaCartellino_Evento
     */
    public function setIDRichiesta(RichiestaCartellino_Identificativo $iDRichiesta = null)
    {
        if (is_null($iDRichiesta) || (is_array($iDRichiesta) && empty($iDRichiesta))) {
            unset($this->IDRichiesta);
        } else {
            $this->IDRichiesta = $iDRichiesta;
        }
        return $this;
    }
    /**
     * Get Identificativo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return RichiestaCartellino_Evento_Identificativo|null
     */
    public function getIdentificativo()
    {
        return isset($this->Identificativo) ? $this->Identificativo : null;
    }
    /**
     * Set Identificativo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param RichiestaCartellino_Evento_Identificativo $identificativo
     * @return RichiestaCartellino_Evento
     */
    public function setIdentificativo(RichiestaCartellino_Evento_Identificativo $identificativo = null)
    {
        if (is_null($identificativo) || (is_array($identificativo) && empty($identificativo))) {
            unset($this->Identificativo);
        } else {
            $this->Identificativo = $identificativo;
        }
        return $this;
    }
    /**
     * Get Note value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNote()
    {
        return isset($this->Note) ? $this->Note : null;
    }
    /**
     * Set Note value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $note
     * @return RichiestaCartellino_Evento
     */
    public function setNote($note = null)
    {
        // validation for constraint: string
        if (!is_null($note) && !is_string($note)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($note, true), gettype($note)), __LINE__);
        }
        if (is_null($note) || (is_array($note) && empty($note))) {
            unset($this->Note);
        } else {
            $this->Note = $note;
        }
        return $this;
    }
    /**
     * Get TipoEvento value
     * @return string|null
     */
    public function getTipoEvento()
    {
        return $this->TipoEvento;
    }
    /**
     * Set TipoEvento value
     * @uses RichestaCartellino_TipiEvento::valueIsValid()
     * @uses RichestaCartellino_TipiEvento::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tipoEvento
     * @return RichiestaCartellino_Evento
     */
    public function setTipoEvento($tipoEvento = null)
    {
        // validation for constraint: enumeration
        if (!RichestaCartellino_TipiEvento::valueIsValid($tipoEvento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class RichestaCartellino_TipiEvento', is_array($tipoEvento) ? implode(', ', $tipoEvento) : var_export($tipoEvento, true), implode(', ', RichestaCartellino_TipiEvento::getValidValues())), __LINE__);
        }
        $this->TipoEvento = $tipoEvento;
        return $this;
    }
    /**
     * Get Utente value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return AnagraficaModel|null
     */
    public function getUtente()
    {
        return isset($this->Utente) ? $this->Utente : null;
    }
    /**
     * Set Utente value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param AnagraficaModel $utente
     * @return RichiestaCartellino_Evento
     */
    public function setUtente(AnagraficaModel $utente = null)
    {
        if (is_null($utente) || (is_array($utente) && empty($utente))) {
            unset($this->Utente);
        } else {
            $this->Utente = $utente;
        }
        return $this;
    }
}
