<?php
use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Ricerca ServiceType
 * @subpackage Services
 */
class Ricerca extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named RicercaAnagrafe
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param RicercaAnagrafe $parameters
     * @return RicercaAnagrafeResponse|bool
     */
    public function RicercaAnagrafe(RicercaAnagrafe $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RicercaAnagrafe($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return RicercaAnagrafeResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
