<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RevocaPrivacy StructType
 * @subpackage Structs
 */
class RevocaPrivacy extends AbstractStructBase
{
    /**
     * The IDProdotto
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $IDProdotto;
    /**
     * The IDAnagrafe
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IDAnagrafe;
    /**
     * The IDPrivacy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IDPrivacy;
    /**
     * Constructor method for RevocaPrivacy
     * @uses RevocaPrivacy::setIDProdotto()
     * @uses RevocaPrivacy::setIDAnagrafe()
     * @uses RevocaPrivacy::setIDPrivacy()
     * @param string $iDProdotto
     * @param int $iDAnagrafe
     * @param int $iDPrivacy
     */
    public function __construct($iDProdotto = null, $iDAnagrafe = null, $iDPrivacy = null)
    {
        $this
            ->setIDProdotto($iDProdotto)
            ->setIDAnagrafe($iDAnagrafe)
            ->setIDPrivacy($iDPrivacy);
    }
    /**
     * Get IDProdotto value
     * @return string|null
     */
    public function getIDProdotto()
    {
        return $this->IDProdotto;
    }
    /**
     * Set IDProdotto value
     * @uses SoftwareClient::valueIsValid()
     * @uses SoftwareClient::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $iDProdotto
     * @return RevocaPrivacy
     */
    public function setIDProdotto($iDProdotto = null)
    {
        // validation for constraint: enumeration
        if (!SoftwareClient::valueIsValid($iDProdotto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class SoftwareClient', is_array($iDProdotto) ? implode(', ', $iDProdotto) : var_export($iDProdotto, true), implode(', ', SoftwareClient::getValidValues())), __LINE__);
        }
        $this->IDProdotto = $iDProdotto;
        return $this;
    }
    /**
     * Get IDAnagrafe value
     * @return int|null
     */
    public function getIDAnagrafe()
    {
        return $this->IDAnagrafe;
    }
    /**
     * Set IDAnagrafe value
     * @param int $iDAnagrafe
     * @return RevocaPrivacy
     */
    public function setIDAnagrafe($iDAnagrafe = null)
    {
        // validation for constraint: int
        if (!is_null($iDAnagrafe) && !(is_int($iDAnagrafe) || ctype_digit($iDAnagrafe))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iDAnagrafe, true), gettype($iDAnagrafe)), __LINE__);
        }
        $this->IDAnagrafe = $iDAnagrafe;
        return $this;
    }
    /**
     * Get IDPrivacy value
     * @return int|null
     */
    public function getIDPrivacy()
    {
        return $this->IDPrivacy;
    }
    /**
     * Set IDPrivacy value
     * @param int $iDPrivacy
     * @return RevocaPrivacy
     */
    public function setIDPrivacy($iDPrivacy = null)
    {
        // validation for constraint: int
        if (!is_null($iDPrivacy) && !(is_int($iDPrivacy) || ctype_digit($iDPrivacy))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iDPrivacy, true), gettype($iDPrivacy)), __LINE__);
        }
        $this->IDPrivacy = $iDPrivacy;
        return $this;
    }
}
