<?php
use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Login ServiceType
 * @subpackage Services
 */
class Login extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named Login
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param Login $parameters
     * @return LoginResponse|bool
     */
    public function Login(Login $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->Login($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Login_Tessera
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param Login_Tessera $parameters
     * @return Login_TesseraResponse|bool
     */
    public function Login_Tessera(Login_Tessera $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->Login_Tessera($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Login_EasyGAV_Web
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param Login_EasyGAV_Web $parameters
     * @return Login_EasyGAV_WebResponse|bool
     */
    public function Login_EasyGAV_Web(Login_EasyGAV_Web $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->Login_EasyGAV_Web($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Login_SGEServer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param Login_SGEServer $parameters
     * @return Login_SGEServerResponse|bool
     */
    public function Login_SGEServer(Login_SGEServer $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->Login_SGEServer($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return LoginResponse|Login_EasyGAV_WebResponse|Login_SGEServerResponse|Login_TesseraResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
