<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetRegioni_Result StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetRegioni_Result
 * @subpackage Structs
 */
class GetRegioni_Result extends AbstractStructBase
{
    /**
     * The Informazioni
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var AdditionaInformation
     */
    public $Informazioni;
    /**
     * The Regioni
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var ArrayOfResultCodiceDescrizione
     */
    public $Regioni;
    /**
     * Constructor method for GetRegioni_Result
     * @uses GetRegioni_Result::setInformazioni()
     * @uses GetRegioni_Result::setRegioni()
     * @param AdditionaInformation $informazioni
     * @param ArrayOfResultCodiceDescrizione $regioni
     */
    public function __construct(AdditionaInformation $informazioni = null, ArrayOfResultCodiceDescrizione $regioni = null)
    {
        $this
            ->setInformazioni($informazioni)
            ->setRegioni($regioni);
    }
    /**
     * Get Informazioni value
     * @return AdditionaInformation|null
     */
    public function getInformazioni()
    {
        return $this->Informazioni;
    }
    /**
     * Set Informazioni value
     * @param AdditionaInformation $informazioni
     * @return GetRegioni_Result
     */
    public function setInformazioni(AdditionaInformation $informazioni = null)
    {
        $this->Informazioni = $informazioni;
        return $this;
    }
    /**
     * Get Regioni value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return ArrayOfResultCodiceDescrizione|null
     */
    public function getRegioni()
    {
        return isset($this->Regioni) ? $this->Regioni : null;
    }
    /**
     * Set Regioni value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param ArrayOfResultCodiceDescrizione $regioni
     * @return GetRegioni_Result
     */
    public function setRegioni(ArrayOfResultCodiceDescrizione $regioni = null)
    {
        if (is_null($regioni) || (is_array($regioni) && empty($regioni))) {
            unset($this->Regioni);
        } else {
            $this->Regioni = $regioni;
        }
        return $this;
    }
}
