<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetRecapiti_Result StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetRecapiti_Result
 * @subpackage Structs
 */
class GetRecapiti_Result extends AbstractStructBase
{
    /**
     * The Informazioni
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var AdditionaInformation
     */
    public $Informazioni;
    /**
     * The Recapiti
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var ArrayOfRecapito
     */
    public $Recapiti;
    /**
     * Constructor method for GetRecapiti_Result
     * @uses GetRecapiti_Result::setInformazioni()
     * @uses GetRecapiti_Result::setRecapiti()
     * @param AdditionaInformation $informazioni
     * @param ArrayOfRecapito $recapiti
     */
    public function __construct(AdditionaInformation $informazioni = null, ArrayOfRecapito $recapiti = null)
    {
        $this
            ->setInformazioni($informazioni)
            ->setRecapiti($recapiti);
    }
    /**
     * Get Informazioni value
     * @return AdditionaInformation|null
     */
    public function getInformazioni()
    {
        return $this->Informazioni;
    }
    /**
     * Set Informazioni value
     * @param AdditionaInformation $informazioni
     * @return GetRecapiti_Result
     */
    public function setInformazioni(AdditionaInformation $informazioni = null)
    {
        $this->Informazioni = $informazioni;
        return $this;
    }
    /**
     * Get Recapiti value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return ArrayOfRecapito|null
     */
    public function getRecapiti()
    {
        return isset($this->Recapiti) ? $this->Recapiti : null;
    }
    /**
     * Set Recapiti value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param ArrayOfRecapito $recapiti
     * @return GetRecapiti_Result
     */
    public function setRecapiti(ArrayOfRecapito $recapiti = null)
    {
        if (is_null($recapiti) || (is_array($recapiti) && empty($recapiti))) {
            unset($this->Recapiti);
        } else {
            $this->Recapiti = $recapiti;
        }
        return $this;
    }
}
