<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetQualifiche_Result StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetQualifiche_Result
 * @subpackage Structs
 */
class GetQualifiche_Result extends AbstractStructBase
{
    /**
     * The Informazioni
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var AdditionaInformation
     */
    public $Informazioni;
    /**
     * The Qualifiche
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var ArrayOfQualifica
     */
    public $Qualifiche;
    /**
     * Constructor method for GetQualifiche_Result
     * @uses GetQualifiche_Result::setInformazioni()
     * @uses GetQualifiche_Result::setQualifiche()
     * @param AdditionaInformation $informazioni
     * @param ArrayOfQualifica $qualifiche
     */
    public function __construct(AdditionaInformation $informazioni = null, ArrayOfQualifica $qualifiche = null)
    {
        $this
            ->setInformazioni($informazioni)
            ->setQualifiche($qualifiche);
    }
    /**
     * Get Informazioni value
     * @return AdditionaInformation|null
     */
    public function getInformazioni()
    {
        return $this->Informazioni;
    }
    /**
     * Set Informazioni value
     * @param AdditionaInformation $informazioni
     * @return GetQualifiche_Result
     */
    public function setInformazioni(AdditionaInformation $informazioni = null)
    {
        $this->Informazioni = $informazioni;
        return $this;
    }
    /**
     * Get Qualifiche value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return ArrayOfQualifica|null
     */
    public function getQualifiche()
    {
        return isset($this->Qualifiche) ? $this->Qualifiche : null;
    }
    /**
     * Set Qualifiche value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param ArrayOfQualifica $qualifiche
     * @return GetQualifiche_Result
     */
    public function setQualifiche(ArrayOfQualifica $qualifiche = null)
    {
        if (is_null($qualifiche) || (is_array($qualifiche) && empty($qualifiche))) {
            unset($this->Qualifiche);
        } else {
            $this->Qualifiche = $qualifiche;
        }
        return $this;
    }
}
