<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetEventiOperatore StructType
 * @subpackage Structs
 */
class GetEventiOperatore extends AbstractStructBase
{
    /**
     * The IDAnagrafe
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IDAnagrafe;
    /**
     * The DaData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DaData;
    /**
     * The Esercizio
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Esercizio;
    /**
     * The Registro
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Registro;
    /**
     * The Numero
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Numero;
    /**
     * The Riga
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Riga;
    /**
     * Constructor method for GetEventiOperatore
     * @uses GetEventiOperatore::setIDAnagrafe()
     * @uses GetEventiOperatore::setDaData()
     * @uses GetEventiOperatore::setEsercizio()
     * @uses GetEventiOperatore::setRegistro()
     * @uses GetEventiOperatore::setNumero()
     * @uses GetEventiOperatore::setRiga()
     * @param int $iDAnagrafe
     * @param string $daData
     * @param string $esercizio
     * @param string $registro
     * @param int $numero
     * @param int $riga
     */
    public function __construct($iDAnagrafe = null, $daData = null, $esercizio = null, $registro = null, $numero = null, $riga = null)
    {
        $this
            ->setIDAnagrafe($iDAnagrafe)
            ->setDaData($daData)
            ->setEsercizio($esercizio)
            ->setRegistro($registro)
            ->setNumero($numero)
            ->setRiga($riga);
    }
    /**
     * Get IDAnagrafe value
     * @return int|null
     */
    public function getIDAnagrafe()
    {
        return $this->IDAnagrafe;
    }
    /**
     * Set IDAnagrafe value
     * @param int $iDAnagrafe
     * @return GetEventiOperatore
     */
    public function setIDAnagrafe($iDAnagrafe = null)
    {
        // validation for constraint: int
        if (!is_null($iDAnagrafe) && !(is_int($iDAnagrafe) || ctype_digit($iDAnagrafe))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iDAnagrafe, true), gettype($iDAnagrafe)), __LINE__);
        }
        $this->IDAnagrafe = $iDAnagrafe;
        return $this;
    }
    /**
     * Get DaData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDaData()
    {
        return isset($this->DaData) ? $this->DaData : null;
    }
    /**
     * Set DaData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $daData
     * @return GetEventiOperatore
     */
    public function setDaData($daData = null)
    {
        // validation for constraint: string
        if (!is_null($daData) && !is_string($daData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($daData, true), gettype($daData)), __LINE__);
        }
        if (is_null($daData) || (is_array($daData) && empty($daData))) {
            unset($this->DaData);
        } else {
            $this->DaData = $daData;
        }
        return $this;
    }
    /**
     * Get Esercizio value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEsercizio()
    {
        return isset($this->Esercizio) ? $this->Esercizio : null;
    }
    /**
     * Set Esercizio value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $esercizio
     * @return GetEventiOperatore
     */
    public function setEsercizio($esercizio = null)
    {
        // validation for constraint: string
        if (!is_null($esercizio) && !is_string($esercizio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($esercizio, true), gettype($esercizio)), __LINE__);
        }
        if (is_null($esercizio) || (is_array($esercizio) && empty($esercizio))) {
            unset($this->Esercizio);
        } else {
            $this->Esercizio = $esercizio;
        }
        return $this;
    }
    /**
     * Get Registro value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRegistro()
    {
        return isset($this->Registro) ? $this->Registro : null;
    }
    /**
     * Set Registro value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $registro
     * @return GetEventiOperatore
     */
    public function setRegistro($registro = null)
    {
        // validation for constraint: string
        if (!is_null($registro) && !is_string($registro)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($registro, true), gettype($registro)), __LINE__);
        }
        if (is_null($registro) || (is_array($registro) && empty($registro))) {
            unset($this->Registro);
        } else {
            $this->Registro = $registro;
        }
        return $this;
    }
    /**
     * Get Numero value
     * @return int|null
     */
    public function getNumero()
    {
        return $this->Numero;
    }
    /**
     * Set Numero value
     * @param int $numero
     * @return GetEventiOperatore
     */
    public function setNumero($numero = null)
    {
        // validation for constraint: int
        if (!is_null($numero) && !(is_int($numero) || ctype_digit($numero))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numero, true), gettype($numero)), __LINE__);
        }
        $this->Numero = $numero;
        return $this;
    }
    /**
     * Get Riga value
     * @return int|null
     */
    public function getRiga()
    {
        return $this->Riga;
    }
    /**
     * Set Riga value
     * @param int $riga
     * @return GetEventiOperatore
     */
    public function setRiga($riga = null)
    {
        // validation for constraint: int
        if (!is_null($riga) && !(is_int($riga) || ctype_digit($riga))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($riga, true), gettype($riga)), __LINE__);
        }
        $this->Riga = $riga;
        return $this;
    }
}
