<?php
use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetVersion
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetVersion $parameters
     * @return GetVersionResponse|bool
     */
    public function GetVersion(GetVersion $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetVersion($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetInternalProtocolVersion
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetInternalProtocolVersion $parameters
     * @return GetInternalProtocolVersionResponse|bool
     */
    public function GetInternalProtocolVersion(GetInternalProtocolVersion $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetInternalProtocolVersion($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetProfilo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetProfilo $parameters
     * @return GetProfiloResponse|bool
     */
    public function GetProfilo(GetProfilo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetProfilo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetConfigurazione
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetConfigurazione $parameters
     * @return GetConfigurazioneResponse|bool
     */
    public function GetConfigurazione(GetConfigurazione $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetConfigurazione($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCheckList_Richieste
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetCheckList_Richieste $parameters
     * @return GetCheckList_RichiesteResponse|bool
     */
    public function GetCheckList_Richieste(GetCheckList_Richieste $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCheckList_Richieste($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetRegioni
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetRegioni $parameters
     * @return GetRegioniResponse|bool
     */
    public function GetRegioni(GetRegioni $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetRegioni($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetProvince
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetProvince $parameters
     * @return GetProvinceResponse|bool
     */
    public function GetProvince(GetProvince $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetProvince($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetComuni
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetComuni $parameters
     * @return GetComuniResponse|bool
     */
    public function GetComuni(GetComuni $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetComuni($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetRecapiti
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetRecapiti $parameters
     * @return GetRecapitiResponse|bool
     */
    public function GetRecapiti(GetRecapiti $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetRecapiti($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetRecapito
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetRecapito $parameters
     * @return GetRecapitoResponse|bool
     */
    public function GetRecapito(GetRecapito $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetRecapito($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetQualifiche
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetQualifiche $parameters
     * @return GetQualificheResponse|bool
     */
    public function GetQualifiche(GetQualifiche $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetQualifiche($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCorsi
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetCorsi $parameters
     * @return GetCorsiResponse|bool
     */
    public function GetCorsi(GetCorsi $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCorsi($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCorsiUtente
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetCorsiUtente $parameters
     * @return GetCorsiUtenteResponse|bool
     */
    public function GetCorsiUtente(GetCorsiUtente $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCorsiUtente($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetTurni
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetTurni $parameters
     * @return GetTurniResponse|bool
     */
    public function GetTurni(GetTurni $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetTurni($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetTurniOperatore
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetTurniOperatore $parameters
     * @return GetTurniOperatoreResponse|bool
     */
    public function GetTurniOperatore(GetTurniOperatore $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetTurniOperatore($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetEventiOperatore
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetEventiOperatore $parameters
     * @return GetEventiOperatoreResponse|bool
     */
    public function GetEventiOperatore(GetEventiOperatore $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetEventiOperatore($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCalendarioTurni
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetCalendarioTurni $parameters
     * @return GetCalendarioTurniResponse|bool
     */
    public function GetCalendarioTurni(GetCalendarioTurni $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCalendarioTurni($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCalendarioTurniLite
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetCalendarioTurniLite $parameters
     * @return GetCalendarioTurniLiteResponse|bool
     */
    public function GetCalendarioTurniLite(GetCalendarioTurniLite $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCalendarioTurniLite($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetEventi
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetEventi $parameters
     * @return GetEventiResponse|bool
     */
    public function GetEventi(GetEventi $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetEventi($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCalendarioEventi
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetCalendarioEventi $parameters
     * @return GetCalendarioEventiResponse|bool
     */
    public function GetCalendarioEventi(GetCalendarioEventi $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCalendarioEventi($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetTurnoSpecifico
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetTurnoSpecifico $parameters
     * @return GetTurnoSpecificoResponse|bool
     */
    public function GetTurnoSpecifico(GetTurnoSpecifico $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetTurnoSpecifico($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetTurnoSpecifico2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetTurnoSpecifico2 $parameters
     * @return GetTurnoSpecifico2Response|bool
     */
    public function GetTurnoSpecifico2(GetTurnoSpecifico2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetTurnoSpecifico2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetGiornoEvento
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetGiornoEvento $parameters
     * @return GetGiornoEventoResponse|bool
     */
    public function GetGiornoEvento(GetGiornoEvento $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetGiornoEvento($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAttivitaUtente
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetAttivitaUtente $parameters
     * @return GetAttivitaUtenteResponse|bool
     */
    public function GetAttivitaUtente(GetAttivitaUtente $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAttivitaUtente($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetMessaggi
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetMessaggi $parameters
     * @return GetMessaggiResponse|bool
     */
    public function GetMessaggi(GetMessaggi $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetMessaggi($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetLastPresenza
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetLastPresenza $parameters
     * @return GetLastPresenzaResponse|bool
     */
    public function GetLastPresenza(GetLastPresenza $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetLastPresenza($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetLastPresenza2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetLastPresenza2 $parameters
     * @return GetLastPresenza2Response|bool
     */
    public function GetLastPresenza2(GetLastPresenza2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetLastPresenza2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetNotifiche
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetNotifiche $parameters
     * @return GetNotificheResponse|bool
     */
    public function GetNotifiche(GetNotifiche $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetNotifiche($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetTestoNotifica
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetTestoNotifica $parameters
     * @return GetTestoNotificaResponse|bool
     */
    public function GetTestoNotifica(GetTestoNotifica $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetTestoNotifica($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetTotaleNotificheDaNotificare
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetTotaleNotificheDaNotificare $parameters
     * @return GetTotaleNotificheDaNotificareResponse|bool
     */
    public function GetTotaleNotificheDaNotificare(GetTotaleNotificheDaNotificare $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetTotaleNotificheDaNotificare($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAnagrafe
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetAnagrafe $parameters
     * @return GetAnagrafeResponse|bool
     */
    public function GetAnagrafe(GetAnagrafe $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAnagrafe($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCsvSociConRecapito
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetCsvSociConRecapito $parameters
     * @return GetCsvSociConRecapitoResponse|bool
     */
    public function GetCsvSociConRecapito(GetCsvSociConRecapito $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCsvSociConRecapito($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCsvSituazionePrivacy
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetCsvSituazionePrivacy $parameters
     * @return GetCsvSituazionePrivacyResponse|bool
     */
    public function GetCsvSituazionePrivacy(GetCsvSituazionePrivacy $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCsvSituazionePrivacy($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCsvCampagnaSoci
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetCsvCampagnaSoci $parameters
     * @return GetCsvCampagnaSociResponse|bool
     */
    public function GetCsvCampagnaSoci(GetCsvCampagnaSoci $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCsvCampagnaSoci($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetListaSegnalazioniGuasto
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetListaSegnalazioniGuasto $parameters
     * @return GetListaSegnalazioniGuastoResponse|bool
     */
    public function GetListaSegnalazioniGuasto(GetListaSegnalazioniGuasto $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetListaSegnalazioniGuasto($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetListaArticoliSegnalazioneGuasto
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetListaArticoliSegnalazioneGuasto $parameters
     * @return GetListaArticoliSegnalazioneGuastoResponse|bool
     */
    public function GetListaArticoliSegnalazioneGuasto(GetListaArticoliSegnalazioneGuasto $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetListaArticoliSegnalazioneGuasto($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetRichiesteCartellino
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetRichiesteCartellino $parameters
     * @return GetRichiesteCartellinoResponse|bool
     */
    public function GetRichiesteCartellino(GetRichiesteCartellino $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetRichiesteCartellino($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetRichiestaCartellino
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetRichiestaCartellino $parameters
     * @return GetRichiestaCartellinoResponse|bool
     */
    public function GetRichiestaCartellino(GetRichiestaCartellino $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetRichiestaCartellino($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetListaRuoliOperatori
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetListaRuoliOperatori $parameters
     * @return GetListaRuoliOperatoriResponse|bool
     */
    public function GetListaRuoliOperatori(GetListaRuoliOperatori $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetListaRuoliOperatori($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetListaStradari
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetListaStradari $parameters
     * @return GetListaStradariResponse|bool
     */
    public function GetListaStradari(GetListaStradari $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetListaStradari($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return GetAnagrafeResponse|GetAttivitaUtenteResponse|GetCalendarioEventiResponse|GetCalendarioTurniLiteResponse|GetCalendarioTurniResponse|GetCheckList_RichiesteResponse|GetComuniResponse|GetConfigurazioneResponse|GetCorsiResponse|GetCorsiUtenteResponse|GetCsvCampagnaSociResponse|GetCsvSituazionePrivacyResponse|GetCsvSociConRecapitoResponse|GetEventiOperatoreResponse|GetEventiResponse|GetGiornoEventoResponse|GetInternalProtocolVersionResponse|GetLastPresenza2Response|GetLastPresenzaResponse|GetListaArticoliSegnalazioneGuastoResponse|GetListaRuoliOperatoriResponse|GetListaSegnalazioniGuastoResponse|GetListaStradariResponse|GetMessaggiResponse|GetNotificheResponse|GetProfiloResponse|GetProvinceResponse|GetQualificheResponse|GetRecapitiResponse|GetRecapitoResponse|GetRegioniResponse|GetRichiestaCartellinoResponse|GetRichiesteCartellinoResponse|GetTestoNotificaResponse|GetTotaleNotificheDaNotificareResponse|GetTurniOperatoreResponse|GetTurniResponse|GetTurnoSpecifico2Response|GetTurnoSpecificoResponse|GetVersionResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
