<?php
use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Delete ServiceType
 * @subpackage Services
 */
class Delete extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named DeleteRecapito
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param DeleteRecapito $parameters
     * @return DeleteRecapitoResponse|bool
     */
    public function DeleteRecapito(DeleteRecapito $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DeleteRecapito($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteRichiestaCartellino
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param DeleteRichiestaCartellino $parameters
     * @return DeleteRichiestaCartellinoResponse|bool
     */
    public function DeleteRichiestaCartellino(DeleteRichiestaCartellino $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DeleteRichiestaCartellino($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return DeleteRecapitoResponse|DeleteRichiestaCartellinoResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
