<?php
use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfMessaggio ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfMessaggio
 * @subpackage Arrays
 */
class ArrayOfMessaggio extends AbstractStructArrayBase
{
    /**
     * The Messaggio
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var Messaggio[]
     */
    public $Messaggio;
    /**
     * Constructor method for ArrayOfMessaggio
     * @uses ArrayOfMessaggio::setMessaggio()
     * @param Messaggio[] $messaggio
     */
    public function __construct(array $messaggio = array())
    {
        $this
            ->setMessaggio($messaggio);
    }
    /**
     * Get Messaggio value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return Messaggio[]|null
     */
    public function getMessaggio()
    {
        return isset($this->Messaggio) ? $this->Messaggio : null;
    }
    /**
     * This method is responsible for validating the values passed to the setMessaggio method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMessaggio method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMessaggioForArrayConstraintsFromSetMessaggio(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfMessaggioMessaggioItem) {
            // validation for constraint: itemType
            if (!$arrayOfMessaggioMessaggioItem instanceof Messaggio) {
                $invalidValues[] = is_object($arrayOfMessaggioMessaggioItem) ? get_class($arrayOfMessaggioMessaggioItem) : sprintf('%s(%s)', gettype($arrayOfMessaggioMessaggioItem), var_export($arrayOfMessaggioMessaggioItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Messaggio property can only contain items of type Messaggio, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Messaggio value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param Messaggio[] $messaggio
     * @return ArrayOfMessaggio
     */
    public function setMessaggio(array $messaggio = array())
    {
        // validation for constraint: array
        if ('' !== ($messaggioArrayErrorMessage = self::validateMessaggioForArrayConstraintsFromSetMessaggio($messaggio))) {
            throw new \InvalidArgumentException($messaggioArrayErrorMessage, __LINE__);
        }
        if (is_null($messaggio) || (is_array($messaggio) && empty($messaggio))) {
            unset($this->Messaggio);
        } else {
            $this->Messaggio = $messaggio;
        }
        return $this;
    }
    /**
     * Add item to Messaggio value
     * @throws \InvalidArgumentException
     * @param Messaggio $item
     * @return ArrayOfMessaggio
     */
    public function addToMessaggio(Messaggio $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof Messaggio) {
            throw new \InvalidArgumentException(sprintf('The Messaggio property can only contain items of type Messaggio, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Messaggio[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return Messaggio|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return Messaggio|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return Messaggio|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return Messaggio|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return Messaggio|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Messaggio
     */
    public function getAttributeName()
    {
        return 'Messaggio';
    }
}
