<?php
use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfEvento ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfEvento
 * @subpackage Arrays
 */
class ArrayOfEvento extends AbstractStructArrayBase
{
    /**
     * The Evento
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var Evento[]
     */
    public $Evento;
    /**
     * Constructor method for ArrayOfEvento
     * @uses ArrayOfEvento::setEvento()
     * @param Evento[] $evento
     */
    public function __construct(array $evento = array())
    {
        $this
            ->setEvento($evento);
    }
    /**
     * Get Evento value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return Evento[]|null
     */
    public function getEvento()
    {
        return isset($this->Evento) ? $this->Evento : null;
    }
    /**
     * This method is responsible for validating the values passed to the setEvento method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEvento method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEventoForArrayConstraintsFromSetEvento(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfEventoEventoItem) {
            // validation for constraint: itemType
            if (!$arrayOfEventoEventoItem instanceof Evento) {
                $invalidValues[] = is_object($arrayOfEventoEventoItem) ? get_class($arrayOfEventoEventoItem) : sprintf('%s(%s)', gettype($arrayOfEventoEventoItem), var_export($arrayOfEventoEventoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Evento property can only contain items of type Evento, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Evento value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param Evento[] $evento
     * @return ArrayOfEvento
     */
    public function setEvento(array $evento = array())
    {
        // validation for constraint: array
        if ('' !== ($eventoArrayErrorMessage = self::validateEventoForArrayConstraintsFromSetEvento($evento))) {
            throw new \InvalidArgumentException($eventoArrayErrorMessage, __LINE__);
        }
        if (is_null($evento) || (is_array($evento) && empty($evento))) {
            unset($this->Evento);
        } else {
            $this->Evento = $evento;
        }
        return $this;
    }
    /**
     * Add item to Evento value
     * @throws \InvalidArgumentException
     * @param Evento $item
     * @return ArrayOfEvento
     */
    public function addToEvento(Evento $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof Evento) {
            throw new \InvalidArgumentException(sprintf('The Evento property can only contain items of type Evento, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Evento[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return Evento|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return Evento|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return Evento|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return Evento|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return Evento|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Evento
     */
    public function getAttributeName()
    {
        return 'Evento';
    }
}
