<?php
use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Update ServiceType
 * @subpackage Services
 */
class Update extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named UpdateUser
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param UpdateUser $parameters
     * @return UpdateUserResponse|bool
     */
    public function UpdateUser(UpdateUser $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateUser($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateUserProfilePhoto
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param UpdateUserProfilePhoto $parameters
     * @return UpdateUserProfilePhotoResponse|bool
     */
    public function UpdateUserProfilePhoto(UpdateUserProfilePhoto $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateUserProfilePhoto($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateRichiestaCartellino
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param UpdateRichiestaCartellino $parameters
     * @return UpdateRichiestaCartellinoResponse|bool
     */
    public function UpdateRichiestaCartellino(UpdateRichiestaCartellino $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateRichiestaCartellino($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return UpdateRichiestaCartellinoResponse|UpdateUserProfilePhotoResponse|UpdateUserResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
