<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Socio_Model StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Socio_Model
 * @subpackage Structs
 */
class Socio_Model extends AbstractStructBase
{
    /**
     * The Attivo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Attivo;
    /**
     * The Classe
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var Classe_Model
     */
    public $Classe;
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ID;
    /**
     * The ImportoUltimoAnnoPagato
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $ImportoUltimoAnnoPagato;
    /**
     * The IncassoQuotaAnnullabile
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IncassoQuotaAnnullabile;
    /**
     * The QuotaAnnualePagata
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $QuotaAnnualePagata;
    /**
     * The QuotaPagata
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var Quota_Model
     */
    public $QuotaPagata;
    /**
     * The UltimoAnnoPagato
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UltimoAnnoPagato;
    /**
     * Constructor method for Socio_Model
     * @uses Socio_Model::setAttivo()
     * @uses Socio_Model::setClasse()
     * @uses Socio_Model::setID()
     * @uses Socio_Model::setImportoUltimoAnnoPagato()
     * @uses Socio_Model::setIncassoQuotaAnnullabile()
     * @uses Socio_Model::setQuotaAnnualePagata()
     * @uses Socio_Model::setQuotaPagata()
     * @uses Socio_Model::setUltimoAnnoPagato()
     * @param bool $attivo
     * @param Classe_Model $classe
     * @param int $iD
     * @param float $importoUltimoAnnoPagato
     * @param bool $incassoQuotaAnnullabile
     * @param bool $quotaAnnualePagata
     * @param Quota_Model $quotaPagata
     * @param string $ultimoAnnoPagato
     */
    public function __construct($attivo = null, Classe_Model $classe = null, $iD = null, $importoUltimoAnnoPagato = null, $incassoQuotaAnnullabile = null, $quotaAnnualePagata = null, Quota_Model $quotaPagata = null, $ultimoAnnoPagato = null)
    {
        $this
            ->setAttivo($attivo)
            ->setClasse($classe)
            ->setID($iD)
            ->setImportoUltimoAnnoPagato($importoUltimoAnnoPagato)
            ->setIncassoQuotaAnnullabile($incassoQuotaAnnullabile)
            ->setQuotaAnnualePagata($quotaAnnualePagata)
            ->setQuotaPagata($quotaPagata)
            ->setUltimoAnnoPagato($ultimoAnnoPagato);
    }
    /**
     * Get Attivo value
     * @return bool|null
     */
    public function getAttivo()
    {
        return $this->Attivo;
    }
    /**
     * Set Attivo value
     * @param bool $attivo
     * @return Socio_Model
     */
    public function setAttivo($attivo = null)
    {
        // validation for constraint: boolean
        if (!is_null($attivo) && !is_bool($attivo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($attivo, true), gettype($attivo)), __LINE__);
        }
        $this->Attivo = $attivo;
        return $this;
    }
    /**
     * Get Classe value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return Classe_Model|null
     */
    public function getClasse()
    {
        return isset($this->Classe) ? $this->Classe : null;
    }
    /**
     * Set Classe value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param Classe_Model $classe
     * @return Socio_Model
     */
    public function setClasse(Classe_Model $classe = null)
    {
        if (is_null($classe) || (is_array($classe) && empty($classe))) {
            unset($this->Classe);
        } else {
            $this->Classe = $classe;
        }
        return $this;
    }
    /**
     * Get ID value
     * @return int|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return Socio_Model
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !(is_int($iD) || ctype_digit($iD))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get ImportoUltimoAnnoPagato value
     * @return float|null
     */
    public function getImportoUltimoAnnoPagato()
    {
        return $this->ImportoUltimoAnnoPagato;
    }
    /**
     * Set ImportoUltimoAnnoPagato value
     * @param float $importoUltimoAnnoPagato
     * @return Socio_Model
     */
    public function setImportoUltimoAnnoPagato($importoUltimoAnnoPagato = null)
    {
        // validation for constraint: float
        if (!is_null($importoUltimoAnnoPagato) && !(is_float($importoUltimoAnnoPagato) || is_numeric($importoUltimoAnnoPagato))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($importoUltimoAnnoPagato, true), gettype($importoUltimoAnnoPagato)), __LINE__);
        }
        $this->ImportoUltimoAnnoPagato = $importoUltimoAnnoPagato;
        return $this;
    }
    /**
     * Get IncassoQuotaAnnullabile value
     * @return bool|null
     */
    public function getIncassoQuotaAnnullabile()
    {
        return $this->IncassoQuotaAnnullabile;
    }
    /**
     * Set IncassoQuotaAnnullabile value
     * @param bool $incassoQuotaAnnullabile
     * @return Socio_Model
     */
    public function setIncassoQuotaAnnullabile($incassoQuotaAnnullabile = null)
    {
        // validation for constraint: boolean
        if (!is_null($incassoQuotaAnnullabile) && !is_bool($incassoQuotaAnnullabile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($incassoQuotaAnnullabile, true), gettype($incassoQuotaAnnullabile)), __LINE__);
        }
        $this->IncassoQuotaAnnullabile = $incassoQuotaAnnullabile;
        return $this;
    }
    /**
     * Get QuotaAnnualePagata value
     * @return bool|null
     */
    public function getQuotaAnnualePagata()
    {
        return $this->QuotaAnnualePagata;
    }
    /**
     * Set QuotaAnnualePagata value
     * @param bool $quotaAnnualePagata
     * @return Socio_Model
     */
    public function setQuotaAnnualePagata($quotaAnnualePagata = null)
    {
        // validation for constraint: boolean
        if (!is_null($quotaAnnualePagata) && !is_bool($quotaAnnualePagata)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($quotaAnnualePagata, true), gettype($quotaAnnualePagata)), __LINE__);
        }
        $this->QuotaAnnualePagata = $quotaAnnualePagata;
        return $this;
    }
    /**
     * Get QuotaPagata value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return Quota_Model|null
     */
    public function getQuotaPagata()
    {
        return isset($this->QuotaPagata) ? $this->QuotaPagata : null;
    }
    /**
     * Set QuotaPagata value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param Quota_Model $quotaPagata
     * @return Socio_Model
     */
    public function setQuotaPagata(Quota_Model $quotaPagata = null)
    {
        if (is_null($quotaPagata) || (is_array($quotaPagata) && empty($quotaPagata))) {
            unset($this->QuotaPagata);
        } else {
            $this->QuotaPagata = $quotaPagata;
        }
        return $this;
    }
    /**
     * Get UltimoAnnoPagato value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUltimoAnnoPagato()
    {
        return isset($this->UltimoAnnoPagato) ? $this->UltimoAnnoPagato : null;
    }
    /**
     * Set UltimoAnnoPagato value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ultimoAnnoPagato
     * @return Socio_Model
     */
    public function setUltimoAnnoPagato($ultimoAnnoPagato = null)
    {
        // validation for constraint: string
        if (!is_null($ultimoAnnoPagato) && !is_string($ultimoAnnoPagato)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ultimoAnnoPagato, true), gettype($ultimoAnnoPagato)), __LINE__);
        }
        if (is_null($ultimoAnnoPagato) || (is_array($ultimoAnnoPagato) && empty($ultimoAnnoPagato))) {
            unset($this->UltimoAnnoPagato);
        } else {
            $this->UltimoAnnoPagato = $ultimoAnnoPagato;
        }
        return $this;
    }
}
