<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SendCorsoCancellaRegistrazione StructType
 * @subpackage Structs
 */
class SendCorsoCancellaRegistrazione extends AbstractStructBase
{
    /**
     * The Esercizio
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Esercizio;
    /**
     * The Numeratore
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Numeratore;
    /**
     * The Numero
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Numero;
    /**
     * The Riga
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Riga;
    /**
     * The IDAnagrafe
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IDAnagrafe;
    /**
     * Constructor method for SendCorsoCancellaRegistrazione
     * @uses SendCorsoCancellaRegistrazione::setEsercizio()
     * @uses SendCorsoCancellaRegistrazione::setNumeratore()
     * @uses SendCorsoCancellaRegistrazione::setNumero()
     * @uses SendCorsoCancellaRegistrazione::setRiga()
     * @uses SendCorsoCancellaRegistrazione::setIDAnagrafe()
     * @param string $esercizio
     * @param string $numeratore
     * @param int $numero
     * @param int $riga
     * @param int $iDAnagrafe
     */
    public function __construct($esercizio = null, $numeratore = null, $numero = null, $riga = null, $iDAnagrafe = null)
    {
        $this
            ->setEsercizio($esercizio)
            ->setNumeratore($numeratore)
            ->setNumero($numero)
            ->setRiga($riga)
            ->setIDAnagrafe($iDAnagrafe);
    }
    /**
     * Get Esercizio value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEsercizio()
    {
        return isset($this->Esercizio) ? $this->Esercizio : null;
    }
    /**
     * Set Esercizio value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $esercizio
     * @return SendCorsoCancellaRegistrazione
     */
    public function setEsercizio($esercizio = null)
    {
        // validation for constraint: string
        if (!is_null($esercizio) && !is_string($esercizio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($esercizio, true), gettype($esercizio)), __LINE__);
        }
        if (is_null($esercizio) || (is_array($esercizio) && empty($esercizio))) {
            unset($this->Esercizio);
        } else {
            $this->Esercizio = $esercizio;
        }
        return $this;
    }
    /**
     * Get Numeratore value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNumeratore()
    {
        return isset($this->Numeratore) ? $this->Numeratore : null;
    }
    /**
     * Set Numeratore value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $numeratore
     * @return SendCorsoCancellaRegistrazione
     */
    public function setNumeratore($numeratore = null)
    {
        // validation for constraint: string
        if (!is_null($numeratore) && !is_string($numeratore)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numeratore, true), gettype($numeratore)), __LINE__);
        }
        if (is_null($numeratore) || (is_array($numeratore) && empty($numeratore))) {
            unset($this->Numeratore);
        } else {
            $this->Numeratore = $numeratore;
        }
        return $this;
    }
    /**
     * Get Numero value
     * @return int|null
     */
    public function getNumero()
    {
        return $this->Numero;
    }
    /**
     * Set Numero value
     * @param int $numero
     * @return SendCorsoCancellaRegistrazione
     */
    public function setNumero($numero = null)
    {
        // validation for constraint: int
        if (!is_null($numero) && !(is_int($numero) || ctype_digit($numero))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numero, true), gettype($numero)), __LINE__);
        }
        $this->Numero = $numero;
        return $this;
    }
    /**
     * Get Riga value
     * @return int|null
     */
    public function getRiga()
    {
        return $this->Riga;
    }
    /**
     * Set Riga value
     * @param int $riga
     * @return SendCorsoCancellaRegistrazione
     */
    public function setRiga($riga = null)
    {
        // validation for constraint: int
        if (!is_null($riga) && !(is_int($riga) || ctype_digit($riga))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($riga, true), gettype($riga)), __LINE__);
        }
        $this->Riga = $riga;
        return $this;
    }
    /**
     * Get IDAnagrafe value
     * @return int|null
     */
    public function getIDAnagrafe()
    {
        return $this->IDAnagrafe;
    }
    /**
     * Set IDAnagrafe value
     * @param int $iDAnagrafe
     * @return SendCorsoCancellaRegistrazione
     */
    public function setIDAnagrafe($iDAnagrafe = null)
    {
        // validation for constraint: int
        if (!is_null($iDAnagrafe) && !(is_int($iDAnagrafe) || ctype_digit($iDAnagrafe))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iDAnagrafe, true), gettype($iDAnagrafe)), __LINE__);
        }
        $this->IDAnagrafe = $iDAnagrafe;
        return $this;
    }
}
